/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.util.Arrays;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class AbstractSolutionImporter
extends LoggingMain {
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = ".xml";
    protected SolutionDao solutionDao;

    public AbstractSolutionImporter(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
    }

    protected File getInputDir() {
        return new File(this.solutionDao.getDataDir(), "input");
    }

    public abstract String getInputFileSuffix();

    protected File getOutputDir() {
        return new File(this.solutionDao.getDataDir(), "unsolved");
    }

    protected String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public void convertAll() {
        File inputDir = this.getInputDir();
        if (!inputDir.exists()) {
            throw new IllegalStateException("The directory inputDir (" + inputDir.getAbsolutePath() + ") does not exist." + " The working directory should be set to the directory that contains the data directory." + " This is different in a git clone (optaplanner/optaplanner-examples)" + " and the release zip (examples).");
        }
        File outputDir = this.getOutputDir();
        File[] inputFiles = inputDir.listFiles();
        Arrays.sort(inputFiles, new ProblemFileComparator());
        for (File inputFile : inputFiles) {
            if (!this.acceptInputFile(inputFile) || !this.acceptInputFileDuringBulkConvert(inputFile)) continue;
            Solution solution = this.readSolution(inputFile);
            String inputFileName = inputFile.getName();
            String outputFileName = inputFileName.substring(0, inputFileName.length() - this.getInputFileSuffix().length()) + this.getOutputFileSuffix();
            File outputFile = new File(outputDir, outputFileName);
            this.solutionDao.writeSolution(solution, outputFile);
        }
    }

    public boolean acceptInputFile(File inputFile) {
        return inputFile.getName().endsWith(this.getInputFileSuffix());
    }

    public boolean acceptInputFileDuringBulkConvert(File inputFile) {
        return true;
    }

    public abstract Solution readSolution(File var1);
}

