/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.XmlSolverFactory;
import org.optaplanner.core.config.termination.TerminationConfig;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.SolutionFileFilter;
import org.optaplanner.examples.common.persistence.SolutionDao;

@RunWith(value=Parameterized.class)
public abstract class SolveAllTurtleTest
extends LoggingTest {
    protected SolutionDao solutionDao;
    protected File unsolvedDataFile;

    protected static void checkRunTurtleTests() {
        Assume.assumeTrue((boolean)ObjectUtils.equals((Object)"true", (Object)System.getProperty("runTurtleTests")));
    }

    protected static Collection<Object[]> getUnsolvedDataFilesAsParameters(SolutionDao solutionDao) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        File dataDir = solutionDao.getDataDir();
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        List<File> unsolvedFileList = Arrays.asList(unsolvedDataDir.listFiles((FileFilter)new SolutionFileFilter(solutionDao)));
        Collections.sort(unsolvedFileList);
        for (File unsolvedFile : unsolvedFileList) {
            filesAsParameters.add(new Object[]{unsolvedFile});
        }
        return filesAsParameters;
    }

    protected SolveAllTurtleTest(File unsolvedDataFile) {
        this.unsolvedDataFile = unsolvedDataFile;
    }

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
        File dataDir = this.solutionDao.getDataDir();
        if (!dataDir.exists()) {
            throw new IllegalStateException("The directory dataDir (" + dataDir.getAbsolutePath() + ") does not exist." + " The working directory should be set to the directory that contains the data directory." + " This is different in a git clone (optaplanner/optaplanner-examples)" + " and the release zip (examples).");
        }
    }

    protected abstract String createSolverConfigResource();

    protected abstract SolutionDao createSolutionDao();

    @Test
    public void runFastAndFullAssert() {
        SolveAllTurtleTest.checkRunTurtleTests();
        SolverFactory solverFactory = this.buildSolverFactory();
        Solution planningProblem = this.solutionDao.readSolution(this.unsolvedDataFile);
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, planningProblem, 2L);
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.FAST_ASSERT, planningProblem, 5L);
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, planningProblem, 3L);
    }

    protected Solution buildAndSolve(SolverFactory solverFactory, EnvironmentMode environmentMode, Solution planningProblem, long maximumMinutesSpend) {
        solverFactory.getSolverConfig().getTerminationConfig().setMaximumMinutesSpend(Long.valueOf(maximumMinutesSpend));
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        solverConfig.setEnvironmentMode(environmentMode);
        ScoreDirectorFactoryConfig assertionScoreDirectorFactory = this.createOverwritingAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory != null && environmentMode.isAsserted()) {
            solverConfig.getScoreDirectorFactoryConfig().setAssertionScoreDirectorFactory(assertionScoreDirectorFactory);
        }
        Solver solver = solverFactory.buildSolver();
        solver.setPlanningProblem(planningProblem);
        solver.solve();
        Solution bestSolution = solver.getBestSolution();
        if (bestSolution == null) {
            bestSolution = planningProblem;
        }
        return bestSolution;
    }

    protected ScoreDirectorFactoryConfig createOverwritingAssertionScoreDirectorFactory() {
        return null;
    }

    protected SolverFactory buildSolverFactory() {
        XmlSolverFactory solverFactory = new XmlSolverFactory(this.createSolverConfigResource());
        TerminationConfig terminationConfig = new TerminationConfig();
        solverFactory.getSolverConfig().setTerminationConfig(terminationConfig);
        return solverFactory;
    }
}

