/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.optaplanner.examples.cloudbalancing.app.CloudBalancingApp;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.curriculumcourse.app.CurriculumCourseApp;
import org.optaplanner.examples.examination.app.ExaminationApp;
import org.optaplanner.examples.machinereassignment.app.MachineReassignmentApp;
import org.optaplanner.examples.manners2009.app.Manners2009App;
import org.optaplanner.examples.nqueens.app.NQueensApp;
import org.optaplanner.examples.nurserostering.app.NurseRosteringApp;
import org.optaplanner.examples.pas.app.PatientAdmissionScheduleApp;
import org.optaplanner.examples.projectjobscheduling.app.ProjectJobSchedulingApp;
import org.optaplanner.examples.travelingtournament.app.TravelingTournamentApp;
import org.optaplanner.examples.tsp.app.TspApp;
import org.optaplanner.examples.vehiclerouting.app.VehicleRoutingApp;

public class OptaPlannerExamplesApp
extends JFrame {
    private JTextArea descriptionTextArea;

    public static void main(String[] args) {
        CommonApp.fixateLookAndFeel();
        OptaPlannerExamplesApp optaPlannerExamplesApp = new OptaPlannerExamplesApp();
        optaPlannerExamplesApp.pack();
        optaPlannerExamplesApp.setLocationRelativeTo(null);
        optaPlannerExamplesApp.setVisible(true);
    }

    public OptaPlannerExamplesApp() {
        super("OptaPlanner examples");
        this.setIconImage(SolverAndPersistenceFrame.OPTA_PLANNER_ICON.getImage());
        this.setContentPane(this.createContentPane());
        this.setDefaultCloseOperation(3);
    }

    private Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout(10, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel titleLabel = new JLabel("Which example do you want to see?", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(20.0f));
        contentPane.add((Component)titleLabel, "North");
        JScrollPane examplesScrollPane = new JScrollPane(this.createExamplesPanel());
        examplesScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        examplesScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        contentPane.add((Component)examplesScrollPane, "Center");
        contentPane.add((Component)this.createDescriptionPanel(), "South");
        return contentPane;
    }

    private JPanel createExamplesPanel() {
        JPanel examplesPanel = new JPanel();
        examplesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GroupLayout layout = new GroupLayout(examplesPanel);
        examplesPanel.setLayout(layout);
        JPanel basicExamplesPanel = this.createBasicExamplesPanel();
        JPanel realExamplesPanel = this.createRealExamplesPanel();
        JPanel difficultExamplesPanel = this.createDifficultExamplesPanel();
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(basicExamplesPanel).addGap(10).addComponent(realExamplesPanel).addGap(10).addComponent(difficultExamplesPanel));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(basicExamplesPanel).addComponent(realExamplesPanel).addComponent(difficultExamplesPanel));
        return examplesPanel;
    }

    private JPanel createBasicExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Basic examples");
        titledBorder.setTitleColor(TangoColorFactory.CHAMELEON_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton("N queens", "Place queens on a chessboard.\n\nNo 2 queens must be able to attack each other.", "/org/optaplanner/examples/nqueens/swingui/nqueensLogo.png", new Runnable(){

            @Override
            public void run() {
                new NQueensApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Cloud balancing", "Assign processes to computers.\n\nEach computer must have enough hardware to run all of it's processes.\nEach used computer inflicts a maintenance cost.", "/org/optaplanner/examples/cloudbalancing/swingui/cloudBalancingLogo.png", new Runnable(){

            @Override
            public void run() {
                new CloudBalancingApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Traveling salesman", "Official competition name: TSP - Traveling salesman problem\n\nDetermine the order in which to visit all cities.\n\nFind the shortest route to visit all cities.", "/org/optaplanner/examples/tsp/swingui/tspLogo.png", new Runnable(){

            @Override
            public void run() {
                new TspApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Manners 2009", "A much larger variant of the classic Miss Manners problem.\nAssign guests to seats at tables.", null, new Runnable(){

            @Override
            public void run() {
                new Manners2009App().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        return panel;
    }

    private JPanel createRealExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Real examples");
        titledBorder.setTitleColor(TangoColorFactory.BUTTER_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton("Course timetabling", "Official competition name: ITC 2007 track3 - Curriculum course scheduling\n\nAssign lectures to periods and rooms.", null, new Runnable(){

            @Override
            public void run() {
                new CurriculumCourseApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Machine reassignment", "Official competition name: Google ROADEF 2012 - Machine reassignment\n\nReassign processes to machines.", "/org/optaplanner/examples/machinereassignment/swingui/machineReassignmentLogo.png", new Runnable(){

            @Override
            public void run() {
                new MachineReassignmentApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Vehicle routing", "Official competition name: Capacitated vehicle routing problem (CVRP), optionally with time windows (CVRPTW)\n\nPick up all items of all customers with a few vehicles.\n\nFind the shortest route possible.\nDo not overload the capacity of the vehicles.\nArrive within the time window of each customer.", "/org/optaplanner/examples/vehiclerouting/swingui/vehicleRoutingLogo.png", new Runnable(){

            @Override
            public void run() {
                new VehicleRoutingApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Project job scheduling", "Official competition name: multi-mode resource-constrained multi-project scheduling problem (MRCMPSP)\n\nSchedule all jobs in time and execution mode.\n\nMinimize project delays.", "/org/optaplanner/examples/projectjobscheduling/swingui/projectJobSchedulingLogo.png", new Runnable(){

            @Override
            public void run() {
                new ProjectJobSchedulingApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Hospital bed planning", "Official competition name: PAS - Patient admission scheduling\n\nAssign patients to beds.", null, new Runnable(){

            @Override
            public void run() {
                new PatientAdmissionScheduleApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        return panel;
    }

    private JPanel createDifficultExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Difficult examples");
        titledBorder.setTitleColor(TangoColorFactory.SCARLET_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton("Exam timetabling", "Official competition name: ITC 2007 track1 - Examination timetabling\n\nAssign exams to timeslots and rooms.", null, new Runnable(){

            @Override
            public void run() {
                new ExaminationApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Employee rostering", "Official competition name: INRC2010 - Nurse rostering\n\nAssign shifts to employees.", "/org/optaplanner/examples/nurserostering/swingui/nurseRosteringLogo.png", new Runnable(){

            @Override
            public void run() {
                new NurseRosteringApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(this.createExampleButton("Sport scheduling", "Official competition name: TTP - Traveling tournament problem\n\nAssign sport matches to days.", null, new Runnable(){

            @Override
            public void run() {
                new TravelingTournamentApp().init(OptaPlannerExamplesApp.this, false);
            }
        }));
        panel.add(new JPanel());
        return panel;
    }

    private JButton createDisabledExampleButton(String title, String description, String iconResource) {
        JButton exampleButton = this.createExampleButton(title, description, iconResource, null);
        exampleButton.setEnabled(false);
        return exampleButton;
    }

    private JButton createExampleButton(String title, final String description, String iconResource, final Runnable runnable) {
        ImageIcon icon = iconResource == null ? null : new ImageIcon(this.getClass().getResource(iconResource));
        JButton button = new JButton(new AbstractAction(title, icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                runnable.run();
            }
        });
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                OptaPlannerExamplesApp.this.descriptionTextArea.setText(description);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OptaPlannerExamplesApp.this.descriptionTextArea.setText("");
            }
        });
        return button;
    }

    private JPanel createDescriptionPanel() {
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)new JLabel("Description"), "North");
        this.descriptionTextArea = new JTextArea(8, 80);
        this.descriptionTextArea.setEditable(false);
        descriptionPanel.add((Component)new JScrollPane(this.descriptionTextArea, 22, 31), "Center");
        return descriptionPanel;
    }
}

