/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;

public class PeriodStrengthWeightFactory
implements SelectionSorterWeightFactory<CourseSchedule, Period> {
    public Comparable createSorterWeight(CourseSchedule schedule, Period period) {
        int unavailablePeriodPenaltyCount = 0;
        for (UnavailablePeriodPenalty penalty : schedule.getUnavailablePeriodPenaltyList()) {
            if (!penalty.getPeriod().equals(period)) continue;
            ++unavailablePeriodPenaltyCount;
        }
        return new PeriodStrengthWeight(period, unavailablePeriodPenaltyCount);
    }

    public static class PeriodStrengthWeight
    implements Comparable<PeriodStrengthWeight> {
        private final Period period;
        private final int unavailablePeriodPenaltyCount;

        public PeriodStrengthWeight(Period period, int unavailablePeriodPenaltyCount) {
            this.period = period;
            this.unavailablePeriodPenaltyCount = unavailablePeriodPenaltyCount;
        }

        @Override
        public int compareTo(PeriodStrengthWeight other) {
            return new CompareToBuilder().append(other.unavailablePeriodPenaltyCount, this.unavailablePeriodPenaltyCount).append(this.period.getDay().getDayIndex(), other.period.getDay().getDayIndex()).append(this.period.getTimeslot().getTimeslotIndex(), other.period.getTimeslot().getTimeslotIndex()).append((Object)this.period.getId(), (Object)other.period.getId()).toComparison();
        }
    }
}

