/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.VrpLocation;
import org.optaplanner.examples.vehiclerouting.domain.VrpStandstill;
import org.optaplanner.examples.vehiclerouting.domain.VrpVehicle;
import org.optaplanner.examples.vehiclerouting.domain.solver.VehicleUpdatingVariableListener;
import org.optaplanner.examples.vehiclerouting.domain.solver.VrpCustomerDifficultyComparator;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.solver.ArrivalTimeUpdatingVariableListener;

@PlanningEntity(difficultyComparatorClass=VrpCustomerDifficultyComparator.class)
@XStreamAlias(value="VrpCustomer")
@XStreamInclude(value={VrpTimeWindowedCustomer.class})
public class VrpCustomer
extends AbstractPersistable
implements VrpStandstill {
    protected VrpLocation location;
    protected int demand;
    protected VrpStandstill previousStandstill;
    protected VrpCustomer nextCustomer;
    protected VrpVehicle vehicle;

    @Override
    public VrpLocation getLocation() {
        return this.location;
    }

    public void setLocation(VrpLocation location) {
        this.location = location;
    }

    public int getDemand() {
        return this.demand;
    }

    public void setDemand(int demand) {
        this.demand = demand;
    }

    @PlanningVariable(chained=true, valueRangeProviderRefs={"vehicleRange", "customerRange"}, variableListenerClasses={VehicleUpdatingVariableListener.class, ArrivalTimeUpdatingVariableListener.class})
    public VrpStandstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(VrpStandstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    @Override
    public VrpCustomer getNextCustomer() {
        return this.nextCustomer;
    }

    @Override
    public void setNextCustomer(VrpCustomer nextCustomer) {
        this.nextCustomer = nextCustomer;
    }

    @Override
    public VrpVehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(VrpVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public int getDistanceToPreviousStandstill() {
        if (this.previousStandstill == null) {
            return 0;
        }
        return this.getDistanceTo(this.previousStandstill);
    }

    public int getDistanceTo(VrpStandstill standstill) {
        return this.location.getDistance(standstill.getLocation());
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VrpCustomer) {
            VrpCustomer other = (VrpCustomer)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.location, (Object)other.location).append((Object)this.previousStandstill, (Object)other.previousStandstill).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.location).append((Object)this.previousStandstill).toHashCode();
    }

    @Override
    public String toString() {
        return this.location + "(after " + (this.previousStandstill == null ? "null" : this.previousStandstill.getLocation()) + ")";
    }
}

