/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.XmlSolverFactory;
import org.optaplanner.core.config.termination.TerminationConfig;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class SolverPerformanceTest
extends LoggingTest {
    protected SolutionDao solutionDao;

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
    }

    protected abstract String createSolverConfigResource();

    protected abstract SolutionDao createSolutionDao();

    protected void runSpeedTest(File unsolvedDataFile, String scoreAttainedString) {
        this.runSpeedTest(unsolvedDataFile, scoreAttainedString, EnvironmentMode.REPRODUCIBLE);
    }

    protected void runSpeedTest(File unsolvedDataFile, String scoreAttainedString, EnvironmentMode environmentMode) {
        SolverFactory solverFactory = this.buildSolverFactory(scoreAttainedString, environmentMode);
        Solver solver = this.solve(solverFactory, unsolvedDataFile);
        this.assertBestSolution(solver, scoreAttainedString);
    }

    protected SolverFactory buildSolverFactory(String scoreAttainedString, EnvironmentMode environmentMode) {
        XmlSolverFactory solverFactory = new XmlSolverFactory(this.createSolverConfigResource());
        solverFactory.getSolverConfig().setEnvironmentMode(environmentMode);
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setScoreAttained(scoreAttainedString);
        solverFactory.getSolverConfig().setTerminationConfig(terminationConfig);
        return solverFactory;
    }

    private Solver solve(SolverFactory solverFactory, File unsolvedDataFile) {
        Solution planningProblem = this.solutionDao.readSolution(unsolvedDataFile);
        Solver solver = solverFactory.buildSolver();
        solver.setPlanningProblem(planningProblem);
        solver.solve();
        return solver;
    }

    private void assertBestSolution(Solver solver, String scoreAttainedString) {
        Solution bestSolution = solver.getBestSolution();
        Assert.assertNotNull((Object)bestSolution);
        Score bestScore = bestSolution.getScore();
        Score scoreAttained = solver.getScoreDirectorFactory().getScoreDefinition().parseScore(scoreAttainedString);
        Assert.assertTrue((String)("The bestScore (" + bestScore + ") must be at least scoreAttained (" + scoreAttained + ")."), (bestScore.compareTo((Object)scoreAttained) >= 0 ? 1 : 0) != 0);
    }
}

