/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.swingui.ConstraintMatchesDialog;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverAndPersistenceFrame
extends JFrame {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final ImageIcon OPTA_PLANNER_ICON = new ImageIcon(SolverAndPersistenceFrame.class.getResource("optaPlannerIcon.png"));
    private final String titlePrefix;
    private final SolutionBusiness solutionBusiness;
    private SolutionPanel solutionPanel;
    private ConstraintMatchesDialog constraintMatchesDialog;
    private List<Action> quickOpenUnsolvedActionList;
    private List<Action> quickOpenSolvedActionList;
    private Action openAction;
    private Action saveAction;
    private Action importAction;
    private Action exportAction;
    private JCheckBox refreshScreenDuringSolvingCheckBox;
    private Action solveAction;
    private JButton solveButton;
    private Action terminateSolvingEarlyAction;
    private JButton terminateSolvingEarlyButton;
    private JPanel middlePanel;
    private JProgressBar progressBar;
    private JLabel resultLabel;
    private ShowConstraintMatchesDialogAction showConstraintMatchesDialogAction;

    public SolverAndPersistenceFrame(SolutionBusiness solutionBusiness, SolutionPanel solutionPanel, String titlePrefix) {
        super(titlePrefix);
        this.titlePrefix = titlePrefix;
        this.solutionBusiness = solutionBusiness;
        this.solutionPanel = solutionPanel;
        this.setIconImage(OPTA_PLANNER_ICON.getImage());
        solutionPanel.setSolutionBusiness(solutionBusiness);
        solutionPanel.setSolverAndPersistenceFrame(this);
        this.registerListeners();
        this.constraintMatchesDialog = new ConstraintMatchesDialog(this);
        this.constraintMatchesDialog.setSolutionBusiness(solutionBusiness);
    }

    private void registerListeners() {
        this.solutionBusiness.registerForBestSolutionChanges(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SolverAndPersistenceFrame.this.solutionBusiness.terminateSolvingEarly();
            }
        });
    }

    public void bestSolutionChanged() {
        Solution solution = this.solutionBusiness.getSolution();
        if (this.refreshScreenDuringSolvingCheckBox.isSelected()) {
            this.solutionPanel.updatePanel(solution);
            this.validate();
        }
        this.resultLabel.setText("Latest best score: " + solution.getScore());
    }

    public void init(Component centerForComponent) {
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setLocationRelativeTo(centerForComponent);
    }

    private JComponent createContentPane() {
        JComponent quickOpenPanel = this.createQuickOpenPanel();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createToolBar(), "North");
        mainPanel.add((Component)this.createMiddlePanel(), "Center");
        mainPanel.add((Component)this.createScorePanel(), "South");
        JSplitPane splitPane = new JSplitPane(1, quickOpenPanel, mainPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.2);
        return splitPane;
    }

    private JComponent createQuickOpenPanel() {
        JSplitPane quickOpenSplitPane = new JSplitPane(0, this.createQuickOpenUnsolvedPanel(), this.createQuickOpenSolvedPanel());
        quickOpenSplitPane.setResizeWeight(0.8);
        return quickOpenSplitPane;
    }

    private JComponent createQuickOpenUnsolvedPanel() {
        this.quickOpenUnsolvedActionList = new ArrayList<Action>();
        List<File> unsolvedFileList = this.solutionBusiness.getUnsolvedFileList();
        return this.createQuickOpenPanel(this.quickOpenUnsolvedActionList, unsolvedFileList, "Quick open (unsolved)");
    }

    private JComponent createQuickOpenSolvedPanel() {
        this.quickOpenSolvedActionList = new ArrayList<Action>();
        List<File> solvedFileList = this.solutionBusiness.getSolvedFileList();
        return this.createQuickOpenPanel(this.quickOpenSolvedActionList, solvedFileList, "Quick open (solved)");
    }

    private JComponent createQuickOpenPanel(List<Action> quickOpenActionList, List<File> fileList, String title) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (fileList.isEmpty()) {
            JLabel noneLabel = new JLabel("None");
            noneLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            panel.add(noneLabel);
        } else {
            for (File file : fileList) {
                QuickOpenAction quickOpenAction = new QuickOpenAction(file);
                quickOpenActionList.add(quickOpenAction);
                JButton quickOpenButton = new JButton(quickOpenAction);
                quickOpenButton.setHorizontalAlignment(2);
                quickOpenButton.setMargin(new Insets(0, 0, 0, 0));
                panel.add(quickOpenButton);
            }
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        scrollPane.setMinimumSize(new Dimension(100, 80));
        scrollPane.setPreferredSize(new Dimension(180, 200));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)scrollPane, "Center");
        titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createTitledBorder(title)));
        return titlePanel;
    }

    private JComponent createToolBar() {
        JToolBar toolBar = new JToolBar("File operations");
        toolBar.setFloatable(false);
        this.importAction = new ImportAction();
        this.importAction.setEnabled(this.solutionBusiness.hasImporter());
        toolBar.add(new JButton(this.importAction));
        this.openAction = new OpenAction();
        this.openAction.setEnabled(true);
        toolBar.add(new JButton(this.openAction));
        this.saveAction = new SaveAction();
        this.saveAction.setEnabled(false);
        toolBar.add(new JButton(this.saveAction));
        this.exportAction = new ExportAction();
        this.exportAction.setEnabled(false);
        toolBar.add(new JButton(this.exportAction));
        toolBar.addSeparator();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        toolBar.add(this.progressBar);
        toolBar.addSeparator();
        this.solveAction = new SolveAction();
        this.solveAction.setEnabled(false);
        this.solveButton = new JButton(this.solveAction);
        this.terminateSolvingEarlyAction = new TerminateSolvingEarlyAction();
        this.terminateSolvingEarlyAction.setEnabled(false);
        this.terminateSolvingEarlyButton = new JButton(this.terminateSolvingEarlyAction);
        this.terminateSolvingEarlyButton.setVisible(false);
        toolBar.add((Component)this.solveButton, "solveAction");
        toolBar.add((Component)this.terminateSolvingEarlyButton, "terminateSolvingEarlyAction");
        this.solveButton.setMinimumSize(this.terminateSolvingEarlyButton.getMinimumSize());
        this.solveButton.setPreferredSize(this.terminateSolvingEarlyButton.getPreferredSize());
        return toolBar;
    }

    private JPanel createMiddlePanel() {
        this.middlePanel = new JPanel(new CardLayout());
        ImageIcon usageExplanationIcon = new ImageIcon(this.getClass().getResource(this.solutionPanel.getUsageExplanationPath()));
        JLabel usageExplanationLabel = new JLabel(usageExplanationIcon);
        usageExplanationLabel.setMinimumSize(new Dimension(100, 100));
        this.middlePanel.add((Component)usageExplanationLabel, "usageExplanationPanel");
        JComponent wrappedSolutionPanel = this.solutionPanel.isWrapInScrollPane() ? new JScrollPane(this.solutionPanel) : this.solutionPanel;
        this.middlePanel.add((Component)wrappedSolutionPanel, "solutionPanel");
        return this.middlePanel;
    }

    private JPanel createScorePanel() {
        JPanel scorePanel = new JPanel(new BorderLayout());
        scorePanel.setBorder(BorderFactory.createEtchedBorder());
        this.showConstraintMatchesDialogAction = new ShowConstraintMatchesDialogAction();
        this.showConstraintMatchesDialogAction.setEnabled(false);
        scorePanel.add((Component)new JButton(this.showConstraintMatchesDialogAction), "West");
        this.resultLabel = new JLabel("Score:");
        this.resultLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        scorePanel.add((Component)this.resultLabel, "Center");
        this.refreshScreenDuringSolvingCheckBox = new JCheckBox("Refresh screen during solving", this.solutionPanel.isRefreshScreenDuringSolving());
        scorePanel.add((Component)this.refreshScreenDuringSolvingCheckBox, "East");
        return scorePanel;
    }

    private void setSolutionLoaded() {
        this.setTitle(this.titlePrefix + " - " + this.solutionBusiness.getSolutionFileName());
        ((CardLayout)this.middlePanel.getLayout()).show(this.middlePanel, "solutionPanel");
        this.solveAction.setEnabled(true);
        this.saveAction.setEnabled(true);
        this.exportAction.setEnabled(this.solutionBusiness.hasExporter());
        this.showConstraintMatchesDialogAction.setEnabled(true);
        this.resetScreen();
    }

    private void setSolvingState(boolean solving) {
        for (Action action : this.quickOpenUnsolvedActionList) {
            action.setEnabled(!solving);
        }
        for (Action action : this.quickOpenSolvedActionList) {
            action.setEnabled(!solving);
        }
        this.importAction.setEnabled(!solving && this.solutionBusiness.hasImporter());
        this.openAction.setEnabled(!solving);
        this.saveAction.setEnabled(!solving);
        this.exportAction.setEnabled(!solving && this.solutionBusiness.hasExporter());
        this.solveAction.setEnabled(!solving);
        this.solveButton.setVisible(!solving);
        this.terminateSolvingEarlyAction.setEnabled(solving);
        this.terminateSolvingEarlyButton.setVisible(solving);
        this.solutionPanel.setEnabled(!solving);
        this.progressBar.setIndeterminate(solving);
        this.progressBar.setStringPainted(solving);
        this.progressBar.setString(solving ? "Solving..." : null);
        this.showConstraintMatchesDialogAction.setEnabled(!solving);
        this.solutionPanel.setSolvingState(solving);
    }

    public void resetScreen() {
        this.solutionPanel.resetPanel(this.solutionBusiness.getSolution());
        this.validate();
        this.resultLabel.setText("Score: " + this.solutionBusiness.getScore());
    }

    private class ShowConstraintMatchesDialogAction
    extends AbstractAction {
        public ShowConstraintMatchesDialogAction() {
            super("Constraint matches", new ImageIcon(SolverAndPersistenceFrame.class.getResource("showConstraintMatchesDialogAction.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.constraintMatchesDialog.resetContentPanel();
            SolverAndPersistenceFrame.this.constraintMatchesDialog.setVisible(true);
        }
    }

    private class ExportAction
    extends AbstractAction {
        private static final String NAME = "Export as...";

        public ExportAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("exportAction.png")));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getExportDataDir());
            fileChooser.setDialogTitle(NAME);
            int approved = fileChooser.showSaveDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.exportSolution(fileChooser.getSelectedFile());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class ImportAction
    extends AbstractAction {
        private static final String NAME = "Import...";

        public ImportAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("importAction.png")));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getImportDataDir());
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || SolverAndPersistenceFrame.this.solutionBusiness.acceptImportFile(file);
                }

                @Override
                public String getDescription() {
                    return "Import files (*" + SolverAndPersistenceFrame.this.solutionBusiness.getImportFileSuffix() + ")";
                }
            });
            fileChooser.setDialogTitle(NAME);
            int approved = fileChooser.showOpenDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.importSolution(fileChooser.getSelectedFile());
                    SolverAndPersistenceFrame.this.setSolutionLoaded();
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final String NAME = "Save as...";

        public SaveAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("saveAction.png")));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir());
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "Solver xml files";
                }
            });
            fileChooser.setDialogTitle(NAME);
            fileChooser.setSelectedFile(new File(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir(), FilenameUtils.getBaseName((String)SolverAndPersistenceFrame.this.solutionBusiness.getSolutionFileName()) + ".xml"));
            int approved = fileChooser.showSaveDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.saveSolution(fileChooser.getSelectedFile());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        private static final String NAME = "Open...";

        public OpenAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("openAction.png")));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir());
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "Solver xml files";
                }
            });
            fileChooser.setDialogTitle(NAME);
            int approved = fileChooser.showOpenDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.openSolution(fileChooser.getSelectedFile());
                    SolverAndPersistenceFrame.this.setSolutionLoaded();
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class TerminateSolvingEarlyAction
    extends AbstractAction {
        public TerminateSolvingEarlyAction() {
            super("Terminate solving early", new ImageIcon(SolverAndPersistenceFrame.class.getResource("terminateSolvingEarlyAction.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.terminateSolvingEarlyAction.setEnabled(false);
            SolverAndPersistenceFrame.this.progressBar.setString("Terminating...");
            SolverAndPersistenceFrame.this.solutionBusiness.terminateSolvingEarly();
        }
    }

    private class SolveAction
    extends AbstractAction {
        private ExecutorService solvingExecutor;

        public SolveAction() {
            super("Solve", new ImageIcon(SolverAndPersistenceFrame.class.getResource("solveAction.png")));
            this.solvingExecutor = Executors.newFixedThreadPool(1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.setSolvingState(true);
            final Solution planningProblem = SolverAndPersistenceFrame.this.solutionBusiness.getSolution();
            this.solvingExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    Solution bestSolution;
                    try {
                        bestSolution = SolverAndPersistenceFrame.this.solutionBusiness.solve(planningProblem);
                    }
                    catch (Throwable e) {
                        SolverAndPersistenceFrame.this.logger.error("Solving failed.", e);
                        bestSolution = null;
                    }
                    final Solution newSolution = bestSolution;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (newSolution != null) {
                                SolverAndPersistenceFrame.this.solutionBusiness.setSolution(newSolution);
                            }
                            SolverAndPersistenceFrame.this.setSolvingState(false);
                            SolverAndPersistenceFrame.this.resetScreen();
                        }
                    });
                }
            });
        }
    }

    private class QuickOpenAction
    extends AbstractAction {
        private File file;

        public QuickOpenAction(File file) {
            super(file.getName());
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SolverAndPersistenceFrame.this.solutionBusiness.openSolution(this.file);
                SolverAndPersistenceFrame.this.setSolutionLoaded();
            }
            finally {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

