/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.domain.solution;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Row;

public class RowStrengthWeightFactory
implements SelectionSorterWeightFactory<NQueens, Row> {
    public Comparable createSorterWeight(NQueens nQueens, Row row) {
        int distanceFromMiddle = RowStrengthWeightFactory.calculateDistanceFromMiddle(nQueens.getN(), row.getIndex());
        return new RowStrengthWeight(row, distanceFromMiddle);
    }

    private static int calculateDistanceFromMiddle(int n, int columnIndex) {
        int middle = n / 2;
        int distanceFromMiddle = Math.abs(columnIndex - middle);
        if (n % 2 == 0 && columnIndex < middle) {
            --distanceFromMiddle;
        }
        return distanceFromMiddle;
    }

    public static class RowStrengthWeight
    implements Comparable<RowStrengthWeight> {
        private final Row row;
        private final int distanceFromMiddle;

        public RowStrengthWeight(Row row, int distanceFromMiddle) {
            this.row = row;
            this.distanceFromMiddle = distanceFromMiddle;
        }

        @Override
        public int compareTo(RowStrengthWeight other) {
            return new CompareToBuilder().append(other.distanceFromMiddle, this.distanceFromMiddle).append(this.row.getIndex(), other.row.getIndex()).toComparison();
        }
    }
}

