/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractXmlSolutionImporter;
import org.optaplanner.examples.nurserostering.domain.DayOfWeek;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.FreeBefore2DaysWithAWorkDayPattern;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.NurseRosterInfo;
import org.optaplanner.examples.nurserostering.domain.Pattern;
import org.optaplanner.examples.nurserostering.domain.Shift;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.ShiftType;
import org.optaplanner.examples.nurserostering.domain.ShiftType2DaysPattern;
import org.optaplanner.examples.nurserostering.domain.ShiftType3DaysPattern;
import org.optaplanner.examples.nurserostering.domain.ShiftTypeSkillRequirement;
import org.optaplanner.examples.nurserostering.domain.Skill;
import org.optaplanner.examples.nurserostering.domain.SkillProficiency;
import org.optaplanner.examples.nurserostering.domain.WeekendDefinition;
import org.optaplanner.examples.nurserostering.domain.WorkBeforeFreeSequencePattern;
import org.optaplanner.examples.nurserostering.domain.contract.BooleanContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;
import org.optaplanner.examples.nurserostering.domain.contract.ContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.ContractLineType;
import org.optaplanner.examples.nurserostering.domain.contract.MinMaxContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.PatternContractLine;
import org.optaplanner.examples.nurserostering.domain.request.DayOffRequest;
import org.optaplanner.examples.nurserostering.domain.request.DayOnRequest;
import org.optaplanner.examples.nurserostering.domain.request.ShiftOffRequest;
import org.optaplanner.examples.nurserostering.domain.request.ShiftOnRequest;
import org.optaplanner.examples.nurserostering.persistence.NurseRosteringDao;

public class NurseRosteringImporter
extends AbstractXmlSolutionImporter {
    public static void main(String[] args) {
        new NurseRosteringImporter().convertAll();
    }

    public NurseRosteringImporter() {
        super(new NurseRosteringDao());
    }

    @Override
    public AbstractXmlSolutionImporter.XmlInputBuilder createXmlInputBuilder() {
        return new NurseRosteringInputBuilder();
    }

    public class NurseRosteringInputBuilder
    extends AbstractXmlSolutionImporter.XmlInputBuilder {
        protected Map<String, ShiftDate> shiftDateMap;
        protected Map<String, Skill> skillMap;
        protected Map<String, ShiftType> shiftTypeMap;
        protected Map<List<String>, Shift> dateAndShiftTypeToShiftMap;
        protected Map<List<Object>, List<Shift>> dayOfWeekAndShiftTypeToShiftListMap;
        protected Map<String, Pattern> patternMap;
        protected Map<String, Contract> contractMap;
        protected Map<String, Employee> employeeMap;

        @Override
        public Solution readSolution() throws IOException, JDOMException {
            Element schedulingPeriodElement = this.document.getRootElement();
            this.assertElementName(schedulingPeriodElement, "SchedulingPeriod");
            NurseRoster nurseRoster = new NurseRoster();
            nurseRoster.setId(0L);
            nurseRoster.setCode(schedulingPeriodElement.getAttribute("ID").getValue());
            this.generateShiftDateList(nurseRoster, schedulingPeriodElement.getChild("StartDate"), schedulingPeriodElement.getChild("EndDate"));
            this.generateNurseRosterInfo(nurseRoster);
            this.readSkillList(nurseRoster, schedulingPeriodElement.getChild("Skills"));
            this.readShiftTypeList(nurseRoster, schedulingPeriodElement.getChild("ShiftTypes"));
            this.generateShiftList(nurseRoster);
            this.readPatternList(nurseRoster, schedulingPeriodElement.getChild("Patterns"));
            this.readContractList(nurseRoster, schedulingPeriodElement.getChild("Contracts"));
            this.readEmployeeList(nurseRoster, schedulingPeriodElement.getChild("Employees"));
            this.readRequiredEmployeeSizes(nurseRoster, schedulingPeriodElement.getChild("CoverRequirements"));
            this.readDayOffRequestList(nurseRoster, schedulingPeriodElement.getChild("DayOffRequests"));
            this.readDayOnRequestList(nurseRoster, schedulingPeriodElement.getChild("DayOnRequests"));
            this.readShiftOffRequestList(nurseRoster, schedulingPeriodElement.getChild("ShiftOffRequests"));
            this.readShiftOnRequestList(nurseRoster, schedulingPeriodElement.getChild("ShiftOnRequests"));
            this.createShiftAssignmentList(nurseRoster);
            BigInteger possibleSolutionSize = BigInteger.valueOf(nurseRoster.getEmployeeList().size()).pow(nurseRoster.getShiftAssignmentList().size());
            NurseRosteringImporter.this.logger.info("NurseRoster {} has {} skills, {} shiftTypes, {} patterns, {} contracts, {} employees, {} shiftDates, {} shiftAssignments and {} requests with a search space of {}.", new Object[]{this.getInputId(), nurseRoster.getSkillList().size(), nurseRoster.getShiftTypeList().size(), nurseRoster.getPatternList().size(), nurseRoster.getContractList().size(), nurseRoster.getEmployeeList().size(), nurseRoster.getShiftDateList().size(), nurseRoster.getShiftAssignmentList().size(), nurseRoster.getDayOffRequestList().size() + nurseRoster.getDayOnRequestList().size() + nurseRoster.getShiftOffRequestList().size() + nurseRoster.getShiftOnRequestList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return nurseRoster;
        }

        private void generateShiftDateList(NurseRoster nurseRoster, Element startDateElement, Element endDateElement) throws JDOMException {
            Date endDate;
            Date startDate;
            TimeZone LOCAL_TIMEZONE = TimeZone.getTimeZone("GMT");
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(LOCAL_TIMEZONE);
            calendar.clear();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dateFormat.setCalendar(calendar);
            try {
                startDate = dateFormat.parse(startDateElement.getText());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid startDate (" + startDateElement.getText() + ").", e);
            }
            calendar.setTime(startDate);
            int startDayOfYear = calendar.get(6);
            int startYear = calendar.get(1);
            try {
                endDate = dateFormat.parse(endDateElement.getText());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid endDate (" + endDateElement.getText() + ").", e);
            }
            calendar.setTime(endDate);
            int endDayOfYear = calendar.get(6);
            int endYear = calendar.get(1);
            int maxDayIndex = endDayOfYear - startDayOfYear;
            if (startYear > endYear) {
                throw new IllegalStateException("The startYear (" + startYear + " must be before endYear (" + endYear + ").");
            }
            if (startYear < endYear) {
                calendar.setTime(startDate);
                for (int tmpYear = startYear; tmpYear < endYear; ++tmpYear) {
                    maxDayIndex += calendar.getActualMaximum(6);
                    calendar.add(1, 1);
                }
            }
            int shiftDateSize = maxDayIndex + 1;
            ArrayList<ShiftDate> shiftDateList = new ArrayList<ShiftDate>(shiftDateSize);
            this.shiftDateMap = new HashMap<String, ShiftDate>(shiftDateSize);
            long id = 0L;
            int dayIndex = 0;
            calendar.setTime(startDate);
            for (int i = 0; i < shiftDateSize; ++i) {
                ShiftDate shiftDate = new ShiftDate();
                shiftDate.setId(id);
                shiftDate.setDayIndex(dayIndex);
                String dateString = dateFormat.format(calendar.getTime());
                shiftDate.setDateString(dateString);
                shiftDate.setDayOfWeek(DayOfWeek.valueOfCalendar(calendar.get(7)));
                shiftDate.setShiftList(new ArrayList<Shift>());
                shiftDateList.add(shiftDate);
                this.shiftDateMap.put(dateString, shiftDate);
                ++id;
                ++dayIndex;
                calendar.add(6, 1);
            }
            nurseRoster.setShiftDateList(shiftDateList);
        }

        private void generateNurseRosterInfo(NurseRoster nurseRoster) {
            List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
            NurseRosterInfo nurseRosterInfo = new NurseRosterInfo();
            nurseRosterInfo.setFirstShiftDate(shiftDateList.get(0));
            nurseRosterInfo.setLastShiftDate(shiftDateList.get(shiftDateList.size() - 1));
            nurseRosterInfo.setPlanningWindowStart(shiftDateList.get(0));
            nurseRoster.setNurseRosterInfo(nurseRosterInfo);
        }

        private void readSkillList(NurseRoster nurseRoster, Element skillsElement) throws JDOMException {
            List<Skill> skillList;
            if (skillsElement == null) {
                skillList = Collections.emptyList();
            } else {
                List skillElementList = skillsElement.getChildren();
                skillList = new ArrayList<Skill>(skillElementList.size());
                this.skillMap = new HashMap<String, Skill>(skillElementList.size());
                long id = 0L;
                for (Element element : skillElementList) {
                    this.assertElementName(element, "Skill");
                    Skill skill = new Skill();
                    skill.setId(id);
                    skill.setCode(element.getText());
                    skillList.add(skill);
                    if (this.skillMap.containsKey(skill.getCode())) {
                        throw new IllegalArgumentException("There are 2 skills with the same code (" + skill.getCode() + ").");
                    }
                    this.skillMap.put(skill.getCode(), skill);
                    ++id;
                }
            }
            nurseRoster.setSkillList(skillList);
        }

        private void readShiftTypeList(NurseRoster nurseRoster, Element shiftTypesElement) throws JDOMException {
            List shiftTypeElementList = shiftTypesElement.getChildren();
            ArrayList<ShiftType> shiftTypeList = new ArrayList<ShiftType>(shiftTypeElementList.size());
            this.shiftTypeMap = new HashMap<String, ShiftType>(shiftTypeElementList.size());
            long id = 0L;
            int index = 0;
            ArrayList<ShiftTypeSkillRequirement> shiftTypeSkillRequirementList = new ArrayList<ShiftTypeSkillRequirement>(shiftTypeElementList.size() * 2);
            long shiftTypeSkillRequirementId = 0L;
            for (Element element : shiftTypeElementList) {
                this.assertElementName(element, "Shift");
                ShiftType shiftType = new ShiftType();
                shiftType.setId(id);
                shiftType.setCode(element.getAttribute("ID").getValue());
                shiftType.setIndex(index);
                String startTimeString = element.getChild("StartTime").getText();
                shiftType.setStartTimeString(startTimeString);
                String endTimeString = element.getChild("EndTime").getText();
                shiftType.setEndTimeString(endTimeString);
                shiftType.setNight(startTimeString.compareTo(endTimeString) > 0);
                shiftType.setDescription(element.getChild("Description").getText());
                Element skillsElement = element.getChild("Skills");
                if (skillsElement != null) {
                    List skillElementList = skillsElement.getChildren();
                    for (Element skillElement : skillElementList) {
                        this.assertElementName(skillElement, "Skill");
                        ShiftTypeSkillRequirement shiftTypeSkillRequirement = new ShiftTypeSkillRequirement();
                        shiftTypeSkillRequirement.setId(shiftTypeSkillRequirementId);
                        shiftTypeSkillRequirement.setShiftType(shiftType);
                        Skill skill = this.skillMap.get(skillElement.getText());
                        if (skill == null) {
                            throw new IllegalArgumentException("The skill (" + skillElement.getText() + ") of shiftType (" + shiftType.getCode() + ") does not exist.");
                        }
                        shiftTypeSkillRequirement.setSkill(skill);
                        shiftTypeSkillRequirementList.add(shiftTypeSkillRequirement);
                        ++shiftTypeSkillRequirementId;
                    }
                }
                shiftTypeList.add(shiftType);
                if (this.shiftTypeMap.containsKey(shiftType.getCode())) {
                    throw new IllegalArgumentException("There are 2 shiftTypes with the same code (" + shiftType.getCode() + ").");
                }
                this.shiftTypeMap.put(shiftType.getCode(), shiftType);
                ++id;
                ++index;
            }
            nurseRoster.setShiftTypeList(shiftTypeList);
            nurseRoster.setShiftTypeSkillRequirementList(shiftTypeSkillRequirementList);
        }

        private void generateShiftList(NurseRoster nurseRoster) throws JDOMException {
            List<ShiftType> shiftTypeList = nurseRoster.getShiftTypeList();
            int shiftListSize = this.shiftDateMap.size() * shiftTypeList.size();
            ArrayList<Shift> shiftList = new ArrayList<Shift>(shiftListSize);
            this.dateAndShiftTypeToShiftMap = new HashMap<List<String>, Shift>(shiftListSize);
            this.dayOfWeekAndShiftTypeToShiftListMap = new HashMap<List<Object>, List<Shift>>(7 * shiftTypeList.size());
            long id = 0L;
            int index = 0;
            for (ShiftDate shiftDate : nurseRoster.getShiftDateList()) {
                for (ShiftType shiftType : shiftTypeList) {
                    Shift shift = new Shift();
                    shift.setId(id);
                    shift.setShiftDate(shiftDate);
                    shiftDate.getShiftList().add(shift);
                    shift.setShiftType(shiftType);
                    shift.setIndex(index);
                    shift.setRequiredEmployeeSize(0);
                    shiftList.add(shift);
                    this.dateAndShiftTypeToShiftMap.put(Arrays.asList(shiftDate.getDateString(), shiftType.getCode()), shift);
                    this.addShiftToDayOfWeekAndShiftTypeToShiftListMap(shiftDate, shiftType, shift);
                    ++id;
                    ++index;
                }
            }
            nurseRoster.setShiftList(shiftList);
        }

        private void addShiftToDayOfWeekAndShiftTypeToShiftListMap(ShiftDate shiftDate, ShiftType shiftType, Shift shift) {
            List<Object> key = Arrays.asList(new Object[]{shiftDate.getDayOfWeek(), shiftType});
            List<Shift> dayOfWeekAndShiftTypeToShiftList = this.dayOfWeekAndShiftTypeToShiftListMap.get(key);
            if (dayOfWeekAndShiftTypeToShiftList == null) {
                dayOfWeekAndShiftTypeToShiftList = new ArrayList<Shift>((this.shiftDateMap.size() + 6) / 7);
                this.dayOfWeekAndShiftTypeToShiftListMap.put(key, dayOfWeekAndShiftTypeToShiftList);
            }
            dayOfWeekAndShiftTypeToShiftList.add(shift);
        }

        private void readPatternList(NurseRoster nurseRoster, Element patternsElement) throws JDOMException {
            List<Pattern> patternList;
            if (patternsElement == null) {
                patternList = Collections.emptyList();
            } else {
                List patternElementList = patternsElement.getChildren();
                patternList = new ArrayList<Pattern>(patternElementList.size());
                this.patternMap = new HashMap<String, Pattern>(patternElementList.size());
                long id = 0L;
                long patternEntryId = 0L;
                for (Element element : patternElementList) {
                    Pattern pattern;
                    this.assertElementName(element, "Pattern");
                    String code = element.getAttribute("ID").getValue();
                    int weight = element.getAttribute("weight").getIntValue();
                    List patternEntryElementList = element.getChild("PatternEntries").getChildren();
                    if (patternEntryElementList.size() < 2) {
                        throw new IllegalArgumentException("The size of PatternEntries (" + patternEntryElementList.size() + ") of pattern (" + code + ") should be at least 2.");
                    }
                    if (((Element)patternEntryElementList.get(0)).getChild("ShiftType").getText().equals("None")) {
                        pattern = new FreeBefore2DaysWithAWorkDayPattern();
                        if (patternEntryElementList.size() != 3) {
                            throw new IllegalStateException("boe");
                        }
                    } else {
                        if (((Element)patternEntryElementList.get(1)).getChild("ShiftType").getText().equals("None")) {
                            pattern = new WorkBeforeFreeSequencePattern();
                            throw new UnsupportedOperationException("The pattern (" + code + ") is not supported." + " None of the test data exhibits such a pattern.");
                        }
                        switch (patternEntryElementList.size()) {
                            case 2: {
                                pattern = new ShiftType2DaysPattern();
                                break;
                            }
                            case 3: {
                                pattern = new ShiftType3DaysPattern();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("A size of PatternEntries (" + patternEntryElementList.size() + ") of pattern (" + code + ") above 3 is not supported.");
                            }
                        }
                    }
                    pattern.setId(id);
                    pattern.setCode(code);
                    pattern.setWeight(weight);
                    int patternEntryIndex = 0;
                    DayOfWeek firstDayOfweek = null;
                    for (Element patternEntryElement : patternEntryElementList) {
                        Pattern castedPattern;
                        DayOfWeek dayOfWeek;
                        ShiftType shiftType;
                        boolean shiftTypeIsNone;
                        this.assertElementName(patternEntryElement, "PatternEntry");
                        Element shiftTypeElement = patternEntryElement.getChild("ShiftType");
                        if (shiftTypeElement.getText().equals("Any")) {
                            shiftTypeIsNone = false;
                            shiftType = null;
                        } else if (shiftTypeElement.getText().equals("None")) {
                            shiftTypeIsNone = true;
                            shiftType = null;
                        } else {
                            shiftTypeIsNone = false;
                            shiftType = this.shiftTypeMap.get(shiftTypeElement.getText());
                            if (shiftType == null) {
                                throw new IllegalArgumentException("The shiftType (" + shiftTypeElement.getText() + ") of pattern (" + pattern.getCode() + ") does not exist.");
                            }
                        }
                        Element dayElement = patternEntryElement.getChild("Day");
                        if (dayElement.getText().equals("Any")) {
                            dayOfWeek = null;
                        } else {
                            dayOfWeek = DayOfWeek.valueOfCode(dayElement.getText());
                            if (dayOfWeek == null) {
                                throw new IllegalArgumentException("The dayOfWeek (" + dayElement.getText() + ") of pattern (" + pattern.getCode() + ") does not exist.");
                            }
                        }
                        if (patternEntryIndex == 0) {
                            firstDayOfweek = dayOfWeek;
                        } else if (firstDayOfweek != null) {
                            if (firstDayOfweek.getDistanceToNext(dayOfWeek) != patternEntryIndex) {
                                throw new IllegalArgumentException("On patternEntryIndex (" + patternEntryIndex + ") of pattern (" + pattern.getCode() + ") the dayOfWeek (" + (Object)((Object)dayOfWeek) + ") is not valid with previous entries.");
                            }
                        } else if (dayOfWeek != null) {
                            throw new IllegalArgumentException("On patternEntryIndex (" + patternEntryIndex + ") of pattern (" + pattern.getCode() + ") the dayOfWeek should be (Any), in line with previous entries.");
                        }
                        if (pattern instanceof FreeBefore2DaysWithAWorkDayPattern) {
                            castedPattern = (FreeBefore2DaysWithAWorkDayPattern)pattern;
                            if (patternEntryIndex == 0) {
                                if (dayOfWeek == null) {
                                    throw new UnsupportedOperationException("On patternEntryIndex (" + patternEntryIndex + ") of FreeBeforeWorkSequence pattern (" + pattern.getCode() + ") the dayOfWeek should not be (Any)." + "\n None of the test data exhibits such a pattern.");
                                }
                                ((FreeBefore2DaysWithAWorkDayPattern)castedPattern).setFreeDayOfWeek(dayOfWeek);
                            }
                            if (patternEntryIndex == 1 && shiftType != null) {
                                throw new UnsupportedOperationException("On patternEntryIndex (" + patternEntryIndex + ") of FreeBeforeWorkSequence pattern (" + pattern.getCode() + ") the shiftType should be (Any)." + "\n None of the test data exhibits such a pattern.");
                            }
                            if (patternEntryIndex != 0 && shiftTypeIsNone) {
                                throw new IllegalArgumentException("On patternEntryIndex (" + patternEntryIndex + ") of FreeBeforeWorkSequence pattern (" + pattern.getCode() + ") the shiftType can not be (None).");
                            }
                        } else if (pattern instanceof WorkBeforeFreeSequencePattern) {
                            castedPattern = (WorkBeforeFreeSequencePattern)pattern;
                            if (patternEntryIndex == 0) {
                                ((WorkBeforeFreeSequencePattern)castedPattern).setWorkDayOfWeek(dayOfWeek);
                                ((WorkBeforeFreeSequencePattern)castedPattern).setWorkShiftType(shiftType);
                                ((WorkBeforeFreeSequencePattern)castedPattern).setFreeDayLength(patternEntryElementList.size() - 1);
                            }
                            if (patternEntryIndex != 0 && !shiftTypeIsNone) {
                                throw new IllegalArgumentException("On patternEntryIndex (" + patternEntryIndex + ") of WorkBeforeFreeSequence pattern (" + pattern.getCode() + ") the shiftType should be (None).");
                            }
                        } else if (pattern instanceof ShiftType2DaysPattern) {
                            castedPattern = (ShiftType2DaysPattern)pattern;
                            if (patternEntryIndex == 0 && dayOfWeek != null) {
                                throw new UnsupportedOperationException("On patternEntryIndex (" + patternEntryIndex + ") of FreeBeforeWorkSequence pattern (" + pattern.getCode() + ") the dayOfWeek should be (Any)." + "\n None of the test data exhibits such a pattern.");
                            }
                            if (shiftType == null) {
                                throw new UnsupportedOperationException("On patternEntryIndex (" + patternEntryIndex + ") of FreeBeforeWorkSequence pattern (" + pattern.getCode() + ") the shiftType should not be (Any)." + "\n None of the test data exhibits such a pattern.");
                            }
                            switch (patternEntryIndex) {
                                case 0: {
                                    ((ShiftType2DaysPattern)castedPattern).setDayIndex0ShiftType(shiftType);
                                    break;
                                }
                                case 1: {
                                    ((ShiftType2DaysPattern)castedPattern).setDayIndex1ShiftType(shiftType);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("The patternEntryIndex (" + patternEntryIndex + ") is not supported.");
                                }
                            }
                        } else if (pattern instanceof ShiftType3DaysPattern) {
                            castedPattern = (ShiftType3DaysPattern)pattern;
                            if (patternEntryIndex == 0 && dayOfWeek != null) {
                                throw new UnsupportedOperationException("On patternEntryIndex (" + patternEntryIndex + ") of FreeBeforeWorkSequence pattern (" + pattern.getCode() + ") the dayOfWeek should be (Any)." + "\n None of the test data exhibits such a pattern.");
                            }
                            if (shiftType == null) {
                                throw new UnsupportedOperationException("On patternEntryIndex (" + patternEntryIndex + ") of FreeBeforeWorkSequence pattern (" + pattern.getCode() + ") the shiftType should not be (Any)." + "\n None of the test data exhibits such a pattern.");
                            }
                            switch (patternEntryIndex) {
                                case 0: {
                                    ((ShiftType3DaysPattern)castedPattern).setDayIndex0ShiftType(shiftType);
                                    break;
                                }
                                case 1: {
                                    ((ShiftType3DaysPattern)castedPattern).setDayIndex1ShiftType(shiftType);
                                    break;
                                }
                                case 2: {
                                    ((ShiftType3DaysPattern)castedPattern).setDayIndex2ShiftType(shiftType);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("The patternEntryIndex (" + patternEntryIndex + ") is not supported.");
                                }
                            }
                        } else {
                            throw new IllegalStateException("Unsupported patternClass (" + pattern.getClass() + ").");
                        }
                        ++patternEntryIndex;
                    }
                    patternList.add(pattern);
                    if (this.patternMap.containsKey(pattern.getCode())) {
                        throw new IllegalArgumentException("There are 2 patterns with the same code (" + pattern.getCode() + ").");
                    }
                    this.patternMap.put(pattern.getCode(), pattern);
                    ++id;
                }
            }
            nurseRoster.setPatternList(patternList);
        }

        private void readContractList(NurseRoster nurseRoster, Element contractsElement) throws JDOMException {
            int contractLineTypeListSize = ContractLineType.values().length;
            List contractElementList = contractsElement.getChildren();
            ArrayList<Contract> contractList = new ArrayList<Contract>(contractElementList.size());
            this.contractMap = new HashMap<String, Contract>(contractElementList.size());
            long id = 0L;
            ArrayList<ContractLine> contractLineList = new ArrayList<ContractLine>(contractElementList.size() * contractLineTypeListSize);
            long contractLineId = 0L;
            ArrayList<PatternContractLine> patternContractLineList = new ArrayList<PatternContractLine>(contractElementList.size() * 3);
            long patternContractLineId = 0L;
            for (Element element : contractElementList) {
                this.assertElementName(element, "Contract");
                Contract contract = new Contract();
                contract.setId(id);
                contract.setCode(element.getAttribute("ID").getValue());
                contract.setDescription(element.getChild("Description").getText());
                ArrayList<ContractLine> contractLineListOfContract = new ArrayList<ContractLine>(contractLineTypeListSize);
                contractLineId = this.readBooleanContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("SingleAssignmentPerDay"), ContractLineType.SINGLE_ASSIGNMENT_PER_DAY);
                contractLineId = this.readMinMaxContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("MinNumAssignments"), element.getChild("MaxNumAssignments"), ContractLineType.TOTAL_ASSIGNMENTS);
                contractLineId = this.readMinMaxContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("MinConsecutiveWorkingDays"), element.getChild("MaxConsecutiveWorkingDays"), ContractLineType.CONSECUTIVE_WORKING_DAYS);
                contractLineId = this.readMinMaxContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("MinConsecutiveFreeDays"), element.getChild("MaxConsecutiveFreeDays"), ContractLineType.CONSECUTIVE_FREE_DAYS);
                contractLineId = this.readMinMaxContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("MinConsecutiveWorkingWeekends"), element.getChild("MaxConsecutiveWorkingWeekends"), ContractLineType.CONSECUTIVE_WORKING_WEEKENDS);
                contractLineId = this.readMinMaxContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, null, element.getChild("MaxWorkingWeekendsInFourWeeks"), ContractLineType.TOTAL_WORKING_WEEKENDS_IN_FOUR_WEEKS);
                WeekendDefinition weekendDefinition = WeekendDefinition.valueOfCode(element.getChild("WeekendDefinition").getText());
                contract.setWeekendDefinition(weekendDefinition);
                contractLineId = this.readBooleanContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("CompleteWeekends"), ContractLineType.COMPLETE_WEEKENDS);
                contractLineId = this.readBooleanContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("IdenticalShiftTypesDuringWeekend"), ContractLineType.IDENTICAL_SHIFT_TYPES_DURING_WEEKEND);
                contractLineId = this.readBooleanContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("NoNightShiftBeforeFreeWeekend"), ContractLineType.NO_NIGHT_SHIFT_BEFORE_FREE_WEEKEND);
                contractLineId = this.readBooleanContractLine(contract, contractLineList, contractLineListOfContract, contractLineId, element.getChild("AlternativeSkillCategory"), ContractLineType.ALTERNATIVE_SKILL_CATEGORY);
                contract.setContractLineList(contractLineListOfContract);
                List unwantedPatternElementList = element.getChild("UnwantedPatterns").getChildren();
                for (Element patternElement : unwantedPatternElementList) {
                    this.assertElementName(patternElement, "Pattern");
                    Pattern pattern = this.patternMap.get(patternElement.getText());
                    if (pattern == null) {
                        throw new IllegalArgumentException("The pattern (" + patternElement.getText() + ") of contract (" + contract.getCode() + ") does not exist.");
                    }
                    PatternContractLine patternContractLine = new PatternContractLine();
                    patternContractLine.setId(patternContractLineId);
                    patternContractLine.setContract(contract);
                    patternContractLine.setPattern(pattern);
                    patternContractLineList.add(patternContractLine);
                    ++patternContractLineId;
                }
                contractList.add(contract);
                if (this.contractMap.containsKey(contract.getCode())) {
                    throw new IllegalArgumentException("There are 2 contracts with the same code (" + contract.getCode() + ").");
                }
                this.contractMap.put(contract.getCode(), contract);
                ++id;
            }
            nurseRoster.setContractList(contractList);
            nurseRoster.setContractLineList(contractLineList);
            nurseRoster.setPatternContractLineList(patternContractLineList);
        }

        private long readBooleanContractLine(Contract contract, List<ContractLine> contractLineList, List<ContractLine> contractLineListOfContract, long contractLineId, Element element, ContractLineType contractLineType) throws DataConversionException {
            int weight;
            boolean enabled = Boolean.valueOf(element.getText());
            if (enabled) {
                weight = element.getAttribute("weight").getIntValue();
                if (weight < 0) {
                    throw new IllegalArgumentException("The weight (" + weight + ") of contract (" + contract.getCode() + ") and contractLineType (" + (Object)((Object)contractLineType) + ") should be 0 or at least 1.");
                }
                if (weight == 0) {
                    enabled = false;
                    NurseRosteringImporter.this.logger.warn("In contract ({}), the contractLineType ({}) is enabled with weight 0.", (Object)contract.getCode(), (Object)contractLineType);
                }
            } else {
                weight = 0;
            }
            if (enabled) {
                BooleanContractLine contractLine = new BooleanContractLine();
                contractLine.setId(contractLineId);
                contractLine.setContract(contract);
                contractLine.setContractLineType(contractLineType);
                contractLine.setEnabled(enabled);
                contractLine.setWeight(weight);
                contractLineList.add(contractLine);
                contractLineListOfContract.add(contractLine);
                ++contractLineId;
            }
            return contractLineId;
        }

        private long readMinMaxContractLine(Contract contract, List<ContractLine> contractLineList, List<ContractLine> contractLineListOfContract, long contractLineId, Element minElement, Element maxElement, ContractLineType contractLineType) throws DataConversionException {
            int maximumWeight;
            boolean maximumEnabled;
            int minimumWeight;
            boolean minimumEnabled;
            boolean bl = minimumEnabled = minElement == null ? false : minElement.getAttribute("on").getBooleanValue();
            if (minimumEnabled) {
                minimumWeight = minElement.getAttribute("weight").getIntValue();
                if (minimumWeight < 0) {
                    throw new IllegalArgumentException("The minimumWeight (" + minimumWeight + ") of contract (" + contract.getCode() + ") and contractLineType (" + (Object)((Object)contractLineType) + ") should be 0 or at least 1.");
                }
                if (minimumWeight == 0) {
                    minimumEnabled = false;
                    NurseRosteringImporter.this.logger.warn("In contract ({}), the contractLineType ({}) minimum is enabled with weight 0.", (Object)contract.getCode(), (Object)contractLineType);
                }
            } else {
                minimumWeight = 0;
            }
            boolean bl2 = maximumEnabled = maxElement == null ? false : maxElement.getAttribute("on").getBooleanValue();
            if (maximumEnabled) {
                maximumWeight = maxElement.getAttribute("weight").getIntValue();
                if (maximumWeight < 0) {
                    throw new IllegalArgumentException("The maximumWeight (" + maximumWeight + ") of contract (" + contract.getCode() + ") and contractLineType (" + (Object)((Object)contractLineType) + ") should be 0 or at least 1.");
                }
                if (maximumWeight == 0) {
                    maximumEnabled = false;
                    NurseRosteringImporter.this.logger.warn("In contract ({}), the contractLineType ({}) maximum is enabled with weight 0.", (Object)contract.getCode(), (Object)contractLineType);
                }
            } else {
                maximumWeight = 0;
            }
            if (minimumEnabled || maximumEnabled) {
                MinMaxContractLine contractLine = new MinMaxContractLine();
                contractLine.setId(contractLineId);
                contractLine.setContract(contract);
                contractLine.setContractLineType(contractLineType);
                contractLine.setMinimumEnabled(minimumEnabled);
                if (minimumEnabled) {
                    int minimumValue = Integer.parseInt(minElement.getText());
                    if (minimumValue < 1) {
                        throw new IllegalArgumentException("The minimumValue (" + minimumValue + ") of contract (" + contract.getCode() + ") and contractLineType (" + (Object)((Object)contractLineType) + ") should be at least 1.");
                    }
                    contractLine.setMinimumValue(minimumValue);
                    contractLine.setMinimumWeight(minimumWeight);
                }
                contractLine.setMaximumEnabled(maximumEnabled);
                if (maximumEnabled) {
                    int maximumValue = Integer.parseInt(maxElement.getText());
                    if (maximumValue < 0) {
                        throw new IllegalArgumentException("The maximumValue (" + maximumValue + ") of contract (" + contract.getCode() + ") and contractLineType (" + (Object)((Object)contractLineType) + ") should be at least 0.");
                    }
                    contractLine.setMaximumValue(maximumValue);
                    contractLine.setMaximumWeight(maximumWeight);
                }
                contractLineList.add(contractLine);
                contractLineListOfContract.add(contractLine);
                ++contractLineId;
            }
            return contractLineId;
        }

        private void readEmployeeList(NurseRoster nurseRoster, Element employeesElement) throws JDOMException {
            List employeeElementList = employeesElement.getChildren();
            ArrayList<Employee> employeeList = new ArrayList<Employee>(employeeElementList.size());
            this.employeeMap = new HashMap<String, Employee>(employeeElementList.size());
            long id = 0L;
            ArrayList<SkillProficiency> skillProficiencyList = new ArrayList<SkillProficiency>(employeeElementList.size() * 2);
            long skillProficiencyId = 0L;
            for (Element element : employeeElementList) {
                this.assertElementName(element, "Employee");
                Employee employee = new Employee();
                employee.setId(id);
                employee.setCode(element.getAttribute("ID").getValue());
                employee.setName(element.getChild("Name").getText());
                Element contractElement = element.getChild("ContractID");
                Contract contract = this.contractMap.get(contractElement.getText());
                if (contract == null) {
                    throw new IllegalArgumentException("The contract (" + contractElement.getText() + ") of employee (" + employee.getCode() + ") does not exist.");
                }
                employee.setContract(contract);
                int estimatedRequestSize = this.shiftDateMap.size() / employeeElementList.size() + 1;
                employee.setDayOffRequestMap(new HashMap<ShiftDate, DayOffRequest>(estimatedRequestSize));
                employee.setDayOnRequestMap(new HashMap<ShiftDate, DayOnRequest>(estimatedRequestSize));
                employee.setShiftOffRequestMap(new HashMap<Shift, ShiftOffRequest>(estimatedRequestSize));
                employee.setShiftOnRequestMap(new HashMap<Shift, ShiftOnRequest>(estimatedRequestSize));
                Element skillsElement = element.getChild("Skills");
                if (skillsElement != null) {
                    List skillElementList = skillsElement.getChildren();
                    for (Element skillElement : skillElementList) {
                        this.assertElementName(skillElement, "Skill");
                        Skill skill = this.skillMap.get(skillElement.getText());
                        if (skill == null) {
                            throw new IllegalArgumentException("The skill (" + skillElement.getText() + ") of employee (" + employee.getCode() + ") does not exist.");
                        }
                        SkillProficiency skillProficiency = new SkillProficiency();
                        skillProficiency.setId(skillProficiencyId);
                        skillProficiency.setEmployee(employee);
                        skillProficiency.setSkill(skill);
                        skillProficiencyList.add(skillProficiency);
                        ++skillProficiencyId;
                    }
                }
                employeeList.add(employee);
                if (this.employeeMap.containsKey(employee.getCode())) {
                    throw new IllegalArgumentException("There are 2 employees with the same code (" + employee.getCode() + ").");
                }
                this.employeeMap.put(employee.getCode(), employee);
                ++id;
            }
            nurseRoster.setEmployeeList(employeeList);
            nurseRoster.setSkillProficiencyList(skillProficiencyList);
        }

        private void readRequiredEmployeeSizes(NurseRoster nurseRoster, Element coverRequirementsElement) {
            List coverRequirementElementList = coverRequirementsElement.getChildren();
            for (Element element : coverRequirementElementList) {
                if (element.getName().equals("DayOfWeekCover")) {
                    Element dayOfWeekElement = element.getChild("Day");
                    DayOfWeek dayOfWeek = DayOfWeek.valueOfCode(dayOfWeekElement.getText());
                    if (dayOfWeek == null) {
                        throw new IllegalArgumentException("The dayOfWeek (" + dayOfWeekElement.getText() + ") of an entity DayOfWeekCover does not exist.");
                    }
                    List coverElementList = element.getChildren("Cover");
                    for (Element coverElement : coverElementList) {
                        Element shiftTypeElement = coverElement.getChild("Shift");
                        ShiftType shiftType = this.shiftTypeMap.get(shiftTypeElement.getText());
                        if (shiftType == null) {
                            if (shiftTypeElement.getText().equals("Any")) {
                                throw new IllegalStateException("The shiftType Any is not supported on DayOfWeekCover.");
                            }
                            if (shiftTypeElement.getText().equals("None")) {
                                throw new IllegalStateException("The shiftType None is not supported on DayOfWeekCover.");
                            }
                            throw new IllegalArgumentException("The shiftType (" + shiftTypeElement.getText() + ") of an entity DayOfWeekCover does not exist.");
                        }
                        List<Object> key = Arrays.asList(new Object[]{dayOfWeek, shiftType});
                        List<Shift> shiftList = this.dayOfWeekAndShiftTypeToShiftListMap.get(key);
                        if (shiftList == null) {
                            throw new IllegalArgumentException("The dayOfWeek (" + dayOfWeekElement.getText() + ") with the shiftType (" + shiftTypeElement.getText() + ") of an entity DayOfWeekCover does not have any shifts.");
                        }
                        int requiredEmployeeSize = Integer.parseInt(coverElement.getChild("Preferred").getText());
                        for (Shift shift : shiftList) {
                            shift.setRequiredEmployeeSize(shift.getRequiredEmployeeSize() + requiredEmployeeSize);
                        }
                    }
                    continue;
                }
                if (element.getName().equals("DateSpecificCover")) {
                    Element dateElement = element.getChild("Date");
                    List coverElementList = element.getChildren("Cover");
                    for (Element coverElement : coverElementList) {
                        Element shiftTypeElement = coverElement.getChild("Shift");
                        Shift shift = this.dateAndShiftTypeToShiftMap.get(Arrays.asList(dateElement.getText(), shiftTypeElement.getText()));
                        if (shift == null) {
                            throw new IllegalArgumentException("The date (" + dateElement.getText() + ") with the shiftType (" + shiftTypeElement.getText() + ") of an entity DateSpecificCover does not have a shift.");
                        }
                        int requiredEmployeeSize = Integer.parseInt(coverElement.getChild("Preferred").getText());
                        shift.setRequiredEmployeeSize(shift.getRequiredEmployeeSize() + requiredEmployeeSize);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown cover entity (" + element.getName() + ").");
            }
        }

        private void readDayOffRequestList(NurseRoster nurseRoster, Element dayOffRequestsElement) throws JDOMException {
            List<DayOffRequest> dayOffRequestList;
            if (dayOffRequestsElement == null) {
                dayOffRequestList = Collections.emptyList();
            } else {
                List dayOffElementList = dayOffRequestsElement.getChildren();
                dayOffRequestList = new ArrayList<DayOffRequest>(dayOffElementList.size());
                long id = 0L;
                for (Element element : dayOffElementList) {
                    this.assertElementName(element, "DayOff");
                    DayOffRequest dayOffRequest = new DayOffRequest();
                    dayOffRequest.setId(id);
                    Element employeeElement = element.getChild("EmployeeID");
                    Employee employee = this.employeeMap.get(employeeElement.getText());
                    if (employee == null) {
                        throw new IllegalArgumentException("The shiftDate (" + employeeElement.getText() + ") of dayOffRequest (" + dayOffRequest + ") does not exist.");
                    }
                    dayOffRequest.setEmployee(employee);
                    Element dateElement = element.getChild("Date");
                    ShiftDate shiftDate = this.shiftDateMap.get(dateElement.getText());
                    if (shiftDate == null) {
                        throw new IllegalArgumentException("The date (" + dateElement.getText() + ") of dayOffRequest (" + dayOffRequest + ") does not exist.");
                    }
                    dayOffRequest.setShiftDate(shiftDate);
                    dayOffRequest.setWeight(element.getAttribute("weight").getIntValue());
                    dayOffRequestList.add(dayOffRequest);
                    employee.getDayOffRequestMap().put(shiftDate, dayOffRequest);
                    ++id;
                }
            }
            nurseRoster.setDayOffRequestList(dayOffRequestList);
        }

        private void readDayOnRequestList(NurseRoster nurseRoster, Element dayOnRequestsElement) throws JDOMException {
            List<DayOnRequest> dayOnRequestList;
            if (dayOnRequestsElement == null) {
                dayOnRequestList = Collections.emptyList();
            } else {
                List dayOnElementList = dayOnRequestsElement.getChildren();
                dayOnRequestList = new ArrayList<DayOnRequest>(dayOnElementList.size());
                long id = 0L;
                for (Element element : dayOnElementList) {
                    this.assertElementName(element, "DayOn");
                    DayOnRequest dayOnRequest = new DayOnRequest();
                    dayOnRequest.setId(id);
                    Element employeeElement = element.getChild("EmployeeID");
                    Employee employee = this.employeeMap.get(employeeElement.getText());
                    if (employee == null) {
                        throw new IllegalArgumentException("The shiftDate (" + employeeElement.getText() + ") of dayOnRequest (" + dayOnRequest + ") does not exist.");
                    }
                    dayOnRequest.setEmployee(employee);
                    Element dateElement = element.getChild("Date");
                    ShiftDate shiftDate = this.shiftDateMap.get(dateElement.getText());
                    if (shiftDate == null) {
                        throw new IllegalArgumentException("The date (" + dateElement.getText() + ") of dayOnRequest (" + dayOnRequest + ") does not exist.");
                    }
                    dayOnRequest.setShiftDate(shiftDate);
                    dayOnRequest.setWeight(element.getAttribute("weight").getIntValue());
                    dayOnRequestList.add(dayOnRequest);
                    employee.getDayOnRequestMap().put(shiftDate, dayOnRequest);
                    ++id;
                }
            }
            nurseRoster.setDayOnRequestList(dayOnRequestList);
        }

        private void readShiftOffRequestList(NurseRoster nurseRoster, Element shiftOffRequestsElement) throws JDOMException {
            List<ShiftOffRequest> shiftOffRequestList;
            if (shiftOffRequestsElement == null) {
                shiftOffRequestList = Collections.emptyList();
            } else {
                List shiftOffElementList = shiftOffRequestsElement.getChildren();
                shiftOffRequestList = new ArrayList<ShiftOffRequest>(shiftOffElementList.size());
                long id = 0L;
                for (Element element : shiftOffElementList) {
                    this.assertElementName(element, "ShiftOff");
                    ShiftOffRequest shiftOffRequest = new ShiftOffRequest();
                    shiftOffRequest.setId(id);
                    Element employeeElement = element.getChild("EmployeeID");
                    Employee employee = this.employeeMap.get(employeeElement.getText());
                    if (employee == null) {
                        throw new IllegalArgumentException("The shift (" + employeeElement.getText() + ") of shiftOffRequest (" + shiftOffRequest + ") does not exist.");
                    }
                    shiftOffRequest.setEmployee(employee);
                    Element dateElement = element.getChild("Date");
                    Element shiftTypeElement = element.getChild("ShiftTypeID");
                    Shift shift = this.dateAndShiftTypeToShiftMap.get(Arrays.asList(dateElement.getText(), shiftTypeElement.getText()));
                    if (shift == null) {
                        throw new IllegalArgumentException("The date (" + dateElement.getText() + ") or the shiftType (" + shiftTypeElement.getText() + ") of shiftOffRequest (" + shiftOffRequest + ") does not exist.");
                    }
                    shiftOffRequest.setShift(shift);
                    shiftOffRequest.setWeight(element.getAttribute("weight").getIntValue());
                    shiftOffRequestList.add(shiftOffRequest);
                    employee.getShiftOffRequestMap().put(shift, shiftOffRequest);
                    ++id;
                }
            }
            nurseRoster.setShiftOffRequestList(shiftOffRequestList);
        }

        private void readShiftOnRequestList(NurseRoster nurseRoster, Element shiftOnRequestsElement) throws JDOMException {
            List<ShiftOnRequest> shiftOnRequestList;
            if (shiftOnRequestsElement == null) {
                shiftOnRequestList = Collections.emptyList();
            } else {
                List shiftOnElementList = shiftOnRequestsElement.getChildren();
                shiftOnRequestList = new ArrayList<ShiftOnRequest>(shiftOnElementList.size());
                long id = 0L;
                for (Element element : shiftOnElementList) {
                    this.assertElementName(element, "ShiftOn");
                    ShiftOnRequest shiftOnRequest = new ShiftOnRequest();
                    shiftOnRequest.setId(id);
                    Element employeeElement = element.getChild("EmployeeID");
                    Employee employee = this.employeeMap.get(employeeElement.getText());
                    if (employee == null) {
                        throw new IllegalArgumentException("The shift (" + employeeElement.getText() + ") of shiftOnRequest (" + shiftOnRequest + ") does not exist.");
                    }
                    shiftOnRequest.setEmployee(employee);
                    Element dateElement = element.getChild("Date");
                    Element shiftTypeElement = element.getChild("ShiftTypeID");
                    Shift shift = this.dateAndShiftTypeToShiftMap.get(Arrays.asList(dateElement.getText(), shiftTypeElement.getText()));
                    if (shift == null) {
                        throw new IllegalArgumentException("The date (" + dateElement.getText() + ") or the shiftType (" + shiftTypeElement.getText() + ") of shiftOnRequest (" + shiftOnRequest + ") does not exist.");
                    }
                    shiftOnRequest.setShift(shift);
                    shiftOnRequest.setWeight(element.getAttribute("weight").getIntValue());
                    shiftOnRequestList.add(shiftOnRequest);
                    employee.getShiftOnRequestMap().put(shift, shiftOnRequest);
                    ++id;
                }
            }
            nurseRoster.setShiftOnRequestList(shiftOnRequestList);
        }

        private void createShiftAssignmentList(NurseRoster nurseRoster) {
            List<Shift> shiftList = nurseRoster.getShiftList();
            ArrayList<ShiftAssignment> shiftAssignmentList = new ArrayList<ShiftAssignment>(shiftList.size());
            long id = 0L;
            for (Shift shift : shiftList) {
                for (int i = 0; i < shift.getRequiredEmployeeSize(); ++i) {
                    ShiftAssignment shiftAssignment = new ShiftAssignment();
                    shiftAssignment.setId(id);
                    ++id;
                    shiftAssignment.setShift(shift);
                    shiftAssignment.setIndexInShift(i);
                    shiftAssignmentList.add(shiftAssignment);
                }
            }
            nurseRoster.setShiftAssignmentList(shiftAssignmentList);
        }
    }
}

