<?xml version="1.0" encoding="UTF-8"?>
<plannerBenchmark>
  <benchmarkDirectory>local/data/vehiclerouting/template</benchmarkDirectory>
  <parallelBenchmarkCount>AUTO</parallelBenchmarkCount>
  <warmUpSecondsSpentLimit>30</warmUpSecondsSpentLimit>

  <inheritedSolverBenchmark>
    <problemBenchmarks>
      <problemIOClass>org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingProblemIO</problemIOClass>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n32-k5.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n33-k5.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n33-k6.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n34-k5.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n36-k5.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n37-k5.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n37-k6.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n38-k5.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n39-k5.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n39-k6.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n44-k7.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n45-k6.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n45-k7.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n46-k7.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n48-k7.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n53-k7.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n54-k7.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n55-k9.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n60-k9.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n61-k9.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n62-k8.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n63-k10.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n63-k9.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n64-k9.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n65-k9.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n69-k9.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/A-n80-k10.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/F-n135-k7.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/F-n45-k4.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/capacitated/F-n72-k4.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_025_C101.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_025_C201.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_025_R101.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_025_R201.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_025_RC101.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_025_RC201.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_100_C101.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_100_C201.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_100_R101.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_100_R201.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_100_RC101.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Solomon_100_RC201.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0200_C1_2_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0200_C2_2_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0200_R1_2_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0200_R2_2_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0200_RC1_2_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0200_RC2_2_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0400_C1_4_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0400_C2_4_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0400_R1_4_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0400_R2_4_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0400_RC1_4_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0400_RC2_4_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0600_C1_6_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0600_C2_6_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0600_R1_6_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0600_R2_6_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0600_RC2_6_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0600_RC1_6_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0800_C1_8_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0800_C2_8_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0800_R1_8_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0800_R2_8_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0800_RC1_8_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_0800_RC2_8_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_1000_C110_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_1000_C210_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_1000_R110_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_1000_R210_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_1000_RC110_1.vrp</inputSolutionFile>
      <inputSolutionFile>data/vehiclerouting/import/timewindowed/Homberger_1000_RC210_1.vrp</inputSolutionFile>
      <problemStatisticType>BEST_SCORE</problemStatisticType>
    </problemBenchmarks>

    <solver>
      <!--<environmentMode>FAST_ASSERT</environmentMode>-->
      <solutionClass>org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution</solutionClass>
      <planningEntityClass>org.optaplanner.examples.vehiclerouting.domain.Customer</planningEntityClass>
      <planningEntityClass>org.optaplanner.examples.vehiclerouting.domain.Standstill</planningEntityClass>

      <scoreDirectorFactory>
        <scoreDefinitionType>HARD_SOFT</scoreDefinitionType>
        <incrementalScoreCalculatorClass>org.optaplanner.examples.vehiclerouting.solver.score.VehicleRoutingIncrementalScoreCalculator</incrementalScoreCalculatorClass>
        <!--<scoreDrl>/org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingScoreRules.drl</scoreDrl>-->
      </scoreDirectorFactory>

      <termination>
        <minutesSpentLimit>5</minutesSpentLimit>
      </termination>
    </solver>
  </inheritedSolverBenchmark>

<#list [7, 9] as entityTabuSize>
  <solverBenchmark>
    <name>entityTabu ${entityTabuSize}</name>
    <solver>
      <constructionHeuristic>
        <constructionHeuristicType>FIRST_FIT_DECREASING</constructionHeuristicType>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <changeMoveSelector/>
          <swapMoveSelector/>
          <subChainChangeMoveSelector>
            <selectReversingMoveToo>true</selectReversingMoveToo>
          </subChainChangeMoveSelector>
          <subChainSwapMoveSelector>
            <selectReversingMoveToo>true</selectReversingMoveToo>
          </subChainSwapMoveSelector>
        </unionMoveSelector>
        <acceptor>
          <entityTabuSize>${entityTabuSize}</entityTabuSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>2000</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
</#list>
<#list [100, 200, 400] as lateAcceptanceSize>
  <solverBenchmark>
    <name>lateAcceptance ${lateAcceptanceSize}</name>
    <solver>
      <constructionHeuristic>
        <constructionHeuristicType>FIRST_FIT_DECREASING</constructionHeuristicType>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <changeMoveSelector/>
          <swapMoveSelector/>
          <subChainChangeMoveSelector>
            <selectReversingMoveToo>true</selectReversingMoveToo>
          </subChainChangeMoveSelector>
          <subChainSwapMoveSelector>
            <selectReversingMoveToo>true</selectReversingMoveToo>
          </subChainSwapMoveSelector>
        </unionMoveSelector>
        <acceptor>
          <lateAcceptanceSize>${lateAcceptanceSize}</lateAcceptanceSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>1</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
</#list>
<#list [50, 300] as stepCountingHillClimbingSize>
    <solverBenchmark>
        <name>Step Counting Hill Climbing ${stepCountingHillClimbingSize}</name>
        <solver>
            <constructionHeuristic>
                <constructionHeuristicType>FIRST_FIT_DECREASING</constructionHeuristicType>
            </constructionHeuristic>
            <localSearch>
                <unionMoveSelector>
                    <changeMoveSelector/>
                    <swapMoveSelector/>
                    <subChainChangeMoveSelector>
                        <selectReversingMoveToo>true</selectReversingMoveToo>
                    </subChainChangeMoveSelector>
                    <subChainSwapMoveSelector>
                        <selectReversingMoveToo>true</selectReversingMoveToo>
                    </subChainSwapMoveSelector>
                </unionMoveSelector>
                <acceptor>
                    <stepCountingHillClimbingSize>${stepCountingHillClimbingSize}</stepCountingHillClimbingSize>
                </acceptor>
                <forager>
                    <acceptedCountLimit>1</acceptedCountLimit>
                </forager>
            </localSearch>
        </solver>
    </solverBenchmark>
</#list>
</plannerBenchmark>
