/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.IOException;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.persistence.TspDao;

public class TspExporter
extends AbstractTxtSolutionExporter {
    public static final String OUTPUT_FILE_SUFFIX = "tour";

    public static void main(String[] args) {
        new TspExporter().convertAll();
    }

    public TspExporter() {
        super(new TspDao());
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new TspOutputBuilder();
    }

    public static class TspOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private TravelingSalesmanTour tour;

        @Override
        public void setSolution(Solution solution) {
            this.tour = (TravelingSalesmanTour)solution;
        }

        @Override
        public void writeSolution() throws IOException {
            this.bufferedWriter.write("NAME : " + this.tour.getName() + "\n");
            this.bufferedWriter.write("TYPE : TOUR\n");
            this.bufferedWriter.write("DIMENSION : " + this.tour.getCityList().size() + "\n");
            this.bufferedWriter.write("TOUR_SECTION\n");
            Standstill standstill = this.tour.getDomicile();
            while (standstill != null) {
                this.bufferedWriter.write(standstill.getCity().getId() + "\n");
                standstill = this.findNextVisit(standstill);
            }
            this.bufferedWriter.write("EOF\n");
        }

        private Standstill findNextVisit(Standstill standstill) {
            for (Visit visit : this.tour.getVisitList()) {
                if (visit.getPreviousStandstill() != standstill) continue;
                return visit;
            }
            return null;
        }
    }
}

