/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.tsp.domain.City;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.persistence.TspDao;

public class TspImporter
extends AbstractTxtSolutionImporter {
    public static final String INPUT_FILE_SUFFIX = "tsp";

    public static void main(String[] args) {
        new TspImporter().convertAll();
    }

    public TspImporter() {
        super(new TspDao());
    }

    @Override
    public String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    @Override
    public boolean acceptInputFileDuringBulkConvert(File inputFile) {
        return !Arrays.asList("ch71009.tsp").contains(inputFile.getName());
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new TspInputBuilder();
    }

    public static class TspInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private TravelingSalesmanTour travelingSalesmanTour;
        private int cityListSize;

        @Override
        public Solution readSolution() throws IOException {
            this.travelingSalesmanTour = new TravelingSalesmanTour();
            this.travelingSalesmanTour.setId(0L);
            String firstLine = this.readStringValue();
            if (firstLine.trim().startsWith("NAME :")) {
                this.travelingSalesmanTour.setName(this.removePrefixSuffixFromLine(firstLine, "NAME :", ""));
                this.readTspLibFormat();
            } else {
                this.travelingSalesmanTour.setName(FilenameUtils.getBaseName((String)this.inputFile.getName()));
                this.cityListSize = Integer.parseInt(firstLine.trim());
                this.readCourseraFormat();
            }
            BigInteger possibleSolutionSize = this.factorial(this.travelingSalesmanTour.getCityList().size() - 1);
            this.logger.info("TravelingSalesmanTour {} has {} cities with a search space of {}.", new Object[]{this.getInputId(), this.travelingSalesmanTour.getCityList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.travelingSalesmanTour;
        }

        private void readTspLibFormat() throws IOException {
            this.readTspLibHeaders();
            this.readTspLibCityList();
            this.readConstantLine("EOF");
            this.createVisitList();
        }

        private void readTspLibHeaders() throws IOException {
            this.readUntilConstantLine("TYPE : TSP");
            this.cityListSize = this.readIntegerValue("DIMENSION :");
            String edgeWeightType = this.readStringValue("EDGE_WEIGHT_TYPE :");
            if (!edgeWeightType.equalsIgnoreCase("EUC_2D")) {
                throw new IllegalArgumentException("The edgeWeightType (" + edgeWeightType + ") is not supported.");
            }
        }

        private void readTspLibCityList() throws IOException {
            this.readConstantLine("NODE_COORD_SECTION");
            ArrayList<City> cityList = new ArrayList<City>(this.cityListSize);
            for (int i = 0; i < this.cityListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line, 3, 4);
                City city = new City();
                city.setId(Long.parseLong(lineTokens[0]));
                city.setLatitude(Double.parseDouble(lineTokens[1]));
                city.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    city.setName(lineTokens[3]);
                }
                cityList.add(city);
            }
            this.travelingSalesmanTour.setCityList(cityList);
        }

        private void createVisitList() {
            List<City> cityList = this.travelingSalesmanTour.getCityList();
            ArrayList<Visit> visitList = new ArrayList<Visit>(cityList.size() - 1);
            int count = 0;
            for (City city : cityList) {
                if (count < 1) {
                    Domicile domicile = new Domicile();
                    domicile.setId(city.getId());
                    domicile.setCity(city);
                    this.travelingSalesmanTour.setDomicile(domicile);
                } else {
                    Visit visit = new Visit();
                    visit.setId(city.getId());
                    visit.setCity(city);
                    visitList.add(visit);
                }
                ++count;
            }
            this.travelingSalesmanTour.setVisitList(visitList);
        }

        private void readCourseraFormat() throws IOException {
            ArrayList<City> cityList = new ArrayList<City>(this.cityListSize);
            long id = 0L;
            for (int i = 0; i < this.cityListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line, 2);
                City city = new City();
                city.setId(id);
                ++id;
                city.setLatitude(Double.parseDouble(lineTokens[0]));
                city.setLongitude(Double.parseDouble(lineTokens[1]));
                cityList.add(city);
            }
            this.travelingSalesmanTour.setCityList(cityList);
            this.createVisitList();
        }
    }
}

