/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.location.segmented;

import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;

public class RoadSegmentLocationTest {
    @Test
    public void getDistance() {
        long id = 0L;
        RoadSegmentLocation a = new RoadSegmentLocation(id++, 0.0, 0.0);
        RoadSegmentLocation b = new RoadSegmentLocation(id++, 0.0, 4.0);
        RoadSegmentLocation c = new RoadSegmentLocation(id++, 2.0, 0.0);
        RoadSegmentLocation d = new RoadSegmentLocation(id++, 100.0, 2.0);
        HubSegmentLocation x = new HubSegmentLocation(id++, 1.0, 0.0);
        HubSegmentLocation y = new HubSegmentLocation(id++, 1.0, 3.0);
        HubSegmentLocation z = new HubSegmentLocation(id++, 99.0, 3.0);
        a.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)a, b, c));
        a.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)a, x, y));
        b.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)b, a));
        b.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)b, x, y));
        c.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)c, a));
        c.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)c, x, y));
        d.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)d, new RoadSegmentLocation[0]));
        d.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)d, z));
        x.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)x, a, b, c));
        x.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)x, y, z));
        y.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)y, a, b, c));
        y.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)y, x, z));
        z.setNearbyTravelDistanceMap(this.createNearbyTravelDistanceMap((Location)z, d));
        z.setHubTravelDistanceMap(this.createHubTravelDistanceMap((Location)z, x, y));
        Assert.assertEquals((long)this.sumOfArcs((Location)a, new Location[]{b}), (long)a.getDistance((Location)b));
        Assert.assertEquals((long)this.sumOfArcs((Location)a, new Location[]{c}), (long)a.getDistance((Location)c));
        Assert.assertEquals((long)this.sumOfArcs((Location)a, new Location[]{x, z, d}), (long)a.getDistance((Location)d));
        Assert.assertEquals((long)this.sumOfArcs((Location)b, new Location[]{a}), (long)b.getDistance((Location)a));
        Assert.assertEquals((long)this.sumOfArcs((Location)b, new Location[]{y, c}), (long)b.getDistance((Location)c));
        Assert.assertEquals((long)this.sumOfArcs((Location)b, new Location[]{y, z, d}), (long)b.getDistance((Location)d));
        Assert.assertEquals((long)this.sumOfArcs((Location)c, new Location[]{a}), (long)c.getDistance((Location)a));
        Assert.assertEquals((long)this.sumOfArcs((Location)c, new Location[]{y, b}), (long)c.getDistance((Location)b));
        Assert.assertEquals((long)this.sumOfArcs((Location)c, new Location[]{x, z, d}), (long)c.getDistance((Location)d));
        Assert.assertEquals((long)this.sumOfArcs((Location)d, new Location[]{z, x, a}), (long)d.getDistance((Location)a));
        Assert.assertEquals((long)this.sumOfArcs((Location)d, new Location[]{z, y, b}), (long)d.getDistance((Location)b));
        Assert.assertEquals((long)this.sumOfArcs((Location)d, new Location[]{z, x, c}), (long)d.getDistance((Location)c));
    }

    protected int sumOfArcs(Location fromLocation, Location ... stopLocations) {
        Location previousLocation = fromLocation;
        int distance = 0;
        for (Location stopLocation : stopLocations) {
            distance += (int)(previousLocation.getAirDistanceDouble(stopLocation) * 1000.0 + 0.5);
            previousLocation = stopLocation;
        }
        return distance;
    }

    private Map<HubSegmentLocation, Double> createHubTravelDistanceMap(Location fromLocation, HubSegmentLocation ... toLocations) {
        LinkedHashMap<HubSegmentLocation, Double> map = new LinkedHashMap<HubSegmentLocation, Double>(toLocations.length);
        for (HubSegmentLocation toLocation : toLocations) {
            map.put(toLocation, fromLocation.getAirDistanceDouble((Location)toLocation));
        }
        return map;
    }

    protected Map<RoadSegmentLocation, Double> createNearbyTravelDistanceMap(Location fromLocation, RoadSegmentLocation ... toLocations) {
        LinkedHashMap<RoadSegmentLocation, Double> map = new LinkedHashMap<RoadSegmentLocation, Double>(toLocations.length);
        for (RoadSegmentLocation toLocation : toLocations) {
            map.put(toLocation, fromLocation.getAirDistanceDouble((Location)toLocation));
        }
        return map;
    }
}

