/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.persistence.SolutionDao;

@RunWith(value=Parameterized.class)
public abstract class PhaseTest
extends LoggingTest {
    protected SolutionDao solutionDao;
    protected File dataFile;

    protected static <EnumG extends Enum> Collection<Object[]> buildParameters(SolutionDao solutionDao, EnumG[] types, String ... unsolvedFileNames) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>(unsolvedFileNames.length * types.length);
        File dataDir = solutionDao.getDataDir();
        File unsolvedDataDir = new File(dataDir, "unsolved");
        for (String unsolvedFileName : unsolvedFileNames) {
            File unsolvedFile = new File(unsolvedDataDir, unsolvedFileName);
            if (!unsolvedFile.exists()) {
                throw new IllegalStateException("The directory unsolvedFile (" + unsolvedFile.getAbsolutePath() + ") does not exist.");
            }
            for (EnumG type : types) {
                filesAsParameters.add(new Object[]{unsolvedFile, type});
            }
        }
        return filesAsParameters;
    }

    protected PhaseTest(File dataFile) {
        this.dataFile = dataFile;
    }

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
    }

    protected abstract SolutionDao createSolutionDao();

    @Test(timeout=600000L)
    public void runPhase() {
        SolverFactory solverFactory = this.buildSolverFactory();
        Solution planningProblem = this.readPlanningProblem();
        Solver solver = solverFactory.buildSolver();
        solver.solve(planningProblem);
        Solution bestSolution = solver.getBestSolution();
        this.assertSolution(bestSolution);
    }

    protected void assertSolution(Solution bestSolution) {
        Assert.assertNotNull((Object)bestSolution);
        Assert.assertNotNull((Object)bestSolution.getScore());
    }

    protected abstract SolverFactory buildSolverFactory();

    protected abstract String createSolverConfigResource();

    protected Solution readPlanningProblem() {
        return this.solutionDao.readSolution(this.dataFile);
    }
}

