/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.tracking;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensStepTracking;

public class NQueensStepTracker
extends PhaseLifecycleListenerAdapter {
    private NQueens lastStepSolution = null;
    private List<NQueensStepTracking> trackingList = new ArrayList<NQueensStepTracking>();

    public List<NQueensStepTracking> getTrackingList() {
        return this.trackingList;
    }

    public void phaseStarted(AbstractPhaseScope phaseScope) {
        this.lastStepSolution = (NQueens)phaseScope.getSolverScope().getBestSolution();
    }

    public void stepEnded(AbstractStepScope stepScope) {
        NQueens queens = (NQueens)stepScope.getWorkingSolution();
        for (int i = 0; i < queens.getQueenList().size(); ++i) {
            Queen queen = (Queen)queens.getQueenList().get(i);
            Queen lastStepQueen = (Queen)this.lastStepSolution.getQueenList().get(i);
            if (queen.getRowIndex() == lastStepQueen.getRowIndex()) continue;
            this.trackingList.add(new NQueensStepTracking(queen.getColumnIndex(), queen.getRowIndex()));
            break;
        }
        this.lastStepSolution = (NQueens)stepScope.createOrGetClonedSolution();
    }
}

