/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.impl.PlannerBenchmarkRunner;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.examples.common.app.CommonBenchmarkApp;

@RunWith(value=Parameterized.class)
public abstract class AbstractBenchmarkConfigTest {
    protected CommonBenchmarkApp.ArgOption argOption;

    protected static Collection<Object[]> getArgOptionsAsParameters(CommonBenchmarkApp benchmarkApp) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        for (CommonBenchmarkApp.ArgOption argOption : benchmarkApp.getArgOptions()) {
            filesAsParameters.add(new Object[]{argOption});
        }
        return filesAsParameters;
    }

    protected AbstractBenchmarkConfigTest(CommonBenchmarkApp.ArgOption argOption) {
        this.argOption = argOption;
    }

    @Test
    public void buildPlannerBenchmark() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = this.argOption.buildPlannerBenchmarkFactory();
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        this.buildEverySolver(plannerBenchmark);
    }

    protected void buildEverySolver(PlannerBenchmark plannerBenchmark) {
        SolverConfigContext configContext = new SolverConfigContext();
        PlannerBenchmarkResult plannerBenchmarkResult = ((PlannerBenchmarkRunner)plannerBenchmark).getPlannerBenchmarkResult();
        for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            SolverConfig solverConfig = solverBenchmarkResult.getSolverConfig();
            solverConfig.buildSolver(configContext);
        }
    }
}

