/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.solver.drools;

import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;

public class MachinePeriodPart {
    private final Machine machine;
    private final int period;
    private boolean active;
    private int[] resourceAvailableList;
    private int resourceInShortTotal;

    public MachinePeriodPart(Machine machine, int period, int resourceListSize, List<TaskAssignment> taskAssignmentList) {
        this.machine = machine;
        this.period = period;
        this.active = false;
        this.resourceAvailableList = new int[resourceListSize];
        for (int i = 0; i < resourceListSize; ++i) {
            this.resourceAvailableList[i] = machine.getMachineCapacityList().get(i).getCapacity();
        }
        for (TaskAssignment taskAssignment : taskAssignmentList) {
            this.addTaskAssignment(taskAssignment);
        }
        this.resourceInShortTotal = 0;
        for (Object resourceAvailable : (Object)this.resourceAvailableList) {
            if (resourceAvailable >= 0) continue;
            this.resourceInShortTotal += resourceAvailable;
        }
    }

    private void addTaskAssignment(TaskAssignment taskAssignment) {
        this.active = true;
        Task task = taskAssignment.getTask();
        int i = 0;
        while (i < this.resourceAvailableList.length) {
            TaskRequirement taskRequirement = task.getTaskRequirementList().get(i);
            int n = i++;
            this.resourceAvailableList[n] = this.resourceAvailableList[n] - taskRequirement.getResourceUsage();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int[] getResourceAvailableList() {
        return this.resourceAvailableList;
    }

    public void setResourceAvailableList(int[] resourceAvailableList) {
        this.resourceAvailableList = resourceAvailableList;
    }

    public int getResourceInShortTotal() {
        return this.resourceInShortTotal;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public int getPeriod() {
        return this.period;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MachinePeriodPart) {
            MachinePeriodPart other = (MachinePeriodPart)o;
            return new EqualsBuilder().append((Object)this.machine, (Object)other.machine).append(this.period, other.period).append(this.active, other.active).append(this.resourceAvailableList, other.resourceAvailableList).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.machine).append(this.period).append(this.active).append(this.resourceAvailableList).toHashCode();
    }

    public int compareTo(MachinePeriodPart other) {
        return new CompareToBuilder().append((Object)this.machine, (Object)other.machine).append(this.period, other.period).append(this.active, other.active).append(this.resourceAvailableList, other.resourceAvailableList).toComparison();
    }

    public String toString() {
        return this.machine + ", period = " + this.period + ", active = " + this.active + ", resourceAvailableList = " + this.resourceAvailableList;
    }
}

