/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.persistence;

import java.io.IOException;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusHub;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;
import org.optaplanner.examples.coachshuttlegathering.persistence.CoachShuttleGatheringDao;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;

public class CoachShuttleGatheringExporter
extends AbstractTxtSolutionExporter {
    public static final String OUTPUT_FILE_SUFFIX = "csv";

    public static void main(String[] args) {
        new CoachShuttleGatheringExporter().convertAll();
    }

    public CoachShuttleGatheringExporter() {
        super(new CoachShuttleGatheringDao());
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new CoachShuttleGatheringOutputBuilder();
    }

    public static class CoachShuttleGatheringOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private CoachShuttleGatheringSolution solution;

        @Override
        public void setSolution(Solution solution) {
            this.solution = (CoachShuttleGatheringSolution)solution;
        }

        @Override
        public void writeSolution() throws IOException {
            this.bufferedWriter.append("VEHICLE_ID;TOUR_POSITION;LOCATION_ID;LOCATION_TYPE\n");
            for (Bus bus : this.solution.getBusList()) {
                int i = 1;
                for (BusStop stop = bus.getNextStop(); stop != null; stop = stop.getNextStop()) {
                    this.bufferedWriter.append(bus.getName()).append(";").append(Integer.toString(i)).append(";").append(stop.getName()).append(";").append("BUSSTOP").append("\n");
                    ++i;
                }
                if (i <= 1 && !(bus instanceof Coach)) continue;
                StopOrHub destination = bus.getDestination();
                this.bufferedWriter.append(bus.getName()).append(";").append(Integer.toString(i)).append(";").append(destination.getName()).append(";").append(destination instanceof BusHub ? "HUB" : "BUSSTOP").append("\n").append("\n");
            }
        }
    }
}

