/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.business;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedSwapMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionBusiness<Solution_ extends Solution> {
    private static final ProblemFileComparator FILE_COMPARATOR = new ProblemFileComparator();
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CommonApp app;
    private SolutionDao solutionDao;
    private AbstractSolutionImporter[] importers;
    private AbstractSolutionExporter exporter;
    private File importDataDir;
    private File unsolvedDataDir;
    private File solvedDataDir;
    private File exportDataDir;
    private volatile Solver<Solution_> solver;
    private String solutionFileName = null;
    private ScoreDirector guiScoreDirector;

    public SolutionBusiness(CommonApp app) {
        this.app = app;
    }

    public String getAppName() {
        return this.app.getName();
    }

    public String getAppDescription() {
        return this.app.getDescription();
    }

    public String getAppIconResource() {
        return this.app.getIconResource();
    }

    public void setSolutionDao(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
    }

    public AbstractSolutionImporter[] getImporters() {
        return this.importers;
    }

    public void setImporters(AbstractSolutionImporter[] importers) {
        this.importers = importers;
    }

    public void setExporter(AbstractSolutionExporter exporter) {
        this.exporter = exporter;
    }

    public String getDirName() {
        return this.solutionDao.getDirName();
    }

    public boolean hasImporter() {
        return this.importers.length > 0;
    }

    public boolean hasExporter() {
        return this.exporter != null;
    }

    public void updateDataDirs() {
        File dataDir = this.solutionDao.getDataDir();
        if (this.hasImporter()) {
            this.importDataDir = new File(dataDir, "import");
            if (!this.importDataDir.exists()) {
                throw new IllegalStateException("The directory importDataDir (" + this.importDataDir.getAbsolutePath() + ") does not exist.");
            }
        }
        this.unsolvedDataDir = new File(dataDir, "unsolved");
        if (!this.unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + this.unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        this.solvedDataDir = new File(dataDir, "solved");
        if (!this.solvedDataDir.exists() && !this.solvedDataDir.mkdir()) {
            throw new IllegalStateException("The directory solvedDataDir (" + this.solvedDataDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        if (this.hasExporter()) {
            this.exportDataDir = new File(dataDir, "export");
            if (!this.exportDataDir.exists() && !this.exportDataDir.mkdir()) {
                throw new IllegalStateException("The directory exportDataDir (" + this.exportDataDir.getAbsolutePath() + ") does not exist and could not be created.");
            }
        }
    }

    public File getImportDataDir() {
        return this.importDataDir;
    }

    public File getUnsolvedDataDir() {
        return this.unsolvedDataDir;
    }

    public File getSolvedDataDir() {
        return this.solvedDataDir;
    }

    public File getExportDataDir() {
        return this.exportDataDir;
    }

    public String getExportFileSuffix() {
        return this.exporter.getOutputFileSuffix();
    }

    public void setSolver(Solver<Solution_> solver) {
        this.solver = solver;
        ScoreDirectorFactory scoreDirectorFactory = solver.getScoreDirectorFactory();
        this.guiScoreDirector = scoreDirectorFactory.buildScoreDirector();
    }

    public List<File> getUnsolvedFileList() {
        ArrayList<File> fileList = new ArrayList<File>(FileUtils.listFiles((File)this.unsolvedDataDir, (String[])new String[]{this.solutionDao.getFileExtension()}, (boolean)true));
        Collections.sort(fileList, FILE_COMPARATOR);
        return fileList;
    }

    public List<File> getSolvedFileList() {
        ArrayList<File> fileList = new ArrayList<File>(FileUtils.listFiles((File)this.solvedDataDir, (String[])new String[]{this.solutionDao.getFileExtension()}, (boolean)true));
        Collections.sort(fileList, FILE_COMPARATOR);
        return fileList;
    }

    public Solution_ getSolution() {
        return (Solution_)this.guiScoreDirector.getWorkingSolution();
    }

    public void setSolution(Solution solution) {
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public String getSolutionFileName() {
        return this.solutionFileName;
    }

    public int getUninitializedVariableCount() {
        if (this.solver instanceof DefaultSolver) {
            return ((DefaultSolver)this.solver).getSolverScope().getBestUninitializedVariableCount();
        }
        return 0;
    }

    public Score getScore() {
        return this.guiScoreDirector.calculateScore();
    }

    public boolean isSolving() {
        return this.solver.isSolving();
    }

    public void registerForBestSolutionChanges(final SolverAndPersistenceFrame solverAndPersistenceFrame) {
        this.solver.addEventListener(new SolverEventListener<Solution_>(){

            public void bestSolutionChanged(BestSolutionChangedEvent<Solution_> event) {
                if (SolutionBusiness.this.solver.isEveryProblemFactChangeProcessed()) {
                    final Solution latestBestSolution = event.getNewBestSolution();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SolutionBusiness.this.guiScoreDirector.setWorkingSolution(latestBestSolution);
                            solverAndPersistenceFrame.bestSolutionChanged();
                        }
                    });
                }
            }
        });
    }

    public boolean isConstraintMatchEnabled() {
        return this.guiScoreDirector.isConstraintMatchEnabled();
    }

    public List<ConstraintMatchTotal> getConstraintMatchTotalList() {
        ArrayList<ConstraintMatchTotal> constraintMatchTotalList = new ArrayList<ConstraintMatchTotal>(this.guiScoreDirector.getConstraintMatchTotals());
        Collections.sort(constraintMatchTotalList);
        return constraintMatchTotalList;
    }

    public void importSolution(File file) {
        AbstractSolutionImporter importer = this.determineImporter(file);
        Solution solution = importer.readSolution(file);
        this.solutionFileName = file.getName();
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    private AbstractSolutionImporter determineImporter(File file) {
        for (AbstractSolutionImporter importer : this.importers) {
            if (!importer.acceptInputFile(file)) continue;
            return importer;
        }
        return this.importers[0];
    }

    public void openSolution(File file) {
        Solution solution = this.solutionDao.readSolution(file);
        this.solutionFileName = file.getName();
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public void saveSolution(File file) {
        Solution solution = this.guiScoreDirector.getWorkingSolution();
        this.solutionDao.writeSolution(solution, file);
    }

    public void exportSolution(File file) {
        Solution solution = this.guiScoreDirector.getWorkingSolution();
        this.exporter.writeSolution(solution, file);
    }

    public void doMove(Move move) {
        if (this.solver.isSolving()) {
            this.logger.error("Not doing user move ({}) because the solver is solving.", (Object)move);
            return;
        }
        if (!move.isMoveDoable(this.guiScoreDirector)) {
            this.logger.warn("Not doing user move ({}) because it is not doable.", (Object)move);
            return;
        }
        this.logger.info("Doing user move ({}).", (Object)move);
        move.doMove(this.guiScoreDirector);
        this.guiScoreDirector.calculateScore();
    }

    public void doProblemFactChange(ProblemFactChange problemFactChange) {
        if (this.solver.isSolving()) {
            this.solver.addProblemFactChange(problemFactChange);
        } else {
            problemFactChange.doChange(this.guiScoreDirector);
            this.guiScoreDirector.calculateScore();
        }
    }

    public Solution_ solve(Solution_ planningProblem) {
        return (Solution_)this.solver.solve(planningProblem);
    }

    public void terminateSolvingEarly() {
        this.solver.terminateEarly();
    }

    public ChangeMove createChangeMove(Object entity, String variableName, Object toPlanningValue) {
        InnerScoreDirector guiInnerScoreDirector = (InnerScoreDirector)this.guiScoreDirector;
        SolutionDescriptor solutionDescriptor = guiInnerScoreDirector.getSolutionDescriptor();
        GenuineVariableDescriptor variableDescriptor = solutionDescriptor.findGenuineVariableDescriptorOrFail(entity, variableName);
        if (variableDescriptor.isChained()) {
            SupplyManager supplyManager = guiInnerScoreDirector.getSupplyManager();
            SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)supplyManager.demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
            return new ChainedChangeMove(entity, variableDescriptor, inverseVariableSupply, toPlanningValue);
        }
        return new ChangeMove(entity, variableDescriptor, toPlanningValue);
    }

    public void doChangeMove(Object entity, String variableName, Object toPlanningValue) {
        ChangeMove move = this.createChangeMove(entity, variableName, toPlanningValue);
        this.doMove((Move)move);
    }

    public SwapMove createSwapMove(Object leftEntity, Object rightEntity) {
        InnerScoreDirector guiInnerScoreDirector = (InnerScoreDirector)this.guiScoreDirector;
        SolutionDescriptor solutionDescriptor = guiInnerScoreDirector.getSolutionDescriptor();
        EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptor(leftEntity.getClass());
        List variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList();
        if (entityDescriptor.hasAnyChainedGenuineVariables()) {
            ArrayList<SingletonInverseVariableSupply> inverseVariableSupplyList = new ArrayList<SingletonInverseVariableSupply>(variableDescriptorList.size());
            SupplyManager supplyManager = guiInnerScoreDirector.getSupplyManager();
            for (GenuineVariableDescriptor variableDescriptor : variableDescriptorList) {
                SingletonInverseVariableSupply inverseVariableSupply = variableDescriptor.isChained() ? (SingletonInverseVariableSupply)supplyManager.demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor)) : null;
                inverseVariableSupplyList.add(inverseVariableSupply);
            }
            return new ChainedSwapMove(variableDescriptorList, inverseVariableSupplyList, leftEntity, rightEntity);
        }
        return new SwapMove(variableDescriptorList, leftEntity, rightEntity);
    }

    public void doSwapMove(Object leftEntity, Object rightEntity) {
        SwapMove move = this.createSwapMove(leftEntity, rightEntity);
        this.doMove((Move)move);
    }
}

