/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.solver.drools;

import java.io.Serializable;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.examples.nurserostering.domain.DayOfWeek;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.WeekendDefinition;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;

public class EmployeeConsecutiveAssignmentEnd
implements Comparable<EmployeeConsecutiveAssignmentEnd>,
Serializable {
    private Employee employee;
    private ShiftDate shiftDate;

    public EmployeeConsecutiveAssignmentEnd(Employee employee, ShiftDate shiftDate) {
        this.employee = employee;
        this.shiftDate = shiftDate;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public ShiftDate getShiftDate() {
        return this.shiftDate;
    }

    public void setShiftDate(ShiftDate shiftDate) {
        this.shiftDate = shiftDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EmployeeConsecutiveAssignmentEnd) {
            EmployeeConsecutiveAssignmentEnd other = (EmployeeConsecutiveAssignmentEnd)o;
            return new EqualsBuilder().append((Object)this.employee, (Object)other.employee).append((Object)this.shiftDate, (Object)other.shiftDate).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.employee).append((Object)this.shiftDate).toHashCode();
    }

    @Override
    public int compareTo(EmployeeConsecutiveAssignmentEnd other) {
        return new CompareToBuilder().append((Object)this.employee, (Object)other.employee).append((Object)this.shiftDate, (Object)other.shiftDate).toComparison();
    }

    public String toString() {
        return this.employee + " ... - " + this.shiftDate;
    }

    public Contract getContract() {
        return this.employee.getContract();
    }

    public int getShiftDateDayIndex() {
        return this.shiftDate.getDayIndex();
    }

    public boolean isWeekendAndNotLastDayOfWeekend() {
        DayOfWeek dayOfWeek;
        WeekendDefinition weekendDefinition = this.employee.getContract().getWeekendDefinition();
        return weekendDefinition.isWeekend(dayOfWeek = this.shiftDate.getDayOfWeek()) && weekendDefinition.getLastDayOfWeekend() != dayOfWeek;
    }

    public int getDistanceToLastDayOfWeekend() {
        WeekendDefinition weekendDefinition = this.employee.getContract().getWeekendDefinition();
        DayOfWeek dayOfWeek = this.shiftDate.getDayOfWeek();
        return dayOfWeek.getDistanceToNext(weekendDefinition.getLastDayOfWeekend());
    }
}

