/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain.solver;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;

public class DomicileDistanceStandstillStrengthWeightFactory
implements SelectionSorterWeightFactory<TravelingSalesmanTour, Standstill> {
    public Comparable createSorterWeight(TravelingSalesmanTour tour, Standstill standstill) {
        Domicile domicile = tour.getDomicile();
        long domicileRoundTripDistance = domicile.getDistanceTo(standstill) + standstill.getDistanceTo(domicile);
        return new DomicileDistanceVisitDifficultyWeight(standstill, domicileRoundTripDistance);
    }

    public static class DomicileDistanceVisitDifficultyWeight
    implements Comparable<DomicileDistanceVisitDifficultyWeight> {
        private final Standstill standstill;
        private final long domicileRoundTripDistance;

        public DomicileDistanceVisitDifficultyWeight(Standstill standstill, long domicileRoundTripDistance) {
            this.standstill = standstill;
            this.domicileRoundTripDistance = domicileRoundTripDistance;
        }

        @Override
        public int compareTo(DomicileDistanceVisitDifficultyWeight other) {
            return new CompareToBuilder().append(other.domicileRoundTripDistance, this.domicileRoundTripDistance).append(this.standstill.getLocation().getLatitude(), other.standstill.getLocation().getLatitude()).append(this.standstill.getLocation().getLongitude(), other.standstill.getLocation().getLongitude()).toComparison();
        }
    }
}

