/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.dinnerparty.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.dinnerparty.domain.DinnerParty;
import org.optaplanner.examples.dinnerparty.domain.Gender;
import org.optaplanner.examples.dinnerparty.domain.Guest;
import org.optaplanner.examples.dinnerparty.domain.Hobby;
import org.optaplanner.examples.dinnerparty.domain.HobbyPractician;
import org.optaplanner.examples.dinnerparty.domain.Seat;
import org.optaplanner.examples.dinnerparty.domain.SeatDesignation;
import org.optaplanner.examples.dinnerparty.domain.Table;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class DinnerPartyPanel
extends SolutionPanel<DinnerParty> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/dinnerparty/swingui/dinnerPartyLogo.png";
    public static final int MALE_FEMALE_ICON_VARIATION = 5;
    private GridLayout gridLayout = new GridLayout(0, 1);
    private Map<Hobby, ImageIcon> hobbyImageIconMap;
    private List<ImageIcon> maleImageIconList;
    private List<ImageIcon> femaleImageIconList;

    public DinnerPartyPanel() {
        this.setLayout(this.gridLayout);
        Hobby[] hobbies = Hobby.values();
        this.hobbyImageIconMap = new HashMap<Hobby, ImageIcon>(hobbies.length);
        for (Hobby hobby : hobbies) {
            String imageIconFilename;
            switch (hobby) {
                case TENNIS: {
                    imageIconFilename = "hobbyTennis.png";
                    break;
                }
                case GOLF: {
                    imageIconFilename = "hobbyGolf.png";
                    break;
                }
                case MOTORCYCLES: {
                    imageIconFilename = "hobbyMotorcycles.png";
                    break;
                }
                case CHESS: {
                    imageIconFilename = "hobbyChess.png";
                    break;
                }
                case POKER: {
                    imageIconFilename = "hobbyPoker.png";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The hobby (" + (Object)((Object)hobby) + ") is not supported.");
                }
            }
            this.hobbyImageIconMap.put(hobby, new ImageIcon(this.getClass().getResource(imageIconFilename)));
        }
        this.maleImageIconList = new ArrayList<ImageIcon>(5);
        this.femaleImageIconList = new ArrayList<ImageIcon>(5);
        for (int i = 0; i < 5; ++i) {
            this.maleImageIconList.add(new ImageIcon(this.getClass().getResource("guestMale" + i + ".png")));
            this.femaleImageIconList.add(new ImageIcon(this.getClass().getResource("guestFemale" + i + ".png")));
        }
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    @Override
    public void resetPanel(DinnerParty dinnerParty) {
        this.removeAll();
        TangoColorFactory tangoColorFactory = new TangoColorFactory();
        this.gridLayout.setColumns((int)Math.ceil(Math.sqrt(dinnerParty.getTableList().size())));
        HashMap<Seat, SeatPanel> seatPanelMap = new HashMap<Seat, SeatPanel>(dinnerParty.getSeatList().size());
        SeatPanel unassignedPanel = new SeatPanel(null);
        seatPanelMap.put(null, unassignedPanel);
        for (Table table : dinnerParty.getTableList()) {
            int edgeLength = (int)Math.ceil((double)(table.getSeatList().size() + 4) / 4.0);
            JPanel tablePanel = new JPanel(new GridLayout(0, edgeLength));
            tablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Table " + table.getTableIndex())));
            this.add(tablePanel);
            for (int y = 0; y < edgeLength; ++y) {
                for (int x = 0; x < edgeLength; ++x) {
                    int index = y == 0 ? x : (x == edgeLength - 1 ? edgeLength - 1 + y : (y == edgeLength - 1 ? 2 * (edgeLength - 1) + (edgeLength - 1 - x) : (x == 0 ? 3 * (edgeLength - 1) + (edgeLength - 1 - y) : Integer.MAX_VALUE)));
                    if (index < table.getSeatList().size()) {
                        Seat seat = table.getSeatList().get(index);
                        SeatPanel seatPanel = new SeatPanel(seat);
                        tablePanel.add(seatPanel);
                        seatPanelMap.put(seat, seatPanel);
                        continue;
                    }
                    tablePanel.add(new JPanel());
                }
            }
        }
        for (SeatDesignation seatDesignation : dinnerParty.getSeatDesignationList()) {
            SeatPanel seatPanel = (SeatPanel)seatPanelMap.get(seatDesignation.getSeat());
            seatPanel.setBackground(tangoColorFactory.pickColor((Object)seatDesignation.getGuestJobType()));
            seatPanel.setSeatDesignation(seatDesignation);
        }
    }

    private ImageIcon determineGuestIcon(SeatDesignation seatDesignation) {
        Guest guest = seatDesignation.getGuest();
        if (guest == null) {
            return null;
        }
        List<ImageIcon> imageIconList = guest.getGender() == Gender.MALE ? this.maleImageIconList : this.femaleImageIconList;
        return imageIconList.get(guest.getId().intValue() % imageIconList.size());
    }

    private class SeatDesignationAction
    extends AbstractAction {
        private SeatDesignation seatDesignation;

        public SeatDesignationAction(SeatDesignation seatDesignation) {
            super(null, DinnerPartyPanel.this.determineGuestIcon(seatDesignation));
            this.seatDesignation = seatDesignation;
            Seat seat = seatDesignation.getSeat();
            if (seat != null) {
                this.putValue("ShortDescription", "<html>Guest: " + seatDesignation.getGuest().getName() + "<br/>Table: " + seat.getTable().getTableIndex() + "<br/>Seat: " + seat.getSeatIndexInTable() + "</html>");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<SeatDesignation> seatDesignationList = ((DinnerParty)DinnerPartyPanel.this.getSolution()).getSeatDesignationList();
            JComboBox<Object> seatDesignationListField = new JComboBox<Object>(seatDesignationList.toArray(new Object[seatDesignationList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(seatDesignationListField);
            seatDesignationListField.setSelectedItem(this.seatDesignation);
            int result = JOptionPane.showConfirmDialog(DinnerPartyPanel.this.getRootPane(), seatDesignationListField, "Select seat designation to switch with", 2);
            if (result == 0) {
                SeatDesignation switchSeatDesignation = (SeatDesignation)seatDesignationListField.getSelectedItem();
                if (this.seatDesignation != switchSeatDesignation) {
                    DinnerPartyPanel.this.solutionBusiness.doSwapMove(this.seatDesignation, switchSeatDesignation);
                }
                DinnerPartyPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }

    private class SeatPanel
    extends JPanel {
        public SeatPanel(Seat seat) {
            this.setLayout(new BorderLayout(5, 0));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            SeatDesignation dummySeatDesignation = new SeatDesignation();
            dummySeatDesignation.setGuest(null);
            dummySeatDesignation.setSeat(seat);
            this.setSeatDesignation(dummySeatDesignation);
        }

        public void setSeatDesignation(SeatDesignation seatDesignation) {
            this.removeAll();
            Guest guest = seatDesignation.getGuest();
            if (guest == null) {
                this.add((Component)new JLabel("Empty seat"), "Center");
                return;
            }
            JButton button = SwingUtils.makeSmallButton((JButton)new JButton(new SeatDesignationAction(seatDesignation)));
            this.add((Component)button, "West");
            JPanel infoPanel = new JPanel(new GridLayout(0, 1));
            infoPanel.setOpaque(false);
            infoPanel.add(new JLabel(guest.getName()));
            JPanel jobPanel = new JPanel();
            jobPanel.setLayout(new BoxLayout(jobPanel, 1));
            jobPanel.setOpaque(false);
            jobPanel.add(new JLabel(guest.getJob().getJobType().getCode()));
            JLabel jobLabel = new JLabel("  " + guest.getJob().getName());
            jobLabel.setFont(jobLabel.getFont().deriveFont((float)jobLabel.getFont().getSize() - 2.0f));
            jobPanel.add(jobLabel);
            infoPanel.add(jobPanel);
            this.add((Component)infoPanel, "Center");
            JPanel hobbyPanel = new JPanel(new FlowLayout(1));
            hobbyPanel.setOpaque(false);
            hobbyPanel.setAlignmentX(0.5f);
            for (HobbyPractician hobbyPractician : guest.getHobbyPracticianList()) {
                Hobby hobby = hobbyPractician.getHobby();
                JLabel hobbyLabel = new JLabel((Icon)DinnerPartyPanel.this.hobbyImageIconMap.get((Object)hobby));
                hobbyLabel.setToolTipText(hobby.getLabel());
                hobbyPanel.add(hobbyLabel);
            }
            this.add((Component)hobbyPanel, "South");
        }
    }
}

