/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.investment.domain.AssetClass;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentParametrization;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.optaplanner.examples.investment.domain.Region;
import org.optaplanner.examples.investment.domain.Sector;
import org.optaplanner.examples.investment.domain.util.InvestmentNumericUtil;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class InvestmentPanel
extends SolutionPanel<InvestmentSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/investment/swingui/investmentLogo.png";
    private final TimeTablePanel<AssetClass, AssetClass> assetClassPanel;
    private final TimeTablePanel<Void, Region> regionPanel;
    private final TimeTablePanel<Void, Sector> sectorPanel;
    private JSpinner standardDeviationMaximumField;
    private boolean ignoreChangeEvents = false;

    public InvestmentPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTableHeader(), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        this.assetClassPanel = new TimeTablePanel();
        tabbedPane.add("Asset classes", new JScrollPane(this.assetClassPanel));
        this.regionPanel = new TimeTablePanel();
        tabbedPane.add("Regions", new JScrollPane(this.regionPanel));
        this.sectorPanel = new TimeTablePanel();
        tabbedPane.add("Sectors", new JScrollPane(this.sectorPanel));
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
    }

    private JPanel createTableHeader() {
        JPanel headerPanel = new JPanel(new FlowLayout());
        headerPanel.add(new JLabel("Standard deviation maximum"));
        this.standardDeviationMaximumField = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.001));
        this.standardDeviationMaximumField.setEditor(new JSpinner.NumberEditor(this.standardDeviationMaximumField, "#0.0%"));
        headerPanel.add(this.standardDeviationMaximumField);
        this.standardDeviationMaximumField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (InvestmentPanel.this.ignoreChangeEvents) {
                    return;
                }
                long standardDeviationMillisMaximum = (long)(((Number)InvestmentPanel.this.standardDeviationMaximumField.getValue()).doubleValue() * 1000.0);
                InvestmentPanel.this.changeStandardDeviationMillisMaximum(standardDeviationMillisMaximum);
            }
        });
        return headerPanel;
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    @Override
    public void resetPanel(InvestmentSolution solution) {
        this.ignoreChangeEvents = true;
        this.assetClassPanel.reset();
        this.regionPanel.reset();
        this.sectorPanel.reset();
        InvestmentParametrization parametrization = solution.getParametrization();
        this.standardDeviationMaximumField.setValue((double)parametrization.getStandardDeviationMillisMaximum() / 1000.0);
        this.defineGrid(solution);
        this.fillCells(solution);
        this.ignoreChangeEvents = false;
        this.repaint();
    }

    private void defineGrid(InvestmentSolution solution) {
        JButton footprint = SwingUtils.makeSmallButton((JButton)new JButton("99999999"));
        int footprintWidth = footprint.getPreferredSize().width;
        this.assetClassPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        this.assetClassPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1);
        this.assetClassPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2);
        this.assetClassPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_3);
        this.assetClassPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_4);
        this.assetClassPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_5);
        for (AssetClass assetClass : solution.getAssetClassList()) {
            this.assetClassPanel.defineColumnHeader(assetClass, footprintWidth);
        }
        this.assetClassPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1);
        this.assetClassPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (AssetClass assetClass : solution.getAssetClassList()) {
            this.assetClassPanel.defineRowHeader(assetClass);
        }
        this.assetClassPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.TRAILING_HEADER_ROW);
        this.regionPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        this.regionPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1);
        this.regionPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2);
        this.regionPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Region region : solution.getRegionList()) {
            this.regionPanel.defineRowHeader(region);
        }
        this.sectorPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        this.sectorPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1);
        this.sectorPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2);
        this.sectorPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Sector sector : solution.getSectorList()) {
            this.sectorPanel.defineRowHeader(sector);
        }
    }

    private void fillCells(InvestmentSolution solution) {
        List<AssetClass> assetClassList = solution.getAssetClassList();
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Asset class"), null));
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Region"), null));
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Sector"), null));
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_3, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Expected return"), null));
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_4, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Standard deviation risk"), null));
        JLabel quantityHeaderLabel = new JLabel("Quantity");
        quantityHeaderLabel.setForeground(TangoColorFactory.ORANGE_3);
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_5, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(quantityHeaderLabel, null));
        this.assetClassPanel.addColumnHeader(assetClassList.get(0), TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1, assetClassList.get(assetClassList.size() - 1), TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1, this.createTableHeader(new JLabel("Correlation"), null));
        for (AssetClass assetClass : assetClassList) {
            this.assetClassPanel.addColumnHeader(assetClass, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel(assetClass.getName(), 0), "Expected return: " + assetClass.getExpectedReturnLabel() + " - Standard deviation risk: " + assetClass.getStandardDeviationRiskLabel()));
        }
        for (AssetClass assetClass : assetClassList) {
            this.assetClassPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, assetClass, this.createTableHeader(new JLabel(assetClass.getName(), 2), "Expected return: " + assetClass.getExpectedReturnLabel() + " - Standard deviation risk: " + assetClass.getStandardDeviationRiskLabel()));
        }
        for (AssetClass a : assetClassList) {
            for (AssetClass b : assetClassList) {
                this.assetClassPanel.addCell(a, b, new JLabel(a.getCorrelationLabel(b), 4));
            }
        }
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.TRAILING_HEADER_ROW, this.createTableHeader(new JLabel("Total"), null));
        long quantityTotalMillis = 0L;
        for (AssetClassAllocation allocation : solution.getAssetClassAllocationList()) {
            if (allocation.getQuantityMillis() != null) {
                quantityTotalMillis += allocation.getQuantityMillis().longValue();
            }
            this.assetClassPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1, allocation.getAssetClass(), new JLabel(allocation.getAssetClass().getRegion().getName()));
            this.assetClassPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2, allocation.getAssetClass(), new JLabel(allocation.getAssetClass().getSector().getName()));
            this.assetClassPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_3, allocation.getAssetClass(), new JLabel(allocation.getAssetClass().getExpectedReturnLabel(), 4));
            this.assetClassPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_4, allocation.getAssetClass(), new JLabel(allocation.getAssetClass().getStandardDeviationRiskLabel(), 4));
            JLabel quantityLabel = new JLabel(allocation.getQuantityLabel(), 4);
            quantityLabel.setForeground(TangoColorFactory.ORANGE_3);
            this.assetClassPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_5, allocation.getAssetClass(), quantityLabel);
        }
        JLabel expectedReturnLabel = new JLabel(InvestmentNumericUtil.formatMicrosAsPercentage(solution.calculateExpectedReturnMicros()), 4);
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_3, TimeTablePanel.HeaderRowKey.TRAILING_HEADER_ROW, expectedReturnLabel);
        long standardDeviationMicros = solution.calculateStandardDeviationMicros();
        JLabel standardDeviationLabel = new JLabel(InvestmentNumericUtil.formatMicrosAsPercentage(standardDeviationMicros), 4);
        if (standardDeviationMicros > solution.getParametrization().getStandardDeviationMillisMaximum() * 1000L) {
            standardDeviationLabel.setForeground(TangoColorFactory.SCARLET_3);
        }
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_4, TimeTablePanel.HeaderRowKey.TRAILING_HEADER_ROW, standardDeviationLabel);
        JLabel quantityTotalLabel = new JLabel(InvestmentNumericUtil.formatMillisAsPercentage(quantityTotalMillis), 4);
        quantityTotalLabel.setForeground(TangoColorFactory.ORANGE_3);
        this.assetClassPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_5, TimeTablePanel.HeaderRowKey.TRAILING_HEADER_ROW, quantityTotalLabel);
        this.regionPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Region"), null));
        this.regionPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Quantity total"), null));
        this.regionPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Quantity maximum"), null));
        Map<Region, Long> regionTotalMap = solution.calculateRegionQuantityMillisTotalMap();
        for (final Region region : solution.getRegionList()) {
            this.regionPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, region, new JLabel(region.getName()));
            long total = regionTotalMap.get(region);
            JLabel totalLabel = new JLabel(InvestmentNumericUtil.formatMillisAsPercentage(total), 4);
            if (total > region.getQuantityMillisMaximum()) {
                totalLabel.setForeground(TangoColorFactory.SCARLET_3);
            }
            this.regionPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1, region, totalLabel);
            final JSpinner maximumField = new JSpinner(new SpinnerNumberModel((double)region.getQuantityMillisMaximum().longValue() / 1000.0, 0.0, 1.0, 0.01));
            maximumField.setEditor(new JSpinner.NumberEditor(maximumField, "#0.0%"));
            this.regionPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2, region, maximumField);
            maximumField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (InvestmentPanel.this.ignoreChangeEvents) {
                        return;
                    }
                    long quantityMillisMaximum = (long)(((Number)maximumField.getValue()).doubleValue() * 1000.0);
                    InvestmentPanel.this.changeRegionQuantityMillisMaximum(region, quantityMillisMaximum);
                }
            });
        }
        this.sectorPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Sector"), null));
        this.sectorPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Quantity total"), null));
        this.sectorPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Quantity maximum"), null));
        Map<Sector, Long> sectorTotalMap = solution.calculateSectorQuantityMillisTotalMap();
        for (final Sector sector : solution.getSectorList()) {
            this.sectorPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, sector, new JLabel(sector.getName()));
            long total = sectorTotalMap.get(sector);
            JLabel totalLabel = new JLabel(InvestmentNumericUtil.formatMillisAsPercentage(total), 4);
            if (total > sector.getQuantityMillisMaximum()) {
                totalLabel.setForeground(TangoColorFactory.SCARLET_3);
            }
            this.sectorPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_1, sector, totalLabel);
            final JSpinner maximumField = new JSpinner(new SpinnerNumberModel((double)sector.getQuantityMillisMaximum().longValue() / 1000.0, 0.0, 1.0, 0.01));
            maximumField.setEditor(new JSpinner.NumberEditor(maximumField, "#0.0%"));
            this.sectorPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_EXTRA_PROPERTY_2, sector, maximumField);
            maximumField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (InvestmentPanel.this.ignoreChangeEvents) {
                        return;
                    }
                    long quantityMillisMaximum = (long)(((Number)maximumField.getValue()).doubleValue() * 1000.0);
                    InvestmentPanel.this.changeSectorQuantityMillisMaximum(sector, quantityMillisMaximum);
                }
            });
        }
    }

    private JPanel createTableHeader(JLabel label, String toolTipText) {
        if (toolTipText != null) {
            label.setToolTipText(toolTipText);
        }
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private void changeStandardDeviationMillisMaximum(long standardDeviationMillisMaximum) {
        this.doProblemFactChange(scoreDirector -> {
            InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
            InvestmentParametrization parametrization = solution.getParametrization();
            scoreDirector.beforeProblemPropertyChanged((Object)parametrization);
            parametrization.setStandardDeviationMillisMaximum(standardDeviationMillisMaximum);
            scoreDirector.afterProblemPropertyChanged((Object)parametrization);
        }, true);
    }

    private void changeRegionQuantityMillisMaximum(Region region, long quantityMillisMaximum) {
        this.doProblemFactChange(scoreDirector -> {
            InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
            for (Region workingRegion : solution.getRegionList()) {
                if (!region.getId().equals(workingRegion.getId())) continue;
                scoreDirector.beforeProblemPropertyChanged((Object)workingRegion);
                workingRegion.setQuantityMillisMaximum(quantityMillisMaximum);
                scoreDirector.afterProblemPropertyChanged((Object)workingRegion);
                break;
            }
        }, true);
    }

    private void changeSectorQuantityMillisMaximum(Sector sector, long quantityMillisMaximum) {
        this.doProblemFactChange(scoreDirector -> {
            InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
            for (Sector workingSector : solution.getSectorList()) {
                if (!sector.getId().equals(workingSector.getId())) continue;
                scoreDirector.beforeProblemPropertyChanged((Object)workingSector);
                workingSector.setQuantityMillisMaximum(quantityMillisMaximum);
                scoreDirector.afterProblemPropertyChanged((Object)workingSector);
                break;
            }
        }, true);
    }
}

