/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.swingui.MachineReassignmentPanel;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class MrMachinePanel
extends JPanel {
    private final MachineReassignmentPanel machineReassignmentPanel;
    private List<MrResource> resourceList;
    private MrMachine machine;
    private List<MrProcessAssignment> processAssignmentList = new ArrayList<MrProcessAssignment>();
    private JLabel machineLabel;
    private JPanel resourceListPanel = null;
    private Map<MrResource, JTextField> resourceFieldMap;
    private JLabel numberOfProcessesLabel;
    private JButton detailsButton;

    public MrMachinePanel(MachineReassignmentPanel machineReassignmentPanel, List<MrResource> resourceList, MrMachine machine) {
        super(new BorderLayout());
        this.machineReassignmentPanel = machineReassignmentPanel;
        this.resourceList = resourceList;
        this.machine = machine;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2), BorderFactory.createLineBorder(Color.BLACK)), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.createUI();
    }

    public MrMachine getMachine() {
        return this.machine;
    }

    private String getMachineLabel() {
        return this.machine == null ? "Unassigned" : this.machine.getLabel();
    }

    public void setResourceList(List<MrResource> resourceList) {
        this.resourceList = resourceList;
        this.resetResourceListPanel();
    }

    private void createUI() {
        JPanel labelAndDeletePanel = new JPanel(new BorderLayout());
        labelAndDeletePanel.setPreferredSize(new Dimension(150, 20));
        this.machineLabel = new JLabel(this.getMachineLabel());
        this.machineLabel.setEnabled(false);
        labelAndDeletePanel.add((Component)this.machineLabel, "Center");
        if (this.machine != null) {
            JButton deleteButton = SwingUtils.makeSmallButton((JButton)new JButton("X"));
            deleteButton.setToolTipText("Delete");
            deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MrMachinePanel.this.machineReassignmentPanel.deleteMachine(MrMachinePanel.this.machine);
                }
            });
            deleteButton.setToolTipText("Delete");
            labelAndDeletePanel.add((Component)deleteButton, "East");
        }
        this.add((Component)labelAndDeletePanel, "West");
        this.resetResourceListPanel();
        JPanel numberAndDetailsPanel = new JPanel(new BorderLayout());
        this.numberOfProcessesLabel = new JLabel("0 processes ", 4);
        this.numberOfProcessesLabel.setPreferredSize(new Dimension(100, 20));
        this.numberOfProcessesLabel.setEnabled(false);
        numberAndDetailsPanel.add((Component)this.numberOfProcessesLabel, "West");
        this.detailsButton = new JButton(new AbstractAction("Details"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MrProcessAssignmentListDialog processAssignmentListDialog = new MrProcessAssignmentListDialog();
                processAssignmentListDialog.setLocationRelativeTo(MrMachinePanel.this.getRootPane());
                processAssignmentListDialog.setVisible(true);
            }
        });
        this.detailsButton.setEnabled(false);
        numberAndDetailsPanel.add((Component)this.detailsButton, "Center");
        this.add((Component)numberAndDetailsPanel, "East");
    }

    public void resetResourceListPanel() {
        if (this.resourceListPanel != null) {
            this.remove(this.resourceListPanel);
        }
        this.resourceListPanel = new JPanel(new GridLayout(1, this.resourceList.size()));
        this.resourceFieldMap = new LinkedHashMap<MrResource, JTextField>(this.resourceList.size());
        for (MrResource resource : this.resourceList) {
            long maximumCapacity = this.machine == null ? 0L : this.machine.getMachineCapacity(resource).getMaximumCapacity();
            JTextField resourceField = new JTextField("0 / " + maximumCapacity);
            this.resourceFieldMap.put(resource, resourceField);
            resourceField.setEditable(false);
            resourceField.setEnabled(false);
            this.resourceListPanel.add(resourceField);
        }
        this.add((Component)this.resourceListPanel, "Center");
    }

    public void addProcessAssignment(MrProcessAssignment processAssignment) {
        this.processAssignmentList.add(processAssignment);
    }

    public void removeProcessAssignment(MrProcessAssignment processAssignment) {
        this.processAssignmentList.remove(processAssignment);
    }

    public void clearProcessAssignments() {
        this.processAssignmentList.clear();
    }

    public void update() {
        this.updateTotals();
    }

    private void updateTotals() {
        boolean used = this.processAssignmentList.size() > 0;
        this.machineLabel.setEnabled(used);
        for (MrResource resource : this.resourceList) {
            long safetyCapacity;
            long maximumCapacity;
            JTextField resourceField = this.resourceFieldMap.get(resource);
            if (this.machine != null) {
                MrMachineCapacity machineCapacity = this.machine.getMachineCapacity(resource);
                maximumCapacity = machineCapacity.getMaximumCapacity();
                safetyCapacity = machineCapacity.getSafetyCapacity();
            } else {
                maximumCapacity = 0L;
                safetyCapacity = 0L;
            }
            long usedTotal = 0L;
            for (MrProcessAssignment processAssignment : this.processAssignmentList) {
                usedTotal += processAssignment.getProcess().getProcessRequirement(resource).getUsage();
            }
            resourceField.setText(usedTotal + " / " + maximumCapacity);
            resourceField.setForeground(usedTotal > maximumCapacity ? TangoColorFactory.SCARLET_3 : (usedTotal > safetyCapacity ? TangoColorFactory.ORANGE_3 : Color.BLACK));
            resourceField.setEnabled(used);
        }
        this.numberOfProcessesLabel.setText(this.processAssignmentList.size() + " processes ");
        this.numberOfProcessesLabel.setEnabled(used);
    }

    private class MrProcessAssignmentListDialog
    extends JDialog {
        public MrProcessAssignmentListDialog() {
            this.setModal(true);
            this.setTitle(MrMachinePanel.this.getMachineLabel());
            JPanel contentPanel = new JPanel();
            GroupLayout layout = new GroupLayout(contentPanel);
            contentPanel.setLayout(layout);
            JPanel assignmentsPanel = this.createAssignmentsPanel();
            JScrollPane contentScrollPane = new JScrollPane(assignmentsPanel);
            contentScrollPane.setPreferredSize(new Dimension(800, 200));
            contentScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setContentPane(contentScrollPane);
            this.pack();
        }

        private JPanel createAssignmentsPanel() {
            JPanel assignmentsPanel = new JPanel(new GridLayout(0, MrMachinePanel.this.resourceList.size()));
            int colorIndex = 0;
            for (MrProcessAssignment processAssignment : MrMachinePanel.this.processAssignmentList) {
                JLabel processAssignmentLabel = new JLabel(processAssignment.getLabel());
                processAssignmentLabel.setForeground(TangoColorFactory.SEQUENCE_1[colorIndex]);
                assignmentsPanel.add(processAssignmentLabel);
                for (MrResource resource : MrMachinePanel.this.resourceList) {
                    long usage = processAssignment.getProcess().getProcessRequirement(resource).getUsage();
                    JTextField resourceField = new JTextField(Long.toString(usage));
                    resourceField.setEditable(false);
                    assignmentsPanel.add(resourceField);
                }
                colorIndex = (colorIndex + 1) % TangoColorFactory.SEQUENCE_1.length;
            }
            return assignmentsPanel;
        }
    }
}

