/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.realtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class DeleteComputerProblemFactChange
implements ProblemFactChange<CloudBalance> {
    private final CloudComputer computer;

    public DeleteComputerProblemFactChange(CloudComputer computer) {
        this.computer = computer;
    }

    public void doChange(ScoreDirector<CloudBalance> scoreDirector) {
        CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
        for (CloudProcess process : cloudBalance.getProcessList()) {
            if (!Objects.equals(process.getComputer(), this.computer)) continue;
            scoreDirector.beforeVariableChanged((Object)process, "computer");
            process.setComputer(null);
            scoreDirector.afterVariableChanged((Object)process, "computer");
        }
        scoreDirector.triggerVariableListeners();
        cloudBalance.setComputerList(new ArrayList<CloudComputer>(cloudBalance.getComputerList()));
        Iterator<CloudComputer> it = cloudBalance.getComputerList().iterator();
        while (it.hasNext()) {
            CloudComputer workingComputer = it.next();
            if (!Objects.equals(workingComputer, this.computer)) continue;
            scoreDirector.beforeProblemFactRemoved((Object)workingComputer);
            it.remove();
            scoreDirector.afterProblemFactRemoved((Object)workingComputer);
            break;
        }
    }
}

