/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.common.app.AbstractTurtleTest;

@RunWith(value=Parameterized.class)
public abstract class SolveAllTurtleTest<Solution_>
extends AbstractTurtleTest {
    protected abstract String createSolverConfigResource();

    protected abstract Solution_ readPlanningProblem();

    @Test
    public void runFastAndFullAssert() {
        SolveAllTurtleTest.checkRunTurtleTests();
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory();
        Solution_ planningProblem = this.readPlanningProblem();
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, planningProblem, 2L);
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.FAST_ASSERT, planningProblem, 5L);
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, planningProblem, 3L);
    }

    protected Solution_ buildAndSolve(SolverFactory<Solution_> solverFactory, EnvironmentMode environmentMode, Solution_ planningProblem, long maximumMinutesSpent) {
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        solverConfig.getTerminationConfig().setMinutesSpentLimit(Long.valueOf(maximumMinutesSpent));
        solverConfig.setEnvironmentMode(environmentMode);
        Class<EasyScoreCalculator> easyScoreCalculatorClass = this.overwritingEasyScoreCalculatorClass();
        if (easyScoreCalculatorClass != null && environmentMode.isAsserted()) {
            ScoreDirectorFactoryConfig assertionScoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            assertionScoreDirectorFactoryConfig.setEasyScoreCalculatorClass(easyScoreCalculatorClass);
            solverConfig.getScoreDirectorFactoryConfig().setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryConfig);
        }
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(planningProblem);
        return (Solution_)bestSolution;
    }

    protected Class<? extends EasyScoreCalculator> overwritingEasyScoreCalculatorClass() {
        return null;
    }

    protected SolverFactory<Solution_> buildSolverFactory() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.createSolverConfigResource());
        TerminationConfig terminationConfig = new TerminationConfig();
        solverFactory.getSolverConfig().setTerminationConfig(terminationConfig);
        return solverFactory;
    }
}

