/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.examples.common.app.LoggingTest;

public abstract class PlannerBenchmarkTest
extends LoggingTest {
    private static final int MAXIMUM_SOLVER_BENCHMARK_SIZE = 6;
    private static final long WARM_UP_SECONDS_SPENT = 5L;
    private static final long MAXIMUM_SECONDS_SPENT = 30L;

    protected abstract String createBenchmarkConfigResource();

    protected void runBenchmarkTest(File unsolvedDataFile) {
        PlannerBenchmarkFactory plannerBenchmarkFactory = this.buildPlannerBenchmarkFactory(unsolvedDataFile);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        plannerBenchmark.benchmark();
    }

    protected PlannerBenchmarkFactory buildPlannerBenchmarkFactory(File unsolvedDataFile) {
        String prefix;
        String benchmarkConfigResource = this.createBenchmarkConfigResource();
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)benchmarkConfigResource);
        PlannerBenchmarkConfig plannerBenchmarkConfig = benchmarkFactory.getPlannerBenchmarkConfig();
        String benchmarkDirectoryPath = plannerBenchmarkConfig.getBenchmarkDirectory().getPath();
        if (!benchmarkDirectoryPath.startsWith(prefix = "local" + File.separator + "data" + File.separator)) {
            throw new IllegalStateException("The benchmarkDirectoryPath (" + benchmarkDirectoryPath + ") should start with prefix (" + prefix + ")");
        }
        plannerBenchmarkConfig.setBenchmarkDirectory(new File(benchmarkDirectoryPath.replace(prefix, "target" + File.separator + "test" + File.separator + "data" + File.separator)));
        plannerBenchmarkConfig.setWarmUpHoursSpentLimit(Long.valueOf(0L));
        plannerBenchmarkConfig.setWarmUpMinutesSpentLimit(Long.valueOf(0L));
        plannerBenchmarkConfig.setWarmUpSecondsSpentLimit(Long.valueOf(5L));
        plannerBenchmarkConfig.setWarmUpMillisecondsSpentLimit(Long.valueOf(0L));
        List solverBenchmarkConfigList = plannerBenchmarkConfig.getSolverBenchmarkConfigList();
        if (ConfigUtils.isEmptyCollection((Collection)solverBenchmarkConfigList)) {
            throw new IllegalStateException("The benchmarkConfigResource (" + benchmarkConfigResource + ") should have at least 1 solverBenchmarkConfig.");
        }
        if (solverBenchmarkConfigList.size() > 6) {
            solverBenchmarkConfigList = solverBenchmarkConfigList.subList(0, 6);
            plannerBenchmarkConfig.setSolverBenchmarkConfigList(solverBenchmarkConfigList);
        }
        long maximumSecondsSpentPerSolverBenchmark = 30L / (long)solverBenchmarkConfigList.size();
        SolverBenchmarkConfig inheritedSolverBenchmarkConfig = plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig();
        if (inheritedSolverBenchmarkConfig != null) {
            ProblemBenchmarksConfig problemBenchmarksConfig = inheritedSolverBenchmarkConfig.getProblemBenchmarksConfig();
            if (problemBenchmarksConfig == null) {
                problemBenchmarksConfig = new ProblemBenchmarksConfig();
                inheritedSolverBenchmarkConfig.setProblemBenchmarksConfig(problemBenchmarksConfig);
            }
            problemBenchmarksConfig.setInputSolutionFileList(Collections.singletonList(unsolvedDataFile));
            TerminationConfig terminationConfig = new TerminationConfig();
            terminationConfig.setSecondsSpentLimit(Long.valueOf(maximumSecondsSpentPerSolverBenchmark));
            inheritedSolverBenchmarkConfig.getSolverConfig().setTerminationConfig(terminationConfig);
        }
        for (SolverBenchmarkConfig solverBenchmarkConfig : solverBenchmarkConfigList) {
            ProblemBenchmarksConfig problemBenchmarksConfig = solverBenchmarkConfig.getProblemBenchmarksConfig();
            if (problemBenchmarksConfig != null) {
                problemBenchmarksConfig.setInputSolutionFileList(null);
            }
            solverBenchmarkConfig.getSolverConfig().setTerminationConfig(new TerminationConfig());
        }
        return benchmarkFactory;
    }
}

