/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.util.ArrayList;
import java.util.List;

public class StringDataGenerator {
    private static final int[][] HALF_SEQUENCE_MAP = new int[][]{new int[0], {0}, {0, 1}, {0, 2, 1}, {0, 2, 1, 3}};
    private static final int[] DEFAULT_ELIMINATION_INDEX_MAP = new int[]{0, 1, 1, 1};
    private final String delimiter;
    private List<String[]> partValuesList = new ArrayList<String[]>();
    private int partValuesLength;
    private List<Integer> eliminationIndexMap = new ArrayList<Integer>();
    private int requiredSize = 0;
    private List<String[]> filteredPartValuesList = this.partValuesList;
    private int index = 0;
    private int indexLimit;

    public static StringDataGenerator buildFullNames() {
        return new StringDataGenerator().addPart(true, 0, "Amy", "Beth", "Chad", "Dan", "Elsa", "Flo", "Gus", "Hugo", "Ivy", "Jay").addPart(false, 1, "A.", "B.", "C.", "D.", "E.", "F.", "G.", "H.", "I.", "J.").addPart(false, 1, "O.", "P.", "Q.", "R.", "S.", "T.", "U.", "V.", "W.", "X.").addPart(false, 1, "Cole", "Fox", "Green", "Jones", "King", "Li", "Poe", "Rye", "Smith", "Watt");
    }

    public static StringDataGenerator buildCompanyNames() {
        return new StringDataGenerator().addPart(true, 0, "Steel", "Paper", "Stone", "Wood", "Water", "Food", "Oil", "Car", "Power", "Computer").addPart(true, 1, "Inc", "Corp", "Limited", "Express", "Telco", "Mobile", "Soft", "Mart", "Bank", "Labs").addPart(false, 2, "US", "UK", "JP", "DE", "FR", "BE", "NL", "BR", "IN", "ES");
    }

    public static StringDataGenerator buildLocationNames() {
        return new StringDataGenerator().addPart(true, 0, "Los", "San", "Las", "Santa", "New", "Fort", "Mount", "Saint", "Little", "El").addPart(true, 1, "Angeles", "Francisco", "Vegas", "Barbara", "York", "Collins", "Vernon", "Peter", "Rock", "Paso").addPart(false, 2, "Town", "City", "Falls", "Ville", "Field", "Polis", "Shire", "Berg", "Borough", "Island").addPart(false, 3, "AL", "CA", "DE", "FL", "GA", "HI", "IN", "KS", "LA", "ME");
    }

    public StringDataGenerator() {
        this(" ");
    }

    public StringDataGenerator(String delimiter) {
        this.delimiter = delimiter;
    }

    public StringDataGenerator addPart(String ... partValues) {
        return this.addPart(false, DEFAULT_ELIMINATION_INDEX_MAP[this.partValuesList.size()], partValues);
    }

    public StringDataGenerator addAToZPart() {
        return this.addAToZPart(false, DEFAULT_ELIMINATION_INDEX_MAP[this.partValuesList.size()]);
    }

    public StringDataGenerator addAToZPart(boolean required, int eliminationIndex) {
        return this.addPart(required, eliminationIndex, "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
    }

    public StringDataGenerator addNumericPart(boolean required, int eliminationIndex, int from, int to) {
        String[] partValues = new String[to - from];
        for (int i = from; i < to; ++i) {
            partValues[i - from] = Integer.toString(i);
        }
        return this.addPart(required, eliminationIndex, partValues);
    }

    public StringDataGenerator addPart(boolean required, int eliminationIndex, String ... partValues) {
        if (this.partValuesList.isEmpty()) {
            this.partValuesLength = partValues.length;
        } else if (partValues.length != this.partValuesLength) {
            throw new IllegalStateException("The partValues length (" + partValues.length + ") is not the same as the partValuesLength (" + this.partValuesLength + ") of the others.");
        }
        if (required) {
            ++this.requiredSize;
        }
        this.partValuesList.add(partValues);
        this.eliminationIndexMap.add(eliminationIndex);
        this.indexLimit = (int)Math.pow(this.partValuesLength, this.partValuesList.size());
        this.filteredPartValuesList = this.partValuesList;
        return this;
    }

    public void reset() {
        this.filteredPartValuesList = this.partValuesList;
        this.index = 0;
    }

    public void predictMaximumSizeAndReset(int maximumSize) {
        this.indexLimit = (int)Math.pow(this.partValuesLength, this.partValuesList.size());
        for (int i = 1; i < this.partValuesList.size(); ++i) {
            int proposedIndexLimit = (int)Math.pow(this.partValuesLength, i);
            if (maximumSize > proposedIndexLimit) continue;
            this.filteredPartValuesList = new ArrayList<String[]>(this.partValuesList);
            while (i < this.filteredPartValuesList.size() && this.filteredPartValuesList.size() > this.requiredSize) {
                int eliminationIndex = this.eliminationIndexMap.get(this.filteredPartValuesList.size() - 1);
                this.filteredPartValuesList.remove(eliminationIndex);
            }
            this.indexLimit = proposedIndexLimit;
            break;
        }
        this.index = 0;
    }

    public String generateNextValue() {
        int i;
        if (this.index >= this.indexLimit) {
            throw new IllegalStateException("No more elements: the index (" + this.index + ") is higher than the indexLimit (" + this.indexLimit + ").\nMaybe predictMaximumSizeAndReset() was called with a too low maximumSize.");
        }
        int listSize = this.filteredPartValuesList.size();
        StringBuilder result = new StringBuilder(listSize * 80);
        if (listSize >= HALF_SEQUENCE_MAP.length) {
            throw new IllegalStateException("A listSize (" + listSize + ") is not yet supported.");
        }
        int[] halfSequence = HALF_SEQUENCE_MAP[listSize];
        int[] chosens = new int[listSize];
        int previousChosen = 0;
        for (i = 0; i < listSize; ++i) {
            int chosen;
            chosens[i] = chosen = (previousChosen + this.index % (int)Math.pow(this.partValuesLength, halfSequence[i] + 1) / (int)Math.pow(this.partValuesLength, halfSequence[i])) % this.partValuesLength;
            previousChosen = chosen;
        }
        for (i = 0; i < listSize; ++i) {
            if (i > 0) {
                result.append(this.delimiter);
            }
            String[] partValues = this.filteredPartValuesList.get(i);
            result.append(partValues[chosens[i]]);
        }
        ++this.index;
        return result.toString();
    }
}

