/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.persistence;

import java.io.File;
import java.math.BigInteger;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.TreeSet;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.generator.LocationDataGenerator;
import org.optaplanner.examples.common.persistence.generator.ProbabilisticDataGenerator;
import org.optaplanner.examples.rocktour.domain.RockBus;
import org.optaplanner.examples.rocktour.domain.RockLocation;
import org.optaplanner.examples.rocktour.domain.RockShow;
import org.optaplanner.examples.rocktour.domain.RockTourParametrization;
import org.optaplanner.examples.rocktour.domain.RockTourSolution;
import org.optaplanner.examples.rocktour.persistence.RockTourXlsxFileIO;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class RockTourGenerator
extends LoggingMain {
    protected final SolutionFileIO<RockTourSolution> solutionFileIO = new RockTourXlsxFileIO();
    protected final File outputDir = new File(CommonApp.determineDataDir("rocktour"), "unsolved");
    protected Random random;
    protected static final LocalDate START_DATE = LocalDate.of(2018, 2, 1);
    protected static final LocalDate END_DATE = LocalDate.of(2018, 12, 1);

    public static void main(String[] args) {
        RockTourGenerator generator = new RockTourGenerator();
        generator.writeSolution(LocationDataGenerator.US_MAINLAND_STATE_CAPITALS);
    }

    private void writeSolution(LocationDataGenerator.LocationData[] locationDataArray) {
        String fileName = locationDataArray.length - 1 + "shows";
        File outputFile = new File(this.outputDir, fileName + "." + this.solutionFileIO.getOutputFileExtension());
        RockTourSolution solution = this.createRockTourSolution(fileName, locationDataArray);
        this.solutionFileIO.write((Object)solution, outputFile);
    }

    public RockTourSolution createRockTourSolution(String fileName, LocationDataGenerator.LocationData[] locationDataArray) {
        this.random = new Random(37L);
        RockTourSolution solution = new RockTourSolution();
        solution.setId(0L);
        solution.setTourName(fileName);
        RockTourParametrization parametrization = new RockTourParametrization();
        parametrization.setId(0L);
        solution.setParametrization(parametrization);
        this.createShowList(solution, locationDataArray);
        BigInteger possibleSolutionSize = AbstractSolutionImporter.factorial(solution.getShowList().size());
        this.logger.info("Rock tour {} has {} shows with a search space of {}.", new Object[]{fileName, solution.getShowList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return solution;
    }

    private void createShowList(RockTourSolution solution, LocationDataGenerator.LocationData[] locationDataArray) {
        int i;
        ArrayList<LocalDate> globalAvailableDayList = new ArrayList<LocalDate>();
        LocalDate date = START_DATE;
        while (date.compareTo(END_DATE) < 0) {
            if (date.getDayOfWeek() != DayOfWeek.SUNDAY) {
                globalAvailableDayList.add(date);
            }
            date = date.plusDays(1L);
        }
        ArrayList<RockShow> showList = new ArrayList<RockShow>(locationDataArray.length);
        long showId = 0L;
        ArrayList<RockLocation> locationList = new ArrayList<RockLocation>(locationDataArray.length);
        for (i = 0; i < locationDataArray.length; ++i) {
            TreeSet<LocalDate> availableDaySet;
            LocationDataGenerator.LocationData locationData = locationDataArray[i];
            RockLocation location = new RockLocation(locationData.getName(), locationData.getLatitude(), locationData.getLongitude());
            locationList.add(location);
            if (i == 0) {
                RockBus bus = new RockBus();
                bus.setId(Long.valueOf(i));
                bus.setStartLocation(location);
                bus.setStartDate(START_DATE);
                bus.setEndLocation(location);
                bus.setEndDate(END_DATE);
                solution.setBus(bus);
                continue;
            }
            RockShow show = new RockShow();
            show.setId(showId++);
            show.setVenueName(locationData.getName());
            show.setLocation(location);
            show.setDurationInHalfDay(ProbabilisticDataGenerator.generateRandomIntFromThresholds(this.random, 0.0, 0.5, 0.9, 0.9));
            show.setRevenueOpportunity((this.random.nextInt(30) + 1) * 100000);
            show.setRequired(i <= 3);
            if (i <= 8) {
                availableDaySet = new TreeSet<LocalDate>();
                availableDaySet.add((LocalDate)ProbabilisticDataGenerator.extractRandomElement(this.random, globalAvailableDayList));
            } else {
                int fromIndex = globalAvailableDayList.size() * 4 / 5;
                Collections.shuffle(globalAvailableDayList, this.random);
                availableDaySet = new TreeSet(globalAvailableDayList.subList(0, fromIndex + this.random.nextInt(globalAvailableDayList.size() - fromIndex)));
            }
            show.setAvailableDateSet(availableDaySet);
            showList.add(show);
        }
        for (i = 0; i < locationList.size(); ++i) {
            RockLocation fromLocation = (RockLocation)locationList.get(i);
            LinkedHashMap<RockLocation, Long> drivingSecondsMap = new LinkedHashMap<RockLocation, Long>(locationList.size());
            for (int j = 0; j < locationList.size(); ++j) {
                RockLocation toLocation = (RockLocation)locationList.get(j);
                long divingSeconds = fromLocation == toLocation ? 0L : (long)this.random.nextInt(1000);
                drivingSecondsMap.put(toLocation, divingSeconds);
            }
            fromLocation.setDrivingSecondsMap(drivingSecondsMap);
        }
        solution.setShowList(showList);
    }
}

