/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.solver;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Test;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceParametrization;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.test.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreVerifier;

public class ConferenceSchedulingScoreSoftConstraintTest {
    private HardMediumSoftScoreVerifier<ConferenceSolution> scoreVerifier = new HardMediumSoftScoreVerifier(SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/conferencescheduling/solver/conferenceSchedulingSolverConfig.xml"));

    @Test
    public void themeConflict() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        TalkType talkType = new TalkType(0L, "type1");
        String theme1 = "theme1";
        String theme2 = "theme2";
        String theme3 = "theme3";
        String theme4 = "theme4";
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        Talk talk2 = this.createTalk(2L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime start2 = LocalDateTime.of(2018, 1, 1, 9, 30);
        LocalDateTime end2 = LocalDateTime.of(2018, 1, 1, 10, 30);
        LocalDateTime start3 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime end3 = LocalDateTime.of(2018, 1, 1, 11, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        Timeslot slot2 = new Timeslot(2L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start2).withEndDateTime(end2);
        Timeslot slot3 = new Timeslot(3L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start3).withEndDateTime(end3);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2, slot3)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        parametrization.setThemeTrackConflict(1);
        this.scoreVerifier.assertSoftWeight("Theme track conflict", 0, (Object)solution);
        talk1.withTimeslot(slot1).withThemeTrackTagSet(new HashSet<String>(Arrays.asList(theme1, theme2)));
        talk2.withTimeslot(slot2).withThemeTrackTagSet(new HashSet<String>(Arrays.asList(theme3, theme4)));
        this.scoreVerifier.assertSoftWeight("Theme track conflict", 0, (Object)solution);
        talk2.withThemeTrackTagSet(new HashSet<String>(Arrays.asList(theme1, theme3, theme4)));
        this.scoreVerifier.assertSoftWeight("Theme track conflict", -1, (Object)solution);
        talk1.withTimeslot(slot1).withThemeTrackTagSet(new HashSet<String>(Arrays.asList(theme1, theme2, theme3)));
        this.scoreVerifier.assertSoftWeight("Theme track conflict", -2, (Object)solution);
        parametrization.setThemeTrackConflict(2);
        this.scoreVerifier.assertSoftWeight("Theme track conflict", -4, (Object)solution);
        talk2.setTimeslot(slot3);
        this.scoreVerifier.assertSoftWeight("Theme track conflict", 0, (Object)solution);
    }

    @Test
    public void sectorConflict() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        TalkType talkType = new TalkType(0L, "type1");
        String sector1 = "sector1";
        String sector2 = "sector2";
        String sector3 = "sector3";
        String sector4 = "sector4";
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        Talk talk2 = this.createTalk(2L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime start2 = LocalDateTime.of(2018, 1, 1, 9, 30);
        LocalDateTime end2 = LocalDateTime.of(2018, 1, 1, 10, 30);
        LocalDateTime start3 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime end3 = LocalDateTime.of(2018, 1, 1, 11, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        Timeslot slot2 = new Timeslot(2L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start2).withEndDateTime(end2);
        Timeslot slot3 = new Timeslot(3L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start3).withEndDateTime(end3);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Arrays.asList(slot1, slot2, slot3)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        parametrization.setSectorConflict(1);
        this.scoreVerifier.assertSoftWeight("Sector conflict", 0, (Object)solution);
        parametrization.setSectorConflict(1);
        talk1.withTimeslot(slot1).withSectorTagSet(new HashSet<String>(Arrays.asList(sector1, sector2)));
        talk2.withTimeslot(slot2).withSectorTagSet(new HashSet<String>(Arrays.asList(sector3, sector4)));
        this.scoreVerifier.assertSoftWeight("Sector conflict", 0, (Object)solution);
        talk2.withSectorTagSet(new HashSet<String>(Arrays.asList(sector1, sector3, sector4)));
        this.scoreVerifier.assertSoftWeight("Sector conflict", -1, (Object)solution);
        talk1.withTimeslot(slot1).withSectorTagSet(new HashSet<String>(Arrays.asList(sector1, sector2, sector3)));
        this.scoreVerifier.assertSoftWeight("Sector conflict", -2, (Object)solution);
        parametrization.setSectorConflict(2);
        this.scoreVerifier.assertSoftWeight("Sector conflict", -4, (Object)solution);
        talk2.setTimeslot(slot3);
        this.scoreVerifier.assertSoftWeight("Sector conflict", 0, (Object)solution);
    }

    @Test
    public void languageDiversity() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        TalkType talkType = new TalkType(0L, "type1");
        String language1 = "language1";
        String language2 = "language2";
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        LocalDateTime start2 = LocalDateTime.of(2018, 1, 1, 9, 30);
        LocalDateTime end2 = LocalDateTime.of(2018, 1, 1, 10, 30);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        Timeslot slot2 = new Timeslot(2L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start2).withEndDateTime(end2);
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        Talk talk2 = this.createTalk(2L).withTalkType(talkType);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1, talk2)).withTimeslotList(Collections.emptyList()).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        this.scoreVerifier.assertSoftWeight("Language diversity", 0, (Object)solution);
        parametrization.setLanguageDiversity(1);
        talk1.withTimeslot(slot1).withLanguage(language1);
        talk2.withTimeslot(slot1).withLanguage(language1);
        this.scoreVerifier.assertSoftWeight("Language diversity", 0, (Object)solution);
        talk2.withLanguage(language2);
        this.scoreVerifier.assertSoftWeight("Language diversity", 1, (Object)solution);
        parametrization.setLanguageDiversity(2);
        this.scoreVerifier.assertSoftWeight("Language diversity", 2, (Object)solution);
        talk2.withTimeslot(slot2);
        this.scoreVerifier.assertSoftWeight("Language diversity", 0, (Object)solution);
        talk2.withLanguage(language1);
        this.scoreVerifier.assertSoftWeight("Language diversity", 0, (Object)solution);
    }

    @Test
    public void speakerPreferredTimeslot() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        TalkType talkType = new TalkType(0L, "type1");
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1, speaker2));
        parametrization.setSpeakerPreferredTimeslotTags(1);
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2, tag3)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -1, (Object)solution);
        parametrization.setSpeakerPreferredTimeslotTags(2);
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -2, (Object)solution);
        parametrization.setSpeakerPreferredTimeslotTags(1);
        speaker1.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", 0, (Object)solution);
        speaker1.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2));
        slot1.setTagSet(Collections.emptySet());
        speaker1.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        speaker2.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -4, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -2, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        speaker2.setPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag3)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -4, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", -3, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2, tag3)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred timeslot tags", 0, (Object)solution);
    }

    @Test
    public void talkPreferredTimeslotTag() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        parametrization.setTalkPreferredTimeslotTags(1);
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1);
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", 0, (Object)solution);
        talk1.withPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", -1, (Object)solution);
        parametrization.setTalkPreferredTimeslotTags(2);
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", -2, (Object)solution);
        parametrization.setTalkPreferredTimeslotTags(1);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withPreferredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Talk preferred timeslot tags", 0, (Object)solution);
    }

    @Test
    public void speakerUndesiredTimeslot() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        TalkType talkType = new TalkType(0L, "type1");
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Arrays.asList(speaker1, speaker2));
        parametrization.setSpeakerUndesiredTimeslotTags(1);
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1)).withTimeslot(slot1);
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        speaker1.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2, tag3)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", 0, (Object)solution);
        speaker1.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -1, (Object)solution);
        parametrization.setSpeakerUndesiredTimeslotTags(2);
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -2, (Object)solution);
        parametrization.setSpeakerUndesiredTimeslotTags(1);
        speaker1.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -2, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2));
        slot1.setTagSet(Collections.emptySet());
        speaker1.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -2, (Object)solution);
        speaker1.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        speaker2.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -2, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -4, (Object)solution);
        speaker1.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        speaker2.setUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag3)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -3, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2, tag3)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired timeslot tags", -4, (Object)solution);
    }

    @Test
    public void talkUndesiredTimeslotTag() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        LocalDateTime start1 = LocalDateTime.of(2018, 1, 1, 9, 0);
        LocalDateTime end1 = LocalDateTime.of(2018, 1, 1, 10, 0);
        Timeslot slot1 = new Timeslot(1L).withTalkTypeSet(Collections.singleton(talkType)).withStartDateTime(start1).withEndDateTime(end1);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Arrays.asList(slot1)).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        parametrization.setTalkUndesiredTimeslotTags(1);
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1);
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk required timeslot tag", 0, (Object)solution);
        slot1.setTagSet(Collections.emptySet());
        talk1.withTimeslot(slot1).withUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", 0, (Object)solution);
        talk1.withTimeslot(slot1).withUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1)));
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", -1, (Object)solution);
        parametrization.setTalkUndesiredTimeslotTags(2);
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", -2, (Object)solution);
        parametrization.setTalkUndesiredTimeslotTags(1);
        talk1.withTimeslot(slot1).withUndesiredTimeslotTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        slot1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", 0, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", -1, (Object)solution);
        slot1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Talk undesired timeslot tags", -2, (Object)solution);
    }

    @Test
    public void speakerPreferredRoomTag() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Room room1 = new Room(1L).withTalkTypeSet(Collections.singleton(talkType));
        Talk talk1 = this.createTalk(1L);
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Arrays.asList(room1)).withSpeakerList(Arrays.asList(speaker1, speaker2));
        parametrization.setSpeakerPreferredRoomTags(1);
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", 0, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1)).withRoom(room1);
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", 0, (Object)solution);
        speaker1.withPreferredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -1, (Object)solution);
        parametrization.setSpeakerPreferredRoomTags(2);
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -2, (Object)solution);
        parametrization.setSpeakerPreferredRoomTags(1);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", 0, (Object)solution);
        speaker1.withPreferredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", 0, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2));
        speaker1.withPreferredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.withPreferredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", 0, (Object)solution);
        speaker2.withPreferredRoomTagSet(new HashSet<String>(Arrays.asList(tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", 0, (Object)solution);
        speaker2.withPreferredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -3, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker preferred room tags", 0, (Object)solution);
    }

    @Test
    public void talkPreferredRoomTag() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Room room1 = new Room(1L).withTalkTypeSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        parametrization.setTalkPreferredRoomTags(1);
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", 0, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withRoom(room1);
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", 0, (Object)solution);
        talk1.withPreferredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", -1, (Object)solution);
        parametrization.setTalkPreferredRoomTags(2);
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", -2, (Object)solution);
        parametrization.setTalkPreferredRoomTags(1);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", 0, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withPreferredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Talk preferred room tags", 0, (Object)solution);
    }

    @Test
    public void speakerUndesiredRoomTag() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String tag1 = "tag1";
        String tag2 = "tag2";
        String tag3 = "tag3";
        TalkType talkType = new TalkType(0L, "type1");
        Room room1 = new Room(1L).withTalkTypeSet(Collections.singleton(talkType));
        Talk talk1 = this.createTalk(1L);
        Speaker speaker1 = new Speaker(1L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        Speaker speaker2 = new Speaker(2L).withUnavailableTimeslotSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet());
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Arrays.asList(room1)).withSpeakerList(Arrays.asList(speaker1, speaker2));
        parametrization.setSpeakerUndesiredRoomTags(1);
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", 0, (Object)solution);
        room1.setTagSet(Collections.emptySet());
        talk1.withSpeakerList(Arrays.asList(speaker1)).withRoom(room1);
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", 0, (Object)solution);
        speaker1.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag3)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", 0, (Object)solution);
        speaker1.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -1, (Object)solution);
        parametrization.setSpeakerUndesiredRoomTags(2);
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -2, (Object)solution);
        parametrization.setSpeakerUndesiredRoomTags(1);
        speaker1.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -2, (Object)solution);
        talk1.withSpeakerList(Arrays.asList(speaker1, speaker2)).withRoom(room1);
        speaker1.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        speaker2.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -2, (Object)solution);
        speaker2.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -2, (Object)solution);
        speaker2.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -2, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Speaker undesired room tags", -3, (Object)solution);
    }

    @Test
    public void talkUndesiredRoomTag() {
        ConferenceParametrization parametrization = new ConferenceParametrization(1L);
        String tag1 = "tag1";
        String tag2 = "tag2";
        TalkType talkType = new TalkType(0L, "type1");
        Room room1 = new Room(1L).withTalkTypeSet(Collections.emptySet());
        Talk talk1 = this.createTalk(1L).withTalkType(talkType);
        ConferenceSolution solution = new ConferenceSolution(1L).withParametrization(parametrization).withTalkTypeList(Collections.singletonList(talkType)).withTalkList(Arrays.asList(talk1)).withTimeslotList(Collections.emptyList()).withRoomList(Collections.emptyList()).withSpeakerList(Collections.emptyList());
        parametrization.setTalkUndesiredRoomTags(1);
        room1.setTagSet(Collections.emptySet());
        talk1.withRoom(room1);
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", 0, (Object)solution);
        talk1.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(Collections.emptySet());
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag2)));
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", 0, (Object)solution);
        talk1.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1)));
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", -1, (Object)solution);
        parametrization.setTalkUndesiredRoomTags(2);
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", -2, (Object)solution);
        parametrization.setTalkUndesiredRoomTags(1);
        room1.setTagSet(Collections.emptySet());
        talk1.withUndesiredRoomTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", 0, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1)));
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", -1, (Object)solution);
        room1.setTagSet(new HashSet<String>(Arrays.asList(tag1, tag2)));
        this.scoreVerifier.assertSoftWeight("Talk undesired room tags", -2, (Object)solution);
    }

    private Talk createTalk(long id) {
        return new Talk(id).withSpeakerList(Collections.emptyList()).withAudienceTypeSet(Collections.emptySet()).withPreferredTimeslotTagSet(Collections.emptySet()).withRequiredTimeslotTagSet(Collections.emptySet()).withProhibitedTimeslotTagSet(Collections.emptySet()).withUndesiredTimeslotTagSet(Collections.emptySet()).withPreferredRoomTagSet(Collections.emptySet()).withRequiredRoomTagSet(Collections.emptySet()).withProhibitedRoomTagSet(Collections.emptySet()).withUndesiredRoomTagSet(Collections.emptySet()).withThemeTrackTagSet(Collections.emptySet()).withSectorTagSet(Collections.emptySet()).withContentTagSet(Collections.emptySet()).withMutuallyExclusiveTalksTagSet(Collections.emptySet()).withPrerequisiteTalksCodesSet(Collections.emptySet());
    }
}

