/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.swing.impl.TangoColorFactory;

public abstract class AbstractXlsxSolutionFileIO<Solution_>
implements SolutionFileIO<Solution_> {
    protected static final Pattern VALID_TAG_PATTERN;
    protected static final Pattern VALID_NAME_PATTERN;
    protected static final Pattern VALID_CODE_PATTERN;
    public static final DateTimeFormatter DAY_FORMATTER;
    public static final DateTimeFormatter MONTH_FORMATTER;
    public static final DateTimeFormatter TIME_FORMATTER;
    public static final DateTimeFormatter DATE_TIME_FORMATTER;
    protected static final XSSFColor VIEW_TAB_COLOR;
    protected static final XSSFColor UNAVAILABLE_COLOR;
    protected static final XSSFColor PINNED_COLOR;
    protected static final XSSFColor HARD_PENALTY_COLOR;
    protected static final XSSFColor MEDIUM_PENALTY_COLOR;
    protected static final XSSFColor SOFT_PENALTY_COLOR;
    protected static final XSSFColor REPUBLISHED_COLOR;

    public String getInputFileExtension() {
        return "xlsx";
    }

    static {
        VALID_NAME_PATTERN = VALID_TAG_PATTERN = Pattern.compile("(?U)^[\\w&\\-\\.\\/\\(\\)\\'][\\w&\\-\\.\\/\\(\\)\\' ]*[\\w&\\-\\.\\/\\(\\)\\']?$");
        VALID_CODE_PATTERN = Pattern.compile("(?U)^[\\w\\-\\.\\/\\(\\)]+$");
        DAY_FORMATTER = DateTimeFormatter.ofPattern("E yyyy-MM-dd", Locale.ENGLISH);
        MONTH_FORMATTER = DateTimeFormatter.ofPattern("MMM yyyy", Locale.ENGLISH);
        TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm", Locale.ENGLISH);
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm", Locale.ENGLISH);
        VIEW_TAB_COLOR = new XSSFColor(TangoColorFactory.BUTTER_1);
        UNAVAILABLE_COLOR = new XSSFColor(TangoColorFactory.ALUMINIUM_5);
        PINNED_COLOR = new XSSFColor(TangoColorFactory.PLUM_1);
        HARD_PENALTY_COLOR = new XSSFColor(TangoColorFactory.SCARLET_1);
        MEDIUM_PENALTY_COLOR = new XSSFColor(TangoColorFactory.SCARLET_3);
        SOFT_PENALTY_COLOR = new XSSFColor(TangoColorFactory.ORANGE_1);
        REPUBLISHED_COLOR = new XSSFColor(TangoColorFactory.MAGENTA);
    }

    public static abstract class AbstractXlsxWriter<Solution_> {
        protected final Solution_ solution;
        protected final List<ConstraintMatchTotal> constraintMatchTotalList;
        protected final Map<Object, Indictment> indictmentMap;
        protected XSSFWorkbook workbook;
        protected CreationHelper creationHelper;
        protected XSSFCellStyle headerStyle;
        protected XSSFCellStyle defaultStyle;
        protected XSSFCellStyle unavailableStyle;
        protected XSSFCellStyle pinnedStyle;
        protected XSSFCellStyle hardPenaltyStyle;
        protected XSSFCellStyle mediumPenaltyStyle;
        protected XSSFCellStyle softPenaltyStyle;
        protected XSSFCellStyle wrappedStyle;
        protected XSSFCellStyle republishedStyle;
        protected XSSFSheet currentSheet;
        protected Drawing currentDrawing;
        protected XSSFRow currentRow;
        protected int currentRowNumber;
        protected int currentColumnNumber;
        protected int headerCellCount;

        public AbstractXlsxWriter(Solution_ solution, String solverConfigResource) {
            this.solution = solution;
            ScoreDirectorFactory scoreDirectorFactory = SolverFactory.createFromXmlResource((String)solverConfigResource).buildSolver().getScoreDirectorFactory();
            try (ScoreDirector scoreDirector = scoreDirectorFactory.buildScoreDirector();){
                scoreDirector.setWorkingSolution(solution);
                scoreDirector.calculateScore();
                this.constraintMatchTotalList = new ArrayList<ConstraintMatchTotal>(scoreDirector.getConstraintMatchTotals());
                this.constraintMatchTotalList.sort(Comparator.comparing(ConstraintMatchTotal::getScore));
                this.indictmentMap = scoreDirector.getIndictmentMap();
            }
        }

        public abstract Workbook write();

        public void writeSetup() {
            this.workbook = new XSSFWorkbook();
            this.creationHelper = this.workbook.getCreationHelper();
            this.createStyles();
        }

        protected void createStyles() {
            this.headerStyle = this.createStyle(null);
            XSSFFont font = this.workbook.createFont();
            font.setBold(true);
            this.headerStyle.setFont((Font)font);
            this.defaultStyle = this.createStyle(null);
            this.unavailableStyle = this.createStyle(UNAVAILABLE_COLOR);
            this.pinnedStyle = this.createStyle(PINNED_COLOR);
            this.hardPenaltyStyle = this.createStyle(HARD_PENALTY_COLOR);
            this.mediumPenaltyStyle = this.createStyle(MEDIUM_PENALTY_COLOR);
            this.softPenaltyStyle = this.createStyle(SOFT_PENALTY_COLOR);
            this.wrappedStyle = this.createStyle(null);
            this.republishedStyle = this.createStyle(REPUBLISHED_COLOR);
        }

        protected XSSFCellStyle createStyle(XSSFColor color) {
            XSSFCellStyle style = this.workbook.createCellStyle();
            if (color != null) {
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(color);
            }
            style.setWrapText(true);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            return style;
        }

        protected void writeIntConstraintLine(String name, Supplier<Integer> supplier, String constraintDescription) {
            this.nextRow();
            this.nextHeaderCell(name);
            XSSFCell weightCell = this.nextCell();
            if (supplier != null) {
                weightCell.setCellValue((double)supplier.get().intValue());
            } else {
                weightCell.setCellValue("n/a");
            }
            this.nextHeaderCell(constraintDescription);
        }

        protected void writeLongConstraintLine(String name, Supplier<Long> supplier, String constraintDescription) {
            this.nextRow();
            this.nextHeaderCell(name);
            XSSFCell weightCell = this.nextCell();
            if (supplier != null) {
                weightCell.setCellValue((double)supplier.get().longValue());
            } else {
                weightCell.setCellValue("n/a");
            }
            this.nextHeaderCell(constraintDescription);
        }

        protected void nextSheet(String sheetName, int colSplit, int rowSplit, boolean view) {
            this.currentSheet = this.workbook.createSheet(sheetName);
            this.currentDrawing = this.currentSheet.createDrawingPatriarch();
            this.currentSheet.createFreezePane(colSplit, rowSplit);
            this.currentRowNumber = -1;
            this.headerCellCount = 0;
            if (view) {
                this.currentSheet.setTabColor(VIEW_TAB_COLOR);
            }
        }

        protected void nextRow() {
            ++this.currentRowNumber;
            this.currentRow = this.currentSheet.createRow(this.currentRowNumber);
            this.currentColumnNumber = -1;
        }

        protected void nextHeaderCell(String value) {
            this.nextCell(this.headerStyle).setCellValue(value);
            ++this.headerCellCount;
        }

        protected void nextHeaderCell(double value) {
            this.nextCell(this.headerStyle).setCellValue(value);
            ++this.headerCellCount;
        }

        protected XSSFCell nextCell() {
            return this.nextCell(this.defaultStyle);
        }

        protected XSSFCell nextCell(XSSFCellStyle cellStyle) {
            ++this.currentColumnNumber;
            XSSFCell cell = this.currentRow.createCell(this.currentColumnNumber);
            cell.setCellStyle((CellStyle)cellStyle);
            return cell;
        }

        protected void nextHeaderCellVertically(String value) {
            this.nextCellVertically(this.headerStyle).setCellValue(value);
            ++this.headerCellCount;
        }

        protected XSSFCell nextCellVertically() {
            return this.nextCellVertically(this.defaultStyle);
        }

        protected XSSFCell nextCellVertically(XSSFCellStyle cellStyle) {
            ++this.currentRowNumber;
            this.currentRow = this.currentSheet.getRow(this.currentRowNumber);
            XSSFCell cell = this.currentRow.createCell(this.currentColumnNumber);
            cell.setCellStyle((CellStyle)cellStyle);
            return cell;
        }

        protected void autoSizeColumnsWithHeader() {
            for (int i = 0; i < this.headerCellCount; ++i) {
                this.currentSheet.autoSizeColumn(i);
            }
        }

        protected void setSizeColumnsWithHeader(int width) {
            for (int i = 0; i < this.headerCellCount; ++i) {
                this.currentSheet.setColumnWidth(i, width);
            }
        }
    }

    public static abstract class AbstractXlsxReader<Solution_> {
        protected final XSSFWorkbook workbook;
        protected Solution_ solution;
        protected XSSFSheet currentSheet;
        protected Iterator<Row> currentRowIterator;
        protected XSSFRow currentRow;
        protected int currentRowNumber;
        protected int currentColumnNumber;

        public AbstractXlsxReader(XSSFWorkbook workbook) {
            this.workbook = workbook;
        }

        public abstract Solution_ read();

        protected void readIntConstraintLine(String name, Consumer<Integer> consumer, String constraintdescription) {
            this.nextRow();
            this.readHeaderCell(name);
            XSSFCell weightCell = this.nextCell();
            if (consumer != null) {
                if (weightCell.getCellTypeEnum() != CellType.NUMERIC) {
                    throw new IllegalArgumentException(this.currentPosition() + ": The value (" + weightCell.getStringCellValue() + ") for constraint (" + name + ") must be a number and the cell type must be numeric.");
                }
                double value = weightCell.getNumericCellValue();
                if ((double)((int)value) != value) {
                    throw new IllegalArgumentException(this.currentPosition() + ": The value (" + value + ") for constraint (" + name + ") must be an integer.");
                }
                consumer.accept((int)value);
            } else if (weightCell.getCellTypeEnum() == CellType.NUMERIC || !weightCell.getStringCellValue().equals("n/a")) {
                throw new IllegalArgumentException(this.currentPosition() + ": The value (" + weightCell.getStringCellValue() + ") for constraint (" + name + ") must be an n/a.");
            }
            this.readHeaderCell(constraintdescription);
        }

        protected void readLongConstraintLine(String name, Consumer<Long> consumer, String constraintdescription) {
            this.nextRow();
            this.readHeaderCell(name);
            XSSFCell weightCell = this.nextCell();
            if (consumer != null) {
                if (weightCell.getCellTypeEnum() != CellType.NUMERIC) {
                    throw new IllegalArgumentException(this.currentPosition() + ": The value (" + weightCell.getStringCellValue() + ") for constraint (" + name + ") must be a number and the cell type must be numeric.");
                }
                double value = weightCell.getNumericCellValue();
                if ((double)((long)value) != value) {
                    throw new IllegalArgumentException(this.currentPosition() + ": The value (" + value + ") for constraint (" + name + ") must be a (long) integer.");
                }
                consumer.accept((long)value);
            } else if (weightCell.getCellTypeEnum() == CellType.NUMERIC || !weightCell.getStringCellValue().equals("n/a")) {
                throw new IllegalArgumentException(this.currentPosition() + ": The value (" + weightCell.getStringCellValue() + ") for constraint (" + name + ") must be an n/a.");
            }
            this.readHeaderCell(constraintdescription);
        }

        protected String currentPosition() {
            return "Sheet (" + this.currentSheet.getSheetName() + ") cell (" + (this.currentRowNumber + 1) + CellReference.convertNumToColString((int)this.currentColumnNumber) + ")";
        }

        protected boolean hasSheet(String sheetName) {
            return this.workbook.getSheet(sheetName) != null;
        }

        protected void nextSheet(String sheetName) {
            this.currentSheet = this.workbook.getSheet(sheetName);
            if (this.currentSheet == null) {
                throw new IllegalStateException("The workbook does not contain a sheet with name (" + sheetName + ").");
            }
            this.currentRowIterator = this.currentSheet.rowIterator();
            if (this.currentRowIterator == null) {
                throw new IllegalStateException(this.currentPosition() + ": The sheet has no rows.");
            }
            this.currentRowNumber = -1;
        }

        protected boolean nextRow() {
            return this.nextRow(true);
        }

        protected boolean nextRow(boolean skipEmptyRows) {
            ++this.currentRowNumber;
            this.currentColumnNumber = -1;
            if (!this.currentRowIterator.hasNext()) {
                this.currentRow = null;
                return false;
            }
            this.currentRow = (XSSFRow)this.currentRowIterator.next();
            while (skipEmptyRows && this.currentRowIsEmpty()) {
                if (!this.currentRowIterator.hasNext()) {
                    this.currentRow = null;
                    return false;
                }
                this.currentRow = (XSSFRow)this.currentRowIterator.next();
            }
            if (this.currentRow.getRowNum() != this.currentRowNumber) {
                if (this.currentRow.getRowNum() == this.currentRowNumber + 1) {
                    ++this.currentRowNumber;
                } else {
                    throw new IllegalStateException(this.currentPosition() + ": The next row (" + this.currentRow.getRowNum() + ") has a gap of more than 1 empty line with the previous.");
                }
            }
            return true;
        }

        protected boolean currentRowIsEmpty() {
            if (this.currentRow.getPhysicalNumberOfCells() == 0) {
                return true;
            }
            for (Cell cell : this.currentRow) {
                if (!(cell.getCellTypeEnum() == CellType.STRING ? !cell.getStringCellValue().isEmpty() : cell.getCellTypeEnum() != CellType.BLANK)) continue;
                return false;
            }
            return true;
        }

        protected void readHeaderCell(String value) {
            XSSFCell cell;
            XSSFCell xSSFCell = cell = this.currentRow == null ? null : this.nextStringCell();
            if (cell == null || !cell.getStringCellValue().equals(value)) {
                throw new IllegalStateException(this.currentPosition() + ": The cell does not contain the expected value (" + value + ").");
            }
        }

        protected void readHeaderCell(double value) {
            XSSFCell cell;
            XSSFCell xSSFCell = cell = this.currentRow == null ? null : this.nextNumericCell();
            if (cell == null || cell.getNumericCellValue() != value) {
                throw new IllegalStateException(this.currentPosition() + ": The cell does not contain the expected value (" + value + ").");
            }
        }

        protected XSSFCell nextStringCell() {
            XSSFCell cell = this.nextCell();
            if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                throw new IllegalStateException(this.currentPosition() + ": The cell with value (" + cell.getNumericCellValue() + ") has a numeric type but should be a string.");
            }
            return cell;
        }

        protected XSSFCell nextNumericCell() {
            XSSFCell cell = this.nextCell();
            if (cell.getCellTypeEnum() == CellType.STRING) {
                throw new IllegalStateException(this.currentPosition() + ": The cell with value (" + cell.getStringCellValue() + ") has a string type but should be numeric.");
            }
            return cell;
        }

        protected XSSFCell nextNumericCellOrBlank() {
            XSSFCell cell = this.nextCell();
            if (cell.getCellTypeEnum() == CellType.BLANK || cell.getCellTypeEnum() == CellType.STRING && cell.getStringCellValue().isEmpty()) {
                return null;
            }
            if (cell.getCellTypeEnum() == CellType.STRING) {
                throw new IllegalStateException(this.currentPosition() + ": The cell with value (" + cell.getStringCellValue() + ") has a string type but should be numeric.");
            }
            return cell;
        }

        protected XSSFCell nextBooleanCell() {
            XSSFCell cell = this.nextCell();
            if (cell.getCellTypeEnum() == CellType.STRING) {
                throw new IllegalStateException(this.currentPosition() + ": The cell with value (" + cell.getStringCellValue() + ") has a string type but should be boolean.");
            }
            if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                throw new IllegalStateException(this.currentPosition() + ": The cell with value (" + cell.getNumericCellValue() + ") has a numeric type but should be a boolean.");
            }
            return cell;
        }

        protected XSSFCell nextCell() {
            ++this.currentColumnNumber;
            XSSFCell cell = this.currentRow.getCell(this.currentColumnNumber);
            if (cell == null) {
                return this.currentRow.createCell(this.currentColumnNumber);
            }
            return cell;
        }

        protected XSSFColor extractColor(XSSFCell cell, XSSFColor ... acceptableColors) {
            XSSFCellStyle cellStyle = cell.getCellStyle();
            FillPatternType fillPattern = cellStyle.getFillPatternEnum();
            if (fillPattern == null || fillPattern == FillPatternType.NO_FILL) {
                return null;
            }
            if (fillPattern != FillPatternType.SOLID_FOREGROUND) {
                throw new IllegalStateException(this.currentPosition() + ": The fill pattern (" + fillPattern + ") should be either " + FillPatternType.NO_FILL + " or " + FillPatternType.SOLID_FOREGROUND + ".");
            }
            XSSFColor color = cellStyle.getFillForegroundColorColor();
            for (XSSFColor acceptableColor : acceptableColors) {
                if (!acceptableColor.equals((Object)color)) continue;
                return acceptableColor;
            }
            throw new IllegalStateException(this.currentPosition() + ": The fill color (" + color + ") is not one of the acceptableColors (" + Arrays.toString(acceptableColors) + ").");
        }
    }
}

