/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.solver;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.examples.common.persistence.AbstractXlsxSolutionFileIO;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingXlsxFileIO;
import org.optaplanner.test.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreVerifier;

@RunWith(value=Parameterized.class)
public class ConferenceSchedulingScoreRulesXlsxTest {
    private static final String testFileName = "testConferenceSchedulingScoreRules.xlsx";
    private static final HardMediumSoftScore unassignedScore = HardMediumSoftScore.ZERO;
    private String constraintPackage;
    private String constraintName;
    private HardMediumSoftScore expectedScore;
    private ConferenceSolution solution;
    private String testSheetName;
    private static HardMediumSoftScoreVerifier<ConferenceSolution> scoreVerifier = new HardMediumSoftScoreVerifier(SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/conferencescheduling/solver/conferenceSchedulingSolverConfig.xml"));

    public ConferenceSchedulingScoreRulesXlsxTest(String constraintPackage, String constraintName, HardMediumSoftScore expectedScore, ConferenceSolution solution, String testSheetName) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.expectedScore = expectedScore;
        this.solution = solution;
        this.testSheetName = testSheetName;
    }

    @Parameterized.Parameters(name="{4}")
    public static Collection testSheetParameters() {
        ArrayList<Object[]> parametersList = new ArrayList<Object[]>();
        File testFile = new File(ConferenceSchedulingScoreRulesXlsxTest.class.getResource(testFileName).getFile());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(testFile));){
            Object[] currentParameterList;
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            ConferenceSolution initialSolution = new ConferenceSchedulingXlsxFileIO(false).read(testFile);
            TestConferenceSchedulingScoreRulesReader testFileReader = new TestConferenceSchedulingScoreRulesReader(workbook, initialSolution);
            while ((currentParameterList = testFileReader.nextTestSheetParameterList()) != null) {
                parametersList.add(currentParameterList);
            }
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed reading inputSolutionFile (" + testFile.getName() + ").", e);
        }
        return parametersList;
    }

    @Test
    public void scoreRules() {
        scoreVerifier.assertHardWeight(this.constraintPackage, this.constraintName, this.expectedScore.getHardScore(), (Object)this.solution);
        scoreVerifier.assertMediumWeight(this.constraintPackage, this.constraintName, this.expectedScore.getMediumScore(), (Object)this.solution);
        scoreVerifier.assertSoftWeight(this.constraintPackage, this.constraintName, this.expectedScore.getSoftScore(), (Object)this.solution);
    }

    private static class TestConferenceSchedulingScoreRulesReader
    extends AbstractXlsxSolutionFileIO.AbstractXlsxReader<ConferenceSolution> {
        private final SolutionCloner<ConferenceSolution> solutionCloner = SolutionDescriptor.buildSolutionDescriptor(ConferenceSolution.class, (Class[])new Class[]{Talk.class}).getSolutionCloner();
        private final ConferenceSolution initialSolution;
        private int numberOfSheets;
        private int currentTestSheetIndex;
        private Map<String, Room> roomMap;
        private Map<Pair<LocalDateTime, LocalDateTime>, Timeslot> timeslotMap;
        private Map<Integer, LocalDate> columnIndexToDateMap;
        private Map<Integer, LocalTime> columnIndexToStartTimeMap;
        private Map<Integer, LocalTime> columnIndexToEndTimeMap;

        private TestConferenceSchedulingScoreRulesReader(XSSFWorkbook workbook, ConferenceSolution initialSolution) {
            super(workbook, "org/optaplanner/examples/conferencescheduling/solver/conferenceSchedulingSolverConfig.xml");
            this.numberOfSheets = workbook.getNumberOfSheets();
            this.currentTestSheetIndex = workbook.getSheetIndex("Talks") + 1;
            this.initialSolution = initialSolution;
            this.roomMap = initialSolution.getRoomList().stream().collect(Collectors.toMap(Room::getName, Function.identity()));
            this.timeslotMap = initialSolution.getTimeslotList().stream().collect(Collectors.toMap(timeslot -> Pair.of((Object)timeslot.getStartDateTime(), (Object)timeslot.getEndDateTime()), Function.identity()));
            this.columnIndexToDateMap = new HashMap<Integer, LocalDate>(this.timeslotMap.size());
            this.columnIndexToStartTimeMap = new HashMap<Integer, LocalTime>(this.timeslotMap.size());
            this.columnIndexToEndTimeMap = new HashMap<Integer, LocalTime>(this.timeslotMap.size());
        }

        public ConferenceSolution read() {
            return this.initialSolution;
        }

        private Object[] nextTestSheetParameterList() {
            if (this.currentTestSheetIndex >= this.numberOfSheets) {
                return null;
            }
            this.nextSheet(this.workbook.getSheetName(this.currentTestSheetIndex++));
            String testSheetName = this.currentSheet.getSheetName();
            this.nextRow(false);
            this.readHeaderCell("Constraint package");
            String constraintPackage = this.nextStringCell().getStringCellValue();
            this.nextRow(false);
            this.readHeaderCell("Constraint name");
            String constraintName = this.nextStringCell().getStringCellValue();
            this.nextRow(false);
            this.nextRow(false);
            this.readHeaderCell("Score");
            HardMediumSoftScore expectedScore = HardMediumSoftScore.parseScore((String)this.nextStringCell().getStringCellValue());
            ConferenceSolution nextSheetSolution = (ConferenceSolution)this.solutionCloner.cloneSolution((Object)this.initialSolution);
            Map talkMap = nextSheetSolution.getTalkList().stream().collect(Collectors.toMap(Talk::getCode, Function.identity()));
            scoreVerifier.assertHardWeight(constraintPackage, constraintName, unassignedScore.getHardScore(), (Object)nextSheetSolution);
            scoreVerifier.assertSoftWeight(constraintPackage, constraintName, unassignedScore.getSoftScore(), (Object)nextSheetSolution);
            this.nextRow();
            this.readTimeslotDays();
            this.nextRow(false);
            this.readHeaderCell("Room");
            this.readTimeslotHours();
            while (this.nextRow()) {
                String roomName = this.nextStringCell().getStringCellValue();
                Room room = this.roomMap.get(roomName);
                if (room == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The room (" + roomName + ") does not exist in the room list.");
                }
                for (int i = 0; i < this.columnIndexToStartTimeMap.size(); ++i) {
                    LocalDateTime endDateTime;
                    String talkCode = this.nextCell().getStringCellValue();
                    if (talkCode.isEmpty()) continue;
                    Talk talk = (Talk)talkMap.get(talkCode);
                    if (talk == null) {
                        throw new IllegalStateException(this.currentPosition() + ": Talk (" + talkCode + ") does not exist in the talk list.");
                    }
                    LocalDateTime startDateTime = LocalDateTime.of(this.columnIndexToDateMap.get(this.currentColumnNumber), this.columnIndexToStartTimeMap.get(this.currentColumnNumber));
                    Timeslot timeslot = this.timeslotMap.get(Pair.of((Object)startDateTime, (Object)(endDateTime = LocalDateTime.of(this.columnIndexToDateMap.get(this.currentColumnNumber), this.columnIndexToEndTimeMap.get(this.currentColumnNumber)))));
                    if (timeslot == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The timeslot with date (" + startDateTime.toLocalDate() + "), startTime (" + startDateTime.toLocalTime() + ") and endTime (" + endDateTime.toLocalTime() + ") doesn't exist in the other sheet (Timeslots).");
                    }
                    talk.setRoom(room);
                    talk.setTimeslot(timeslot);
                }
            }
            return new Object[]{constraintPackage, constraintName, expectedScore, nextSheetSolution, testSheetName};
        }

        private void readTimeslotDays() {
            this.columnIndexToDateMap.clear();
            String previousDateString = null;
            for (int i = 0; i < this.currentRow.getLastCellNum(); ++i) {
                XSSFCell cell = this.currentRow.getCell(i);
                if (cell.getStringCellValue().isEmpty() && previousDateString == null) continue;
                if (!cell.getStringCellValue().isEmpty()) {
                    previousDateString = cell.getStringCellValue();
                }
                try {
                    this.columnIndexToDateMap.put(i, LocalDate.parse(previousDateString, AbstractXlsxSolutionFileIO.DAY_FORMATTER));
                    continue;
                }
                catch (DateTimeParseException e) {
                    throw new IllegalStateException(this.currentPosition() + ": The date (" + cell.getStringCellValue() + ") does not parse as a date.");
                }
            }
        }

        private void readTimeslotHours() {
            this.columnIndexToStartTimeMap.clear();
            this.columnIndexToEndTimeMap.clear();
            StreamSupport.stream(this.currentRow.spliterator(), false).forEach(cell -> {
                if (!cell.getStringCellValue().isEmpty() && !cell.getStringCellValue().equals("Room")) {
                    String[] startAndEndTimeStringArray = cell.getStringCellValue().split("-");
                    try {
                        this.columnIndexToStartTimeMap.put(cell.getColumnIndex(), LocalTime.parse(startAndEndTimeStringArray[0], AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                        this.columnIndexToEndTimeMap.put(cell.getColumnIndex(), LocalTime.parse(startAndEndTimeStringArray[1], AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                    }
                    catch (DateTimeParseException e) {
                        throw new IllegalStateException(this.currentPosition() + ": The startTime (" + startAndEndTimeStringArray[0] + ") or endTime (" + startAndEndTimeStringArray[1] + ") doesn't parse as a time.", e);
                    }
                }
            });
        }
    }
}

