/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.app;

import java.io.File;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.AbstractTurtleTest;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.vehiclerouting.app.VehicleRoutingApp;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingImporter;

public class VehicleRoutingMultiThreadedReproducibilityTest
extends AbstractTurtleTest {
    private static final int REPETITION_COUNT = 10;
    private static final int STEP_LIMIT = 5000;
    private static final String MOVE_THREAD_COUNT = "4";
    private static final String DATA_SET = "import/belgium/basic/air/belgium-n50-k10.vrp";
    private final VehicleRoutingApp vehicleRoutingApp = new VehicleRoutingApp();
    private VehicleRoutingSolution[] vehicleRoutingSolutions = new VehicleRoutingSolution[10];
    private SolverFactory<VehicleRoutingSolution> solverFactory;

    @Before
    public void createUninitializedSolutions() {
        VehicleRoutingMultiThreadedReproducibilityTest.checkRunTurtleTests();
        VehicleRoutingImporter importer = new VehicleRoutingImporter();
        for (int i = 0; i < 10; ++i) {
            VehicleRoutingSolution solution;
            File dataSetFile = new File(CommonApp.determineDataDir((String)this.vehicleRoutingApp.getDataDirName()), DATA_SET);
            this.vehicleRoutingSolutions[i] = solution = (VehicleRoutingSolution)importer.readSolution(dataSetFile);
        }
        this.solverFactory = SolverFactory.createFromXmlResource((String)this.vehicleRoutingApp.getSolverConfig());
        SolverConfig solverConfig = this.solverFactory.getSolverConfig();
        solverConfig.getPhaseConfigList().forEach(phaseConfig -> {
            if (LocalSearchPhaseConfig.class.isAssignableFrom(phaseConfig.getClass())) {
                phaseConfig.setTerminationConfig(new TerminationConfig().withStepCountLimit(Integer.valueOf(5000)));
            }
        });
        solverConfig.setMoveThreadCount(MOVE_THREAD_COUNT);
        solverConfig.setEnvironmentMode(EnvironmentMode.REPRODUCIBLE);
    }

    @Test
    public void multiThreadedSolvingIsReproducible() {
        VehicleRoutingMultiThreadedReproducibilityTest.checkRunTurtleTests();
        IntStream.range(0, 10).forEach(iteration -> this.solveAndCompareWithPrevious(iteration));
    }

    private void solveAndCompareWithPrevious(int iteration) {
        VehicleRoutingSolution bestSolution;
        Solver solver = this.solverFactory.buildSolver();
        this.vehicleRoutingSolutions[iteration] = bestSolution = (VehicleRoutingSolution)solver.solve((Object)this.vehicleRoutingSolutions[iteration]);
        if (iteration > 0) {
            VehicleRoutingSolution previousBestSolution = this.vehicleRoutingSolutions[iteration - 1];
            Assert.assertEquals((Object)bestSolution.getScore(), (Object)previousBestSolution.getScore());
        }
    }
}

