/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.SolveAllTurtleTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

public abstract class ImportDirSolveAllTurtleTest<Solution_>
extends SolveAllTurtleTest<Solution_> {
    protected final CommonApp<Solution_> commonApp;
    protected final File dataFile;
    protected AbstractSolutionImporter<Solution_> solutionImporter;

    protected static <Solution_> Collection<Object[]> getImportDirFilesAsParameters(CommonApp<Solution_> commonApp) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File importDataDir = new File(dataDir, "import");
        if (!importDataDir.exists()) {
            throw new IllegalStateException("The directory importDataDir (" + importDataDir.getAbsolutePath() + ") does not exist.");
        }
        String inputFileSuffix = ImportDirSolveAllTurtleTest.createSolutionImporter(commonApp).getInputFileSuffix();
        ArrayList fileList = new ArrayList(FileUtils.listFiles((File)importDataDir, (String[])new String[]{inputFileSuffix}, (boolean)true));
        fileList.sort(new ProblemFileComparator());
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    protected static <Solution_> AbstractSolutionImporter<Solution_> createSolutionImporter(CommonApp<Solution_> commonApp) {
        AbstractSolutionImporter[] importers = commonApp.createSolutionImporters();
        if (importers.length != 1) {
            throw new IllegalStateException("The importers size (" + importers.length + ") should be 1.");
        }
        return importers[0];
    }

    protected ImportDirSolveAllTurtleTest(CommonApp<Solution_> commonApp, File dataFile) {
        super(commonApp.getSolverConfig());
        this.commonApp = commonApp;
        this.dataFile = dataFile;
    }

    @Before
    public void setUp() {
        this.solutionImporter = ImportDirSolveAllTurtleTest.createSolutionImporter(this.commonApp);
    }

    @Override
    protected Solution_ readProblem() {
        return (Solution_)this.solutionImporter.readSolution(this.dataFile);
    }
}

