/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.common.app.AbstractTurtleTest;

@RunWith(value=Parameterized.class)
public abstract class SolveAllTurtleTest<Solution_>
extends AbstractTurtleTest {
    private static final String MOVE_THREAD_COUNT_OVERRIDE = System.getProperty("moveThreadCount");
    private final String solverConfig;

    public SolveAllTurtleTest(String solverConfig) {
        this.solverConfig = solverConfig;
    }

    protected abstract Solution_ readProblem();

    @Test
    public void runFastAndFullAssert() {
        SolveAllTurtleTest.checkRunTurtleTests();
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory();
        Solution_ problem = this.readProblem();
        problem = this.buildAndSolve(solverFactory, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, problem, 2L);
        problem = this.buildAndSolve(solverFactory, EnvironmentMode.FAST_ASSERT, problem, 5L);
        problem = this.buildAndSolve(solverFactory, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, problem, 3L);
    }

    protected Solution_ buildAndSolve(SolverFactory<Solution_> solverFactory, EnvironmentMode environmentMode, Solution_ problem, long maximumMinutesSpent) {
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        solverConfig.getTerminationConfig().setMinutesSpentLimit(Long.valueOf(maximumMinutesSpent));
        solverConfig.setEnvironmentMode(environmentMode);
        Class<EasyScoreCalculator> easyScoreCalculatorClass = this.overwritingEasyScoreCalculatorClass();
        if (easyScoreCalculatorClass != null && environmentMode.isAsserted()) {
            ScoreDirectorFactoryConfig assertionScoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            assertionScoreDirectorFactoryConfig.setEasyScoreCalculatorClass(easyScoreCalculatorClass);
            solverConfig.getScoreDirectorFactoryConfig().setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryConfig);
        }
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(problem);
        return (Solution_)bestSolution;
    }

    protected Class<? extends EasyScoreCalculator> overwritingEasyScoreCalculatorClass() {
        return null;
    }

    protected SolverFactory<Solution_> buildSolverFactory() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.solverConfig);
        solverFactory.getSolverConfig().setTerminationConfig(new TerminationConfig());
        if (MOVE_THREAD_COUNT_OVERRIDE != null) {
            solverFactory.getSolverConfig().setMoveThreadCount(MOVE_THREAD_COUNT_OVERRIDE);
        }
        return solverFactory;
    }
}

