/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.app;

import java.io.File;
import java.util.Arrays;
import org.junit.Test;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.examples.common.app.PlannerBenchmarkTest;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class NQueensBenchmarkTest
extends PlannerBenchmarkTest {
    @Override
    protected String createSolverConfigResource() {
        return "org/optaplanner/examples/nqueens/solver/nqueensSolverConfig.xml";
    }

    @Test(timeout=600000L)
    public void benchmark64queens() {
        NQueens problem = (NQueens)new XStreamSolutionFileIO(new Class[]{NQueens.class}).read(new File("data/nqueens/unsolved/64queens.xml"));
        PlannerBenchmarkFactory plannerBenchmarkFactory = this.buildPlannerBenchmarkFactory();
        this.addAllStatistics(plannerBenchmarkFactory);
        plannerBenchmarkFactory.getPlannerBenchmarkConfig().setParallelBenchmarkCount("AUTO");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark((Object[])new NQueens[]{problem});
        plannerBenchmark.benchmark();
    }

    @Test(timeout=600000L)
    public void benchmark64queensSingleThread() {
        NQueens problem = (NQueens)new XStreamSolutionFileIO(new Class[]{NQueens.class}).read(new File("data/nqueens/unsolved/64queens.xml"));
        PlannerBenchmarkFactory plannerBenchmarkFactory = this.buildPlannerBenchmarkFactory();
        this.addAllStatistics(plannerBenchmarkFactory);
        plannerBenchmarkFactory.getPlannerBenchmarkConfig().setParallelBenchmarkCount("1");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark((Object[])new NQueens[]{problem});
        plannerBenchmark.benchmark();
    }

    protected void addAllStatistics(PlannerBenchmarkFactory plannerBenchmarkFactory) {
        ProblemBenchmarksConfig problemBenchmarksConfig = new ProblemBenchmarksConfig();
        problemBenchmarksConfig.setSingleStatisticTypeList(Arrays.asList(SingleStatisticType.values()));
        problemBenchmarksConfig.setProblemStatisticTypeList(Arrays.asList(ProblemStatisticType.values()));
        plannerBenchmarkFactory.getPlannerBenchmarkConfig().getInheritedSolverBenchmarkConfig().setProblemBenchmarksConfig(problemBenchmarksConfig);
    }

    @Test
    public void benchmarkDirectoryNameDuplication() {
        NQueens problem = (NQueens)new XStreamSolutionFileIO(new Class[]{NQueens.class}).read(new File("data/nqueens/unsolved/4queens.xml"));
        PlannerBenchmarkFactory plannerBenchmarkFactory = this.buildPlannerBenchmarkFactory();
        DefaultPlannerBenchmark plannerBenchmark = (DefaultPlannerBenchmark)plannerBenchmarkFactory.buildPlannerBenchmark((Object[])new NQueens[]{problem});
        plannerBenchmark.benchmarkingStarted();
        plannerBenchmark.getPlannerBenchmarkResult().initBenchmarkReportDirectory(plannerBenchmarkFactory.getPlannerBenchmarkConfig().getBenchmarkDirectory());
        plannerBenchmark.getPlannerBenchmarkResult().initBenchmarkReportDirectory(plannerBenchmarkFactory.getPlannerBenchmarkConfig().getBenchmarkDirectory());
    }
}

