/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.persistence;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.optaplanner.benchmark.impl.XStreamXmlPlannerBenchmarkFactory;

public class NQueensXStreamXmlPlannerBenchmarkFactoryTest {
    @Test
    public void configFileRemainsSameAfterReadWrite() throws IOException {
        this.readWriteTest("nqueensSimpleBenchmarkConfig.xml");
    }

    @Test
    public void configFileRemainsSameAfterReadWriteBuild() throws IOException {
        this.readBuildWriteTest("nqueensSimpleBenchmarkConfig.xml");
    }

    @Test
    public void configFileRemainsSameAfterReadWriteWithInherited() throws IOException {
        this.readWriteTest("nqueensSimpleBenchmarkConfigInherited.xml");
    }

    @Test
    @Ignore(value="Config shouldn't actually remain the same: we inherited the subSingleCount, problemBenchmarks and more")
    public void configFileRemainsSameAfterReadWriteBuildWithInherited() throws IOException {
        this.readBuildWriteTest("nqueensSimpleBenchmarkConfigInherited.xml");
    }

    private XStreamXmlPlannerBenchmarkFactory createXStreamXmlPlannerBenchmarkFactory(String plannerBenchmarkConfigResource) throws IOException {
        InputStream originalConfigInputStream = this.getClass().getResourceAsStream(plannerBenchmarkConfigResource);
        XStreamXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new XStreamXmlPlannerBenchmarkFactory().configure(originalConfigInputStream);
        plannerBenchmarkFactory.getXStream().setMode(1001);
        return plannerBenchmarkFactory;
    }

    private void compareOutputToOriginal(XStreamXmlPlannerBenchmarkFactory plannerBenchmarkFactory, String plannerBenchmarkConfigResource) throws IOException {
        String originalXml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(plannerBenchmarkConfigResource), (String)"UTF-8");
        String savedXml = plannerBenchmarkFactory.getXStream().toXML((Object)plannerBenchmarkFactory.getPlannerBenchmarkConfig());
        Assert.assertEquals((Object)originalXml.trim(), (Object)savedXml);
    }

    private void readWriteTest(String plannerBenchmarkConfigResource) throws IOException {
        XStreamXmlPlannerBenchmarkFactory plannerBenchmarkFactory = this.createXStreamXmlPlannerBenchmarkFactory(plannerBenchmarkConfigResource);
        this.compareOutputToOriginal(plannerBenchmarkFactory, plannerBenchmarkConfigResource);
    }

    private void readBuildWriteTest(String plannerBenchmarkConfigResource) throws IOException {
        XStreamXmlPlannerBenchmarkFactory plannerBenchmarkFactory = this.createXStreamXmlPlannerBenchmarkFactory(plannerBenchmarkConfigResource);
        plannerBenchmarkFactory.getPlannerBenchmarkConfig().buildPlannerBenchmark();
        this.compareOutputToOriginal(plannerBenchmarkFactory, plannerBenchmarkConfigResource);
    }
}

