/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.examples.common.persistence.StringDataGenerator;

public class StringDataGeneratorTest {
    @Test
    public void with2Parts() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        Assert.assertEquals((Object)"a h", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b i", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c j", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d k", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"a i", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b j", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c k", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d h", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"a j", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b k", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c h", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d i", (Object)generator.generateNextValue());
    }

    @Test
    public void with3Parts() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        generator.addPart(new String[]{"o", "p", "q", "r"});
        Assert.assertEquals((Object)"a h o", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b i p", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c j q", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d k r", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"a h p", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b i q", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c j r", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d k o", (Object)generator.generateNextValue());
    }

    @Test
    public void with4Parts() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        generator.addPart(new String[]{"o", "p", "q", "r"});
        generator.addPart(new String[]{"v", "w", "x", "y"});
        Assert.assertEquals((Object)"a h o v", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b i p w", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c j q x", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d k r y", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"a h p w", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b i q x", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c j r y", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d k o v", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"a h q x", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b i r y", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c j o v", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d k p w", (Object)generator.generateNextValue());
    }

    @Test
    public void with4PartsMaximumSizeFor2() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        generator.addPart(new String[]{"o", "p", "q", "r"});
        generator.addPart(new String[]{"v", "w", "x", "y"});
        generator.predictMaximumSizeAndReset(9);
        Assert.assertEquals((Object)"a v", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b w", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c x", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d y", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"a w", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b x", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c y", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d v", (Object)generator.generateNextValue());
    }

    @Test
    public void with4PartsMaximumSizeFor3() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        generator.addPart(new String[]{"o", "p", "q", "r"});
        generator.addPart(new String[]{"v", "w", "x", "y"});
        generator.predictMaximumSizeAndReset(19);
        Assert.assertEquals((Object)"a o v", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b p w", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c q x", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d r y", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"a o w", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"b p x", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"c q y", (Object)generator.generateNextValue());
        Assert.assertEquals((Object)"d r v", (Object)generator.generateNextValue());
    }
}

