/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.persistence.SolutionDao;

@RunWith(value=Parameterized.class)
public abstract class AbstractPhaseTest<Solution_>
extends LoggingTest {
    protected SolutionDao<Solution_> solutionDao;
    protected File dataFile;

    protected static <Solution_, Enum_ extends Enum> Collection<Object[]> buildParameters(SolutionDao<Solution_> solutionDao, Enum_[] types, String ... unsolvedFileNames) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>(unsolvedFileNames.length * types.length);
        File dataDir = solutionDao.getDataDir();
        File unsolvedDataDir = new File(dataDir, "unsolved");
        for (String unsolvedFileName : unsolvedFileNames) {
            File unsolvedFile = new File(unsolvedDataDir, unsolvedFileName);
            if (!unsolvedFile.exists()) {
                throw new IllegalStateException("The directory unsolvedFile (" + unsolvedFile.getAbsolutePath() + ") does not exist.");
            }
            for (Enum_ type : types) {
                filesAsParameters.add(new Object[]{unsolvedFile, type});
            }
        }
        return filesAsParameters;
    }

    protected AbstractPhaseTest(File dataFile) {
        this.dataFile = dataFile;
    }

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
    }

    protected abstract SolutionDao<Solution_> createSolutionDao();

    @Test(timeout=600000L)
    public void runPhase() {
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory();
        Solution_ planningProblem = this.readPlanningProblem();
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(planningProblem);
        this.assertSolution(bestSolution);
        Assert.assertNotNull((Object)solver.getBestScore());
    }

    protected void assertSolution(Solution_ bestSolution) {
        Assert.assertNotNull(bestSolution);
    }

    protected abstract SolverFactory<Solution_> buildSolverFactory();

    protected abstract String createSolverConfigResource();

    protected Solution_ readPlanningProblem() {
        return (Solution_)this.solutionDao.readSolution(this.dataFile);
    }
}

