/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.domain.solver;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.rocktour.domain.RockShow;
import org.optaplanner.examples.rocktour.domain.RockStandstill;
import org.optaplanner.examples.rocktour.domain.RockTimeOfDay;
import org.optaplanner.examples.rocktour.domain.RockTourSolution;

public class RockShowVariableListener
implements VariableListener<RockShow> {
    public void beforeEntityAdded(ScoreDirector scoreDirector, RockShow show) {
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, RockShow show) {
        this.updateDate(scoreDirector, show);
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, RockShow show) {
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, RockShow show) {
        this.updateDate(scoreDirector, show);
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, RockShow show) {
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, RockShow show) {
    }

    protected void updateDate(ScoreDirector scoreDirector, RockShow sourceShow) {
        RockTourSolution solution = (RockTourSolution)scoreDirector.getWorkingSolution();
        RockStandstill previousStandstill = sourceShow.getPreviousStandstill();
        Arrival arrival = this.calculateArrival(solution, sourceShow, previousStandstill);
        for (RockShow shadowShow = sourceShow; !(shadowShow == null || Objects.equals(shadowShow.getDate(), arrival.date) && Objects.equals((Object)shadowShow.getTimeOfDay(), (Object)arrival.timeOfDay) && shadowShow.getHosWeekStart() == arrival.hosWeekStart && Objects.equals(shadowShow.getHosWeekDrivingSecondsTotal(), arrival.hosWeekDrivingSecondsTotal)); shadowShow = shadowShow.getNextShow()) {
            scoreDirector.beforeVariableChanged((Object)shadowShow, "date");
            shadowShow.setDate(arrival.date);
            scoreDirector.afterVariableChanged((Object)shadowShow, "date");
            scoreDirector.beforeVariableChanged((Object)shadowShow, "timeOfDay");
            shadowShow.setTimeOfDay(arrival.timeOfDay);
            scoreDirector.afterVariableChanged((Object)shadowShow, "timeOfDay");
            scoreDirector.beforeVariableChanged((Object)shadowShow, "hosWeekStart");
            shadowShow.setHosWeekStart(arrival.hosWeekStart);
            scoreDirector.afterVariableChanged((Object)shadowShow, "hosWeekStart");
            scoreDirector.beforeVariableChanged((Object)shadowShow, "hosWeekDrivingSecondsTotal");
            shadowShow.setHosWeekDrivingSecondsTotal(arrival.hosWeekDrivingSecondsTotal);
            scoreDirector.afterVariableChanged((Object)shadowShow, "hosWeekDrivingSecondsTotal");
            RockShow previousShow = shadowShow;
            arrival = this.calculateArrival(solution, shadowShow, previousShow);
        }
    }

    private Arrival calculateArrival(RockTourSolution solution, RockShow show, RockStandstill previousStandstill) {
        LocalDate showDate;
        if (show == null || previousStandstill == null || previousStandstill.getDepartureDate() == null || previousStandstill.getHosWeekStart().getHosWeekStart() == null) {
            return new Arrival(null, null, null, null);
        }
        long earlyLateBreakDrivingSecondsBudget = solution.getConstraintConfiguration().getEarlyLateBreakDrivingSecondsBudget();
        long nightDrivingSecondsBudget = solution.getConstraintConfiguration().getNightDrivingSecondsBudget();
        long hosWeekDrivingSecondsBudget = solution.getConstraintConfiguration().getHosWeekDrivingSecondsBudget();
        int hosWeekConsecutiveDrivingDaysBudget = solution.getConstraintConfiguration().getHosWeekConsecutiveDrivingDaysBudget();
        int hosWeekRestDays = solution.getConstraintConfiguration().getHosWeekRestDays();
        RockTimeOfDay timeOfDay = previousStandstill.getDepartureTimeOfDay();
        LocalDate arrivalDate = previousStandstill.getDepartureDate();
        RockStandstill hosWeekStart = previousStandstill.getHosWeekStart();
        Long hosWeekDrivingSecondsTotal = previousStandstill.getHosWeekDrivingSecondsTotal();
        long drivingSeconds = show.getDrivingTimeFromPreviousStandstill();
        while (drivingSeconds >= 0L) {
            if (timeOfDay == RockTimeOfDay.EARLY) {
                drivingSeconds -= earlyLateBreakDrivingSecondsBudget;
                timeOfDay = RockTimeOfDay.LATE;
                continue;
            }
            drivingSeconds -= nightDrivingSecondsBudget;
            arrivalDate = arrivalDate.plusDays(1L);
            timeOfDay = RockTimeOfDay.EARLY;
        }
        if ((hosWeekDrivingSecondsTotal = Long.valueOf(hosWeekDrivingSecondsTotal + show.getDrivingTimeFromPreviousStandstill())) > hosWeekDrivingSecondsBudget || hosWeekStart.getDepartureDate().until(arrivalDate, ChronoUnit.DAYS) > (long)hosWeekConsecutiveDrivingDaysBudget) {
            arrivalDate = arrivalDate.plusDays(hosWeekRestDays);
            hosWeekStart = show;
            hosWeekDrivingSecondsTotal = hosWeekDrivingSecondsTotal - hosWeekDrivingSecondsBudget;
            timeOfDay = RockTimeOfDay.EARLY;
        }
        if (show.getDurationInHalfDay() % 2 == 0 && timeOfDay != RockTimeOfDay.EARLY) {
            arrivalDate = arrivalDate.plusDays(1L);
            timeOfDay = RockTimeOfDay.EARLY;
        }
        if ((showDate = show.getAvailableDateSet().ceiling(arrivalDate)) == null || showDate.compareTo(show.getBus().getEndDate()) >= 0) {
            return new Arrival(null, null, null, null);
        }
        if (!arrivalDate.equals(showDate) && timeOfDay != RockTimeOfDay.EARLY) {
            timeOfDay = RockTimeOfDay.EARLY;
        }
        if (arrivalDate.until(showDate, ChronoUnit.DAYS) >= 2L) {
            hosWeekStart = show;
            hosWeekDrivingSecondsTotal = 0L;
        }
        return new Arrival(showDate, timeOfDay, hosWeekStart, hosWeekDrivingSecondsTotal);
    }

    private class Arrival {
        public LocalDate date;
        public RockTimeOfDay timeOfDay;
        public RockStandstill hosWeekStart;
        public Long hosWeekDrivingSecondsTotal;

        public Arrival(LocalDate date, RockTimeOfDay timeOfDay, RockStandstill hosWeekStart, Long hosWeekDrivingSecondsTotal) {
            this.date = date;
            this.timeOfDay = timeOfDay;
            this.hosWeekStart = hosWeekStart;
            this.hosWeekDrivingSecondsTotal = hosWeekDrivingSecondsTotal;
        }
    }
}

