/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.app;

import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.persistence.CheapTimeExporter;
import org.optaplanner.examples.cheaptime.persistence.CheapTimeImporter;
import org.optaplanner.examples.cheaptime.swingui.CheapTimePanel;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class CheapTimeApp
extends CommonApp<CheapTimeSolution> {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/cheaptime/solver/cheapTimeSolverConfig.xml";
    public static final String DATA_DIR_NAME = "cheaptime";

    public static void main(String[] args) {
        CheapTimeApp.prepareSwingEnvironment();
        new CheapTimeApp().init();
    }

    public CheapTimeApp() {
        super("Cheap time scheduling", "Official competition name: ICON Challenge on Forecasting and Scheduling\n\nAssign tasks to machines and time.\n\nEach machine must have enough hardware to run all of its tasks.\nEach task and machine consumes power. The power price differs over time.\nMinimize the power cost.", SOLVER_CONFIG, DATA_DIR_NAME, "/org/optaplanner/examples/cheaptime/swingui/cheapTimeLogo.png");
    }

    protected CheapTimePanel createSolutionPanel() {
        return new CheapTimePanel();
    }

    @Override
    public SolutionFileIO<CheapTimeSolution> createSolutionFileIO() {
        return new XStreamSolutionFileIO(new Class[]{CheapTimeSolution.class});
    }

    @Override
    protected AbstractSolutionImporter[] createSolutionImporters() {
        return new AbstractSolutionImporter[]{new CheapTimeImporter()};
    }

    @Override
    protected AbstractSolutionExporter createSolutionExporter() {
        return new CheapTimeExporter();
    }
}

