/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

@RunWith(value=Parameterized.class)
public abstract class AbstractPhaseTest<Solution_>
extends LoggingTest {
    protected final CommonApp<Solution_> commonApp;
    protected final File dataFile;
    protected SolutionFileIO<Solution_> solutionFileIO;

    protected static <Solution_, Enum_ extends Enum> Collection<Object[]> buildParameters(CommonApp<Solution_> commonApp, Enum_[] types, String ... unsolvedFileNames) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>(unsolvedFileNames.length * types.length);
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File unsolvedDataDir = new File(dataDir, "unsolved");
        for (String unsolvedFileName : unsolvedFileNames) {
            File unsolvedFile = new File(unsolvedDataDir, unsolvedFileName);
            if (!unsolvedFile.exists()) {
                throw new IllegalStateException("The directory unsolvedFile (" + unsolvedFile.getAbsolutePath() + ") does not exist.");
            }
            for (Enum_ type : types) {
                filesAsParameters.add(new Object[]{unsolvedFile, type});
            }
        }
        return filesAsParameters;
    }

    protected AbstractPhaseTest(CommonApp<Solution_> commonApp, File dataFile) {
        this.commonApp = commonApp;
        this.dataFile = dataFile;
    }

    @Before
    public void setUp() {
        this.solutionFileIO = this.commonApp.createSolutionFileIO();
    }

    @Test(timeout=600000L)
    public void runPhase() {
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory();
        Solution_ problem = this.readProblem();
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(problem);
        this.assertSolution(bestSolution);
        Assert.assertNotNull((Object)solver.getBestScore());
    }

    protected void assertSolution(Solution_ bestSolution) {
        Assert.assertNotNull(bestSolution);
    }

    protected abstract SolverFactory<Solution_> buildSolverFactory();

    protected Solution_ readProblem() {
        Object problem = this.solutionFileIO.read(this.dataFile);
        this.logger.info("Opened: {}", (Object)this.dataFile);
        return (Solution_)problem;
    }
}

