/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.optional.score;

import java.util.function.Function;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.conferencescheduling.domain.Talk;

public class ConferenceSchedulingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.roomUnavailableTimeslot(factory), this.roomConflict(factory), this.speakerUnavailableTimeslot(factory), this.speakerConflict(factory), this.talkPrerequisiteTalks(factory), this.talkMutuallyExclusiveTalksTags(factory), this.consecutiveTalksPause(factory), this.crowdControl(factory), this.speakerRequiredTimeslotTags(factory), this.speakerProhibitedTimeslotTags(factory), this.talkRequiredTimeslotTags(factory), this.talkProhibitedTimeslotTags(factory), this.speakerRequiredRoomTags(factory), this.speakerProhibitedRoomTags(factory), this.talkRequiredRoomTags(factory), this.talkProhibitedRoomTags(factory), this.publishedTimeslot(factory), this.publishedRoom(factory), this.themeTrackConflict(factory), this.themeTrackRoomStability(factory), this.sectorConflict(factory), this.audienceTypeDiversity(factory), this.audienceTypeThemeTrackConflict(factory), this.audienceLevelDiversity(factory), this.contentAudienceLevelFlowViolation(factory), this.contentConflict(factory), this.languageDiversity(factory), this.sameDayTalks(factory), this.popularTalks(factory), this.speakerPreferredTimeslotTags(factory), this.speakerUndesiredTimeslotTags(factory), this.talkPreferredTimeslotTags(factory), this.talkUndesiredTimeslotTags(factory), this.speakerPreferredRoomTags(factory), this.speakerUndesiredRoomTags(factory), this.talkPreferredRoomTags(factory), this.talkUndesiredRoomTags(factory)};
    }

    private Constraint roomUnavailableTimeslot(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(Talk::hasUnavailableRoom).penalizeConfigurable("Room unavailable timeslot", Talk::getDurationInMinutes);
    }

    private Constraint roomConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.equal(Talk::getRoom)).filter(Talk::overlapsTime).penalizeConfigurable("Room conflict", Talk::overlappingDurationInMinutes);
    }

    private Constraint speakerUnavailableTimeslot(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(Talk::hasAnyUnavailableSpeaker).penalizeConfigurable("Speaker unavailable timeslot", Talk::getDurationInMinutes);
    }

    private Constraint speakerConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.intersecting(Talk::getSpeakerList)).filter(Talk::overlapsTime).penalizeConfigurable("Speaker conflict", Talk::overlappingDurationInMinutes);
    }

    private Constraint talkPrerequisiteTalks(ConstraintFactory factory) {
        return factory.from(Talk.class).join(Talk.class, Joiners.containing(Talk::getPrerequisiteTalkSet, Function.identity()), Joiners.lessThan(talk1 -> talk1.getTimeslot().getStartDateTime(), talk2 -> talk2.getTimeslot().getEndDateTime())).penalizeConfigurable("Talk prerequisite talks", Talk::combinedDurationInMinutes);
    }

    private Constraint talkMutuallyExclusiveTalksTags(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.intersecting(Talk::getMutuallyExclusiveTalksTagSet)).filter(Talk::overlapsTime).penalizeConfigurable("Talk mutually-exclusive-talks tags", (talk1, talk2) -> talk1.overlappingMutuallyExclusiveTalksTagCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    private Constraint consecutiveTalksPause(ConstraintFactory factory) {
        throw new UnsupportedOperationException();
    }

    private Constraint crowdControl(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.getCrowdControlRisk() > 0).join(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> talk1 != talk2).groupBy((talk1, talk2) -> talk1, ConstraintCollectors.countBi()).filter((talk, count) -> count != 1).penalizeConfigurable("Crowd control", (talk, count) -> talk.getDurationInMinutes());
    }

    private Constraint speakerRequiredTimeslotTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.missingSpeakerRequiredTimeslotTagCount() > 0).penalizeConfigurable("Speaker required timeslot tags", talk -> talk.missingSpeakerRequiredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    private Constraint speakerProhibitedTimeslotTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.prevailingSpeakerProhibitedTimeslotTagCount() > 0).penalizeConfigurable("Speaker prohibited timeslot tags", talk -> talk.prevailingSpeakerProhibitedTimeslotTagCount() * talk.getDurationInMinutes());
    }

    private Constraint talkRequiredTimeslotTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.missingRequiredTimeslotTagCount() > 0).penalizeConfigurable("Talk required timeslot tags", talk -> talk.missingRequiredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    private Constraint talkProhibitedTimeslotTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.prevailingProhibitedTimeslotTagCount() > 0).penalizeConfigurable("Talk prohibited timeslot tags", talk -> talk.prevailingProhibitedTimeslotTagCount() * talk.getDurationInMinutes());
    }

    private Constraint speakerRequiredRoomTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.missingSpeakerRequiredRoomTagCount() > 0).penalizeConfigurable("Speaker required room tags", talk -> talk.missingSpeakerRequiredRoomTagCount() * talk.getDurationInMinutes());
    }

    private Constraint speakerProhibitedRoomTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.prevailingSpeakerProhibitedRoomTagCount() > 0).penalizeConfigurable("Speaker prohibited room tags", talk -> talk.prevailingSpeakerProhibitedRoomTagCount() * talk.getDurationInMinutes());
    }

    private Constraint talkRequiredRoomTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.missingRequiredRoomTagCount() > 0).penalizeConfigurable("Talk required room tags", talk -> talk.missingRequiredRoomTagCount() * talk.getDurationInMinutes());
    }

    private Constraint talkProhibitedRoomTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.prevailingProhibitedRoomTagCount() > 0).penalizeConfigurable("Talk prohibited room tags", talk -> talk.prevailingProhibitedRoomTagCount() * talk.getDurationInMinutes());
    }

    private Constraint publishedTimeslot(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.getPublishedTimeslot() != null && talk.getTimeslot() != talk.getPublishedTimeslot()).penalizeConfigurable("Published timeslot");
    }

    private Constraint publishedRoom(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.getPublishedRoom() != null && talk.getRoom() != talk.getPublishedRoom()).penalizeConfigurable("Published room");
    }

    private Constraint themeTrackConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.intersecting(Talk::getThemeTrackTagSet)).filter(Talk::overlapsTime).penalizeConfigurable("Theme track conflict", (talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    private Constraint themeTrackRoomStability(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.equal(talk -> talk.getTimeslot().getStartDateTime().toLocalDate()), Joiners.intersecting(Talk::getThemeTrackTagSet)).filter(Talk::overlapsTime).filter((talk1, talk2) -> talk1.getRoom() != talk2.getRoom()).penalizeConfigurable("Theme track room stability", (talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.combinedDurationInMinutes((Talk)talk2));
    }

    private Constraint sectorConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.intersecting(Talk::getSectorTagSet)).filter(Talk::overlapsTime).penalizeConfigurable("Sector conflict", (talk1, talk2) -> talk1.overlappingSectorCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    private Constraint audienceTypeDiversity(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot), Joiners.intersecting(Talk::getAudienceTypeSet)).rewardConfigurable("Audience type diversity", (talk1, talk2) -> talk1.overlappingAudienceTypeCount((Talk)talk2) * talk1.getTimeslot().getDurationInMinutes());
    }

    private Constraint audienceTypeThemeTrackConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.intersecting(Talk::getThemeTrackTagSet), Joiners.intersecting(Talk::getAudienceTypeSet)).filter(Talk::overlapsTime).penalizeConfigurable("Audience type theme track conflict", (talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.overlappingAudienceTypeCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    private Constraint audienceLevelDiversity(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> talk1.getAudienceLevel() != talk2.getAudienceLevel()).rewardConfigurable("Audience level diversity", (talk1, talk2) -> talk1.getTimeslot().getDurationInMinutes());
    }

    private Constraint contentAudienceLevelFlowViolation(ConstraintFactory factory) {
        return factory.from(Talk.class).join(Talk.class, Joiners.intersecting(Talk::getContentTagSet), Joiners.lessThan(Talk::getAudienceLevel), Joiners.greaterThan(talk1 -> talk1.getTimeslot().getEndDateTime(), talk2 -> talk2.getTimeslot().getStartDateTime())).penalizeConfigurable("Content audience level flow violation", (talk1, talk2) -> talk1.overlappingContentCount((Talk)talk2) * talk1.combinedDurationInMinutes((Talk)talk2));
    }

    private Constraint contentConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.intersecting(Talk::getContentTagSet)).filter(Talk::overlapsTime).penalizeConfigurable("Content conflict", (talk1, talk2) -> talk1.overlappingContentCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    private Constraint languageDiversity(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> !talk1.getLanguage().equals(talk2.getLanguage())).rewardConfigurable("Language diversity", (talk1, talk2) -> talk1.getTimeslot().getDurationInMinutes());
    }

    private Constraint sameDayTalks(ConstraintFactory factory) {
        return factory.fromUniquePair(Talk.class).filter((talk1, talk2) -> (talk1.overlappingContentCount((Talk)talk2) > 0 || talk1.overlappingThemeTrackCount((Talk)talk2) > 0) && !talk1.getTimeslot().getDate().equals(talk2.getTimeslot().getDate())).penalizeConfigurable("Same day talks", (talk1, talk2) -> talk1.overlappingContentCount((Talk)talk2) * talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    private Constraint popularTalks(ConstraintFactory factory) {
        return factory.from(Talk.class).join(Talk.class, Joiners.lessThan(Talk::getFavoriteCount), Joiners.greaterThan(talk -> talk.getRoom().getCapacity())).penalizeConfigurable("Popular talks", Talk::combinedDurationInMinutes);
    }

    private Constraint speakerPreferredTimeslotTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.missingSpeakerPreferredTimeslotTagCount() > 0).penalizeConfigurable("Speaker preferred timeslot tags", talk -> talk.missingSpeakerPreferredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    private Constraint speakerUndesiredTimeslotTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.prevailingSpeakerUndesiredTimeslotTagCount() > 0).penalizeConfigurable("Speaker undesired timeslot tags", talk -> talk.prevailingSpeakerUndesiredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    private Constraint talkPreferredTimeslotTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.missingPreferredTimeslotTagCount() > 0).penalizeConfigurable("Talk preferred timeslot tags", talk -> talk.missingPreferredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    private Constraint talkUndesiredTimeslotTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.prevailingUndesiredTimeslotTagCount() > 0).penalizeConfigurable("Talk undesired timeslot tags", talk -> talk.prevailingUndesiredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    private Constraint speakerPreferredRoomTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.missingSpeakerPreferredRoomTagCount() > 0).penalizeConfigurable("Speaker preferred room tags", talk -> talk.missingSpeakerPreferredRoomTagCount() * talk.getDurationInMinutes());
    }

    private Constraint speakerUndesiredRoomTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.prevailingSpeakerUndesiredRoomTagCount() > 0).penalizeConfigurable("Speaker undesired room tags", talk -> talk.prevailingSpeakerUndesiredRoomTagCount() * talk.getDurationInMinutes());
    }

    private Constraint talkPreferredRoomTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.missingPreferredRoomTagCount() > 0).penalizeConfigurable("Talk preferred room tags", talk -> talk.missingPreferredRoomTagCount() * talk.getDurationInMinutes());
    }

    private Constraint talkUndesiredRoomTags(ConstraintFactory factory) {
        return factory.from(Talk.class).filter(talk -> talk.prevailingUndesiredRoomTagCount() > 0).penalizeConfigurable("Talk undesired room tags", talk -> talk.prevailingUndesiredRoomTagCount() * talk.getDurationInMinutes());
    }
}

