/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.solver.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.solver.MrServiceDependency;

public class MachineReassignmentConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.maximumCapacity(factory), this.serviceConflict(factory), this.serviceLocationSpread(factory), this.serviceDependency(factory), this.transientUsage(factory), this.loadCost(factory), this.balanceCost(factory), this.processMoveCost(factory), this.serviceMoveCost(factory), this.machineMoveCost(factory)};
    }

    private Constraint maximumCapacity(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).join(MrProcessAssignment.class, Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getMaximumCapacity() < usage).penalizeLong("maximumCapacity", (Score)HardSoftLongScore.ofHard((long)1L), (machineCapacity, usage) -> machineCapacity.getMaximumCapacity() - usage);
    }

    private Constraint serviceConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(MrProcessAssignment.class, Joiners.equal(MrProcessAssignment::getMachine), Joiners.equal(MrProcessAssignment::getService)).penalize("serviceConflict", (Score)HardSoftLongScore.ofHard((long)1L));
    }

    private Constraint serviceLocationSpread(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).groupBy(MrProcessAssignment::getService, ConstraintCollectors.countDistinct(MrProcessAssignment::getLocation)).filter((service, distinctLocationCount) -> service.getLocationSpread() > distinctLocationCount).penalize("serviceLocationSpread", (Score)HardSoftLongScore.ofHard((long)1L));
    }

    private Constraint serviceDependency(ConstraintFactory factory) {
        return factory.from(MrServiceDependency.class).join(MrProcessAssignment.class, Joiners.equal(MrServiceDependency::getFromService, MrProcessAssignment::getService)).join(MrProcessAssignment.class, Joiners.equal((serviceDependency, processAssignment) -> serviceDependency.getToService(), MrProcessAssignment::getService)).filter((serviceDependency, processAssignmentFrom, processAssignmentTo) -> !processAssignmentFrom.getNeighborhood().equals(processAssignmentTo.getNeighborhood())).penalize("serviceDependency", (Score)HardSoftLongScore.ofHard((long)1L));
    }

    private Constraint transientUsage(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).filter(MrMachineCapacity::isTransientlyConsumed).join(factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved), Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getOriginalMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getMaximumCapacity() < usage).penalizeLong("transientUsage", (Score)HardSoftLongScore.ofHard((long)1L), (machineCapacity, usage) -> machineCapacity.getMaximumCapacity() - usage);
    }

    private Constraint loadCost(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).join(MrProcessAssignment.class, Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getSafetyCapacity() < usage).penalizeLong("loadCost", (Score)HardSoftLongScore.ofSoft((long)1L), (machineCapacity, usage) -> machineCapacity.getSafetyCapacity() - usage);
    }

    private Constraint balanceCost(ConstraintFactory factory) {
        throw new UnsupportedOperationException("Not yet implemented due to missing support for quad streams.");
    }

    private Constraint processMoveCost(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved).penalizeLong("processMoveCost", (Score)HardSoftLongScore.ofSoft((long)1L), MrProcessAssignment::getProcessMoveCost);
    }

    private Constraint serviceMoveCost(ConstraintFactory factory) {
        throw new UnsupportedOperationException("Not yet implemented due to missing aggregation function.");
    }

    private Constraint machineMoveCost(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved).penalizeLong("machineMoveCost", (Score)HardSoftLongScore.ofSoft((long)1L), MrProcessAssignment::getMachineMoveCost);
    }
}

