/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.examples.common.persistence.AbstractXlsxSolutionFileIO;
import org.optaplanner.examples.meetingscheduling.domain.Attendance;
import org.optaplanner.examples.meetingscheduling.domain.Day;
import org.optaplanner.examples.meetingscheduling.domain.Meeting;
import org.optaplanner.examples.meetingscheduling.domain.MeetingAssignment;
import org.optaplanner.examples.meetingscheduling.domain.MeetingConstraintConfiguration;
import org.optaplanner.examples.meetingscheduling.domain.MeetingSchedule;
import org.optaplanner.examples.meetingscheduling.domain.Person;
import org.optaplanner.examples.meetingscheduling.domain.PreferredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.RequiredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;

public class MeetingSchedulingXlsxFileIO
extends AbstractXlsxSolutionFileIO<MeetingSchedule> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MeetingSchedule read(File inputScheduleFile) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputScheduleFile));){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            MeetingSchedule meetingSchedule = new MeetingSchedulingXlsxReader(workbook).read();
            return meetingSchedule;
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed reading inputScheduleFile (" + inputScheduleFile + ").", e);
        }
    }

    public void write(MeetingSchedule solution, File outputScheduleFile) {
        try (FileOutputStream out = new FileOutputStream(outputScheduleFile);){
            Workbook workbook = new MeetingSchedulingXlsxWriter(solution).write();
            workbook.write((OutputStream)out);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed writing outputScheduleFile (" + outputScheduleFile + ") for schedule (" + solution + ").", e);
        }
    }

    private class MeetingSchedulingXlsxWriter
    extends AbstractXlsxSolutionFileIO.AbstractXlsxWriter<MeetingSchedule> {
        MeetingSchedulingXlsxWriter(MeetingSchedule solution) {
            super(solution, "org/optaplanner/examples/meetingscheduling/solver/meetingSchedulingSolverConfig.xml");
        }

        @Override
        public Workbook write() {
            this.workbook = new XSSFWorkbook();
            this.creationHelper = this.workbook.getCreationHelper();
            this.createStyles();
            this.writeConfiguration();
            this.writeDays();
            this.writeRooms();
            this.writePersons();
            this.writeMeetings();
            this.writeRoomsView();
            this.writePersonsView();
            this.writePrintedFormView();
            this.writeScoreView(justificationList -> justificationList.stream().filter(o -> o instanceof MeetingAssignment).map(o -> ((MeetingAssignment)o).toString()).collect(Collectors.joining(", ")));
            return this.workbook;
        }

        private void writeConfiguration() {
            this.nextSheet("Configuration", 1, 3, false);
            this.nextRow();
            this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(LocalDateTime.now()) + " " + AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(LocalDateTime.now()));
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Constraint");
            this.nextHeaderCell("Weight");
            this.nextHeaderCell("Description");
            MeetingConstraintConfiguration constraintConfiguration = ((MeetingSchedule)this.solution).getConstraintConfiguration();
            this.writeIntConstraintParameterLine("Room conflict", constraintConfiguration.getRoomConflict().getHardScore(), "");
            this.writeIntConstraintParameterLine("Don't go in overtime", constraintConfiguration.getDontGoInOvertime().getHardScore(), "");
            this.writeIntConstraintParameterLine("Required attendance conflict", constraintConfiguration.getRequiredAttendanceConflict().getHardScore(), "");
            this.writeIntConstraintParameterLine("Required room capacity", constraintConfiguration.getRequiredRoomCapacity().getHardScore(), "");
            this.writeIntConstraintParameterLine("Start and end on same day", constraintConfiguration.getStartAndEndOnSameDay().getHardScore(), "");
            this.nextRow();
            this.writeIntConstraintParameterLine("Required and preferred attendance conflict", constraintConfiguration.getRequiredAndPreferredAttendanceConflict().getMediumScore(), "");
            this.writeIntConstraintParameterLine("Preferred attendance conflict", constraintConfiguration.getPreferredAttendanceConflict().getMediumScore(), "");
            this.nextRow();
            this.writeIntConstraintParameterLine("Do all meetings as soon as possible", constraintConfiguration.getDoAllMeetingsAsSoonAsPossible().getSoftScore(), "");
            this.writeIntConstraintParameterLine("One TimeGrain break between two consecutive meetings", constraintConfiguration.getOneTimeGrainBreakBetweenTwoConsecutiveMeetings().getSoftScore(), "");
            this.writeIntConstraintParameterLine("Overlapping meetings", constraintConfiguration.getOverlappingMeetings().getSoftScore(), "");
            this.writeIntConstraintParameterLine("Assign larger rooms first", constraintConfiguration.getAssignLargerRoomsFirst().getSoftScore(), "");
            this.writeIntConstraintParameterLine("Room stability", constraintConfiguration.getRoomStability().getSoftScore(), "");
            this.autoSizeColumnsWithHeader();
        }

        private void writePersons() {
            this.nextSheet("Persons", 1, 0, false);
            this.nextRow();
            this.nextHeaderCell("Full name");
            for (Person person : ((MeetingSchedule)this.solution).getPersonList()) {
                this.nextRow();
                this.nextCell().setCellValue(person.getFullName());
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeMeetings() {
            this.nextSheet("Meetings", 1, 1, false);
            this.nextRow();
            this.nextHeaderCell("Topic");
            this.nextHeaderCell("Group");
            this.nextHeaderCell("Duration");
            this.nextHeaderCell("Speakers");
            this.nextHeaderCell("Content");
            this.nextHeaderCell("Required attendance list");
            this.nextHeaderCell("Preferred attendance list");
            this.nextHeaderCell("Day");
            this.nextHeaderCell("Starting time");
            this.nextHeaderCell("Room");
            Map meetingAssignmentMap = ((MeetingSchedule)this.solution).getMeetingAssignmentList().stream().collect(Collectors.groupingBy(MeetingAssignment::getMeeting, Collectors.toList()));
            for (Meeting meeting : ((MeetingSchedule)this.solution).getMeetingList()) {
                this.nextRow();
                this.nextCell().setCellValue(meeting.getTopic());
                this.nextCell().setCellValue(meeting.isEntireGroupMeeting() ? "Y" : "");
                this.nextCell().setCellValue((double)(meeting.getDurationInGrains() * 15));
                this.nextCell().setCellValue(meeting.getSpeakerList() == null ? "" : meeting.getSpeakerList().stream().map(Person::getFullName).collect(Collectors.joining(", ")));
                this.nextCell().setCellValue(meeting.getContent() == null ? "" : meeting.getContent());
                this.nextCell().setCellValue(meeting.getRequiredAttendanceList().stream().map(requiredAttendance -> requiredAttendance.getPerson().getFullName()).collect(Collectors.joining(", ")));
                this.nextCell().setCellValue(meeting.getPreferredAttendanceList().stream().map(preferredAttendance -> preferredAttendance.getPerson().getFullName()).collect(Collectors.joining(", ")));
                List meetingAssignmentList = meetingAssignmentMap.get(meeting);
                if (meetingAssignmentList.size() != 1) {
                    throw new IllegalStateException("Impossible state: the meeting (" + meeting + ") does not have exactly one assignment, but " + meetingAssignmentList.size() + " assignments instead.");
                }
                MeetingAssignment meetingAssignment = (MeetingAssignment)meetingAssignmentList.get(0);
                TimeGrain startingTimeGrain = meetingAssignment.getStartingTimeGrain();
                this.nextCell().setCellValue(startingTimeGrain == null ? "" : AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(startingTimeGrain.getDate()));
                this.nextCell().setCellValue(startingTimeGrain == null ? "" : AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(startingTimeGrain.getTime()));
                this.nextCell().setCellValue(meetingAssignment.getRoom() == null ? "" : meetingAssignment.getRoom().getName());
            }
            this.setSizeColumnsWithHeader(5000);
        }

        private void writeDays() {
            this.nextSheet("Days", 1, 1, false);
            this.nextRow();
            this.nextHeaderCell("Day");
            this.nextHeaderCell("Start");
            this.nextHeaderCell("End");
            this.nextHeaderCell("Lunch hour start time");
            for (Day dayOfYear : ((MeetingSchedule)this.solution).getDayList()) {
                this.nextRow();
                LocalDate date = LocalDate.ofYearDay(Year.now().getValue(), dayOfYear.getDayOfYear());
                int startMinuteOfDay = 1440;
                int endMinuteOfDay = 0;
                for (TimeGrain timeGrain : ((MeetingSchedule)this.solution).getTimeGrainList()) {
                    if (!timeGrain.getDay().equals(dayOfYear)) continue;
                    startMinuteOfDay = timeGrain.getStartingMinuteOfDay() < startMinuteOfDay ? timeGrain.getStartingMinuteOfDay() : startMinuteOfDay;
                    endMinuteOfDay = timeGrain.getStartingMinuteOfDay() + 15 > endMinuteOfDay ? timeGrain.getStartingMinuteOfDay() + 15 : endMinuteOfDay;
                }
                LocalTime startTime = LocalTime.ofSecondOfDay(startMinuteOfDay * 60);
                LocalTime endTime = LocalTime.ofSecondOfDay(endMinuteOfDay * 60);
                LocalTime lunchHourStartTime = LocalTime.ofSecondOfDay(43200L);
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(date));
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(startTime));
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(endTime));
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(lunchHourStartTime));
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeRooms() {
            this.nextSheet("Rooms", 1, 1, false);
            this.nextRow();
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Capacity");
            for (Room room : ((MeetingSchedule)this.solution).getRoomList()) {
                this.nextRow();
                this.nextCell().setCellValue(room.getName());
                this.nextCell().setCellValue((double)room.getCapacity());
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeRoomsView() {
            this.nextSheet("Rooms view", 1, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeGrainDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Room");
            this.writeTimeGrainHoursHeaders();
            for (Room room : ((MeetingSchedule)this.solution).getRoomList()) {
                this.nextRow();
                this.currentRow.setHeightInPoints(2.0f * this.currentSheet.getDefaultRowHeightInPoints());
                this.nextCell().setCellValue(room.getName());
                List<MeetingAssignment> roomMeetingAssignmentList = ((MeetingSchedule)this.solution).getMeetingAssignmentList().stream().filter(meetingAssignment -> meetingAssignment.getRoom() == room).collect(Collectors.toList());
                this.writeMeetingAssignmentList(roomMeetingAssignmentList);
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writePersonsView() {
            this.nextSheet("Persons view", 2, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.writeTimeGrainDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Person");
            this.nextHeaderCell("Attendance");
            this.writeTimeGrainHoursHeaders();
            for (Person person : ((MeetingSchedule)this.solution).getPersonList()) {
                this.writePersonMeetingList(person, true);
                this.writePersonMeetingList(person, false);
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writePersonMeetingList(Person person, boolean required) {
            this.nextRow();
            this.currentRow.setHeightInPoints(2.0f * this.currentSheet.getDefaultRowHeightInPoints());
            this.nextHeaderCell(person.getFullName());
            if (required) {
                this.nextHeaderCell("Required");
            } else {
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber - 1, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber));
                this.nextHeaderCell("Preferred");
            }
            List personMeetingList = required ? ((MeetingSchedule)this.solution).getAttendanceList().stream().filter(attendance -> attendance.getPerson().equals(person) && attendance instanceof RequiredAttendance).map(Attendance::getMeeting).collect(Collectors.toList()) : ((MeetingSchedule)this.solution).getAttendanceList().stream().filter(attendance -> attendance.getPerson().equals(person) && attendance instanceof PreferredAttendance).map(Attendance::getMeeting).collect(Collectors.toList());
            List<MeetingAssignment> personMeetingAssignmentList = ((MeetingSchedule)this.solution).getMeetingAssignmentList().stream().filter(meetingAssignment -> personMeetingList.contains(meetingAssignment.getMeeting())).collect(Collectors.toList());
            this.writeMeetingAssignmentList(personMeetingAssignmentList);
        }

        private void writePrintedFormView() {
            this.nextSheet("Printed form view", 1, 1, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeGrainsHoursVertically(30);
            this.currentColumnNumber = 0;
            for (Room room : ((MeetingSchedule)this.solution).getRoomList()) {
                List<MeetingAssignment> roomMeetingAssignmentList = ((MeetingSchedule)this.solution).getMeetingAssignmentList().stream().filter(meetingAssignment -> meetingAssignment.getRoom() == room).collect(Collectors.toList());
                if (roomMeetingAssignmentList.isEmpty()) continue;
                ++this.currentColumnNumber;
                this.currentRowNumber = -1;
                this.nextHeaderCellVertically(room.getName());
                this.writeMeetingAssignmentListVertically(roomMeetingAssignmentList);
            }
            this.setSizeColumnsWithHeader(6000);
        }

        private void writeMeetingAssignmentListVertically(List<MeetingAssignment> roomMeetingAssignmentList) {
            int mergeStart = -1;
            int previousMeetingRemainingTimeGrains = 0;
            boolean mergingPreviousTimeGrain = false;
            for (TimeGrain timeGrain : ((MeetingSchedule)this.solution).getTimeGrainList()) {
                List<MeetingAssignment> meetingAssignmentList = roomMeetingAssignmentList.stream().filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() == timeGrain).collect(Collectors.toList());
                if (meetingAssignmentList.isEmpty() && mergingPreviousTimeGrain && previousMeetingRemainingTimeGrains > 0) {
                    --previousMeetingRemainingTimeGrains;
                    this.nextCellVertically();
                    continue;
                }
                if (mergingPreviousTimeGrain && mergeStart < this.currentRowNumber) {
                    this.currentSheet.addMergedRegion(new CellRangeAddress(mergeStart, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber));
                }
                StringBuilder meetingInfo = new StringBuilder();
                for (MeetingAssignment meetingAssignment2 : meetingAssignmentList) {
                    String startTimeString = this.getTimeString(meetingAssignment2.getStartingTimeGrain().getStartingMinuteOfDay());
                    int lastTimeGrainIndex = meetingAssignment2.getLastTimeGrainIndex() <= ((MeetingSchedule)this.solution).getTimeGrainList().size() - 1 ? meetingAssignment2.getLastTimeGrainIndex() : ((MeetingSchedule)this.solution).getTimeGrainList().size() - 1;
                    String endTimeString = this.getTimeString(((MeetingSchedule)this.solution).getTimeGrainList().get(lastTimeGrainIndex).getStartingMinuteOfDay() + 15);
                    meetingInfo.append(StringUtils.abbreviate((String)meetingAssignment2.getMeeting().getTopic(), (int)150)).append("\n  ").append(meetingAssignment2.getMeeting().getSpeakerList().stream().map(Person::getFullName).collect(Collectors.joining(", "))).append("\n  ").append(startTimeString).append(" - ").append(endTimeString).append(" (").append(meetingAssignment2.getMeeting().getDurationInGrains() * 15).append(" mins)");
                }
                this.nextCellVertically().setCellValue(meetingInfo.toString());
                previousMeetingRemainingTimeGrains = this.getLongestDurationInGrains(meetingAssignmentList) - 1;
                mergingPreviousTimeGrain = previousMeetingRemainingTimeGrains > 0;
                mergeStart = this.currentRowNumber;
            }
            if (mergeStart < this.currentRowNumber) {
                this.currentSheet.addMergedRegion(new CellRangeAddress(mergeStart, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber));
            }
        }

        private String getTimeString(int minuteOfDay) {
            return AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(LocalTime.ofSecondOfDay(minuteOfDay * 60));
        }

        private void writeMeetingAssignmentList(List<MeetingAssignment> meetingAssignmentList) {
            String[] filteredConstraintNames = new String[]{"Room conflict", "Don't go in overtime", "Required attendance conflict", "Required room capacity", "Start and end on same day", "Required and preferred attendance conflict", "Preferred attendance conflict", "Do all meetings as soon as possible", "One TimeGrain break between two consecutive meetings", "Overlapping meetings", "Assign larger rooms first", "Room stability"};
            int mergeStart = -1;
            int previousMeetingRemainingTimeGrains = 0;
            boolean mergingPreviousMeetingList = false;
            for (TimeGrain timeGrain : ((MeetingSchedule)this.solution).getTimeGrainList()) {
                List<MeetingAssignment> timeGrainMeetingAssignmentList = meetingAssignmentList.stream().filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() == timeGrain).collect(Collectors.toList());
                if (timeGrainMeetingAssignmentList.isEmpty() && mergingPreviousMeetingList && previousMeetingRemainingTimeGrains > 0) {
                    --previousMeetingRemainingTimeGrains;
                    this.nextCell();
                    continue;
                }
                if (mergingPreviousMeetingList && mergeStart < this.currentColumnNumber) {
                    this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                }
                this.nextMeetingAssignmentListCell(timeGrainMeetingAssignmentList, meetingAssignment -> meetingAssignment.getMeeting().getTopic() + "\n  " + meetingAssignment.getMeeting().getSpeakerList().stream().map(Person::getFullName).collect(Collectors.joining(", ")), Arrays.asList(filteredConstraintNames));
                mergingPreviousMeetingList = !timeGrainMeetingAssignmentList.isEmpty();
                mergeStart = this.currentColumnNumber;
                previousMeetingRemainingTimeGrains = this.getLongestDurationInGrains(timeGrainMeetingAssignmentList) - 1;
            }
            if (mergingPreviousMeetingList && mergeStart < this.currentColumnNumber) {
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
        }

        private int getLongestDurationInGrains(List<MeetingAssignment> meetingAssignmentList) {
            int longestDurationInGrains = 1;
            for (MeetingAssignment meetingAssignment : meetingAssignmentList) {
                if (meetingAssignment.getMeeting().getDurationInGrains() <= longestDurationInGrains) continue;
                longestDurationInGrains = meetingAssignment.getMeeting().getDurationInGrains();
            }
            return longestDurationInGrains;
        }

        private void writeTimeGrainDaysHeaders() {
            Day previousTimeGrainDay = null;
            int mergeStart = -1;
            for (TimeGrain timeGrain : ((MeetingSchedule)this.solution).getTimeGrainList()) {
                Day timeGrainDay = timeGrain.getDay();
                if (timeGrainDay.equals(previousTimeGrainDay)) {
                    this.nextHeaderCell("");
                    continue;
                }
                if (previousTimeGrainDay != null) {
                    this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                }
                this.nextHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(LocalDate.ofYearDay(Year.now().getValue(), timeGrainDay.getDayOfYear())));
                previousTimeGrainDay = timeGrainDay;
                mergeStart = this.currentColumnNumber;
            }
            if (previousTimeGrainDay != null) {
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
        }

        private void writeTimeGrainHoursHeaders() {
            for (TimeGrain timeGrain : ((MeetingSchedule)this.solution).getTimeGrainList()) {
                LocalTime startTime = LocalTime.ofSecondOfDay(timeGrain.getStartingMinuteOfDay() * 60);
                this.nextHeaderCell(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(startTime));
            }
        }

        private void writeTimeGrainsHoursVertically(int minimumInterval) {
            int mergeStart = -1;
            for (TimeGrain timeGrain : ((MeetingSchedule)this.solution).getTimeGrainList()) {
                if ((double)timeGrain.getGrainIndex() % Math.ceil((double)minimumInterval * 1.0 / 15.0) == 0.0) {
                    if (mergeStart > 0) {
                        this.currentSheet.addMergedRegion(new CellRangeAddress(mergeStart, this.currentRowNumber, 0, 0));
                    }
                    this.nextRow();
                    this.nextCell().setCellValue(timeGrain.getDateTimeString());
                    mergeStart = this.currentRowNumber;
                    continue;
                }
                this.nextRow();
            }
            if (mergeStart < this.currentRowNumber) {
                this.currentSheet.addMergedRegion(new CellRangeAddress(mergeStart, this.currentRowNumber, 0, 0));
            }
        }

        void nextMeetingAssignmentListCell(List<MeetingAssignment> meetingAssignmentList, Function<MeetingAssignment, String> stringFunction, List<String> filteredConstraintNames) {
            if (meetingAssignmentList == null) {
                meetingAssignmentList = Collections.emptyList();
            }
            HardMediumSoftScore score = meetingAssignmentList.stream().map(this.indictmentMap::get).filter(Objects::nonNull).flatMap(indictment -> indictment.getConstraintMatchSet().stream()).filter(constraintMatch -> filteredConstraintNames == null || filteredConstraintNames.contains(constraintMatch.getConstraintName())).map(constraintMatch -> (HardMediumSoftScore)constraintMatch.getScore()).filter(indictmentScore -> indictmentScore.getHardScore() < 0 || indictmentScore.getSoftScore() < 0).reduce(Score::add).orElse(HardMediumSoftScore.ZERO);
            XSSFCell cell = this.getXSSFCellOfScore(score);
            if (!meetingAssignmentList.isEmpty()) {
                ClientAnchor anchor = this.creationHelper.createClientAnchor();
                anchor.setCol1(cell.getColumnIndex());
                anchor.setCol2(cell.getColumnIndex() + 4);
                anchor.setRow1(this.currentRow.getRowNum());
                anchor.setRow2(this.currentRow.getRowNum() + 4);
                Comment comment = this.currentDrawing.createCellComment(anchor);
                String commentString = this.getMeetingAssignmentListString(meetingAssignmentList);
                comment.setString(this.creationHelper.createRichTextString(commentString));
                cell.setCellComment(comment);
            }
            cell.setCellValue(meetingAssignmentList.stream().map(stringFunction).collect(Collectors.joining("\n")));
            this.currentRow.setHeightInPoints(Math.max(this.currentRow.getHeightInPoints(), (float)meetingAssignmentList.size() * this.currentSheet.getDefaultRowHeightInPoints()));
        }

        private String getMeetingAssignmentListString(List<MeetingAssignment> meetingAssignmentList) {
            StringBuilder commentString = new StringBuilder(meetingAssignmentList.size() * 200);
            for (MeetingAssignment meetingAssignment : meetingAssignmentList) {
                commentString.append("Date and Time: ").append(meetingAssignment.getStartingTimeGrain().getDateTimeString()).append("\n").append("Duration: ").append(meetingAssignment.getMeeting().getDurationInGrains() * 15).append(" minutes.\n").append("Room: ").append(meetingAssignment.getRoom().getName()).append("\n");
                Indictment indictment = (Indictment)this.indictmentMap.get(meetingAssignment);
                if (indictment != null) {
                    commentString.append("\n").append(indictment.getScore().toShortString()).append(" total");
                    Set constraintMatchSet = indictment.getConstraintMatchSet();
                    List constraintNameList = constraintMatchSet.stream().map(ConstraintMatch::getConstraintName).distinct().collect(Collectors.toList());
                    for (String constraintName : constraintNameList) {
                        List filteredConstraintMatchList = constraintMatchSet.stream().filter(constraintMatch -> constraintMatch.getConstraintName().equals(constraintName)).collect(Collectors.toList());
                        HardMediumSoftScore sum = filteredConstraintMatchList.stream().map(constraintMatch -> (HardMediumSoftScore)constraintMatch.getScore()).reduce(HardMediumSoftScore::add).orElse(HardMediumSoftScore.ZERO);
                        String justificationTalkCodes = filteredConstraintMatchList.stream().flatMap(constraintMatch -> constraintMatch.getJustificationList().stream()).filter(justification -> justification instanceof MeetingAssignment && justification != meetingAssignment).distinct().map(o -> Long.toString(((MeetingAssignment)o).getMeeting().getId())).collect(Collectors.joining(", "));
                        commentString.append("\n    ").append(sum.toShortString()).append(" for ").append(filteredConstraintMatchList.size()).append(" ").append(constraintName).append("s").append("\n        ").append(justificationTalkCodes);
                    }
                }
                commentString.append("\n\n");
            }
            return commentString.toString();
        }

        private XSSFCell getXSSFCellOfScore(HardMediumSoftScore score) {
            XSSFCell cell = !score.isFeasible() ? this.nextCell(this.hardPenaltyStyle) : (score.getMediumScore() < 0 ? this.nextCell(this.mediumPenaltyStyle) : (score.getSoftScore() < 0 ? this.nextCell(this.softPenaltyStyle) : this.nextCell(this.wrappedStyle)));
            return cell;
        }
    }

    private static class MeetingSchedulingXlsxReader
    extends AbstractXlsxSolutionFileIO.AbstractXlsxReader<MeetingSchedule> {
        MeetingSchedulingXlsxReader(XSSFWorkbook workbook) {
            super(workbook, "org/optaplanner/examples/meetingscheduling/solver/meetingSchedulingSolverConfig.xml");
        }

        @Override
        public MeetingSchedule read() {
            this.solution = new MeetingSchedule();
            this.readConfiguration();
            this.readDayList();
            this.readRoomList();
            this.readPersonList();
            this.readMeetingList();
            return (MeetingSchedule)this.solution;
        }

        private void readConfiguration() {
            this.nextSheet("Configuration");
            this.nextRow();
            this.nextRow(true);
            this.readHeaderCell("Constraint");
            this.readHeaderCell("Weight");
            this.readHeaderCell("Description");
            MeetingConstraintConfiguration constraintConfiguration = new MeetingConstraintConfiguration();
            constraintConfiguration.setId(0L);
            this.readIntConstraintParameterLine("Room conflict", hardScore -> constraintConfiguration.setRoomConflict(HardMediumSoftScore.ofHard((int)hardScore)), "");
            this.readIntConstraintParameterLine("Don't go in overtime", hardScore -> constraintConfiguration.setDontGoInOvertime(HardMediumSoftScore.ofHard((int)hardScore)), "");
            this.readIntConstraintParameterLine("Required attendance conflict", hardScore -> constraintConfiguration.setRequiredAttendanceConflict(HardMediumSoftScore.ofHard((int)hardScore)), "");
            this.readIntConstraintParameterLine("Required room capacity", hardScore -> constraintConfiguration.setRequiredRoomCapacity(HardMediumSoftScore.ofHard((int)hardScore)), "");
            this.readIntConstraintParameterLine("Start and end on same day", hardScore -> constraintConfiguration.setStartAndEndOnSameDay(HardMediumSoftScore.ofHard((int)hardScore)), "");
            this.readIntConstraintParameterLine("Required and preferred attendance conflict", mediumScore -> constraintConfiguration.setRequiredAndPreferredAttendanceConflict(HardMediumSoftScore.ofMedium((int)mediumScore)), "");
            this.readIntConstraintParameterLine("Preferred attendance conflict", mediumScore -> constraintConfiguration.setPreferredAttendanceConflict(HardMediumSoftScore.ofMedium((int)mediumScore)), "");
            this.readIntConstraintParameterLine("Do all meetings as soon as possible", softScore -> constraintConfiguration.setDoAllMeetingsAsSoonAsPossible(HardMediumSoftScore.ofSoft((int)softScore)), "");
            this.readIntConstraintParameterLine("One TimeGrain break between two consecutive meetings", softScore -> constraintConfiguration.setOneTimeGrainBreakBetweenTwoConsecutiveMeetings(HardMediumSoftScore.ofSoft((int)softScore)), "");
            this.readIntConstraintParameterLine("Overlapping meetings", softScore -> constraintConfiguration.setOverlappingMeetings(HardMediumSoftScore.ofSoft((int)softScore)), "");
            this.readIntConstraintParameterLine("Assign larger rooms first", softScore -> constraintConfiguration.setAssignLargerRoomsFirst(HardMediumSoftScore.ofSoft((int)softScore)), "");
            this.readIntConstraintParameterLine("Room stability", softScore -> constraintConfiguration.setRoomStability(HardMediumSoftScore.ofSoft((int)softScore)), "");
            ((MeetingSchedule)this.solution).setConstraintConfiguration(constraintConfiguration);
        }

        private void readPersonList() {
            this.nextSheet("Persons");
            this.nextRow(false);
            this.readHeaderCell("Full name");
            ArrayList<Person> personList = new ArrayList<Person>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Person person = new Person();
                person.setId(id++);
                person.setFullName(this.nextStringCell().getStringCellValue());
                if (!VALID_NAME_PATTERN.matcher(person.getFullName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The person name (" + person.getFullName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                personList.add(person);
            }
            ((MeetingSchedule)this.solution).setPersonList(personList);
        }

        private void readMeetingList() {
            Map<String, Person> personMap = ((MeetingSchedule)this.solution).getPersonList().stream().collect(Collectors.toMap(Person::getFullName, person -> person));
            this.nextSheet("Meetings");
            this.nextRow(false);
            this.readHeaderCell("Topic");
            this.readHeaderCell("Group");
            this.readHeaderCell("Duration");
            this.readHeaderCell("Speakers");
            this.readHeaderCell("Content");
            this.readHeaderCell("Required attendance list");
            this.readHeaderCell("Preferred attendance list");
            this.readHeaderCell("Day");
            this.readHeaderCell("Starting time");
            this.readHeaderCell("Room");
            ArrayList<Meeting> meetingList = new ArrayList<Meeting>(this.currentSheet.getLastRowNum() - 1);
            ArrayList<MeetingAssignment> meetingAssignmentList = new ArrayList<MeetingAssignment>(this.currentSheet.getLastRowNum() - 1);
            ArrayList<Attendance> attendanceList = new ArrayList<Attendance>(this.currentSheet.getLastRowNum() - 1);
            long meetingId = 0L;
            long meetingAssignmentId = 0L;
            long attendanceId = 0L;
            Map<LocalDateTime, TimeGrain> timeGrainMap = ((MeetingSchedule)this.solution).getTimeGrainList().stream().collect(Collectors.toMap(TimeGrain::getDateTime, Function.identity()));
            Map<String, Room> roomMap = ((MeetingSchedule)this.solution).getRoomList().stream().collect(Collectors.toMap(Room::getName, Function.identity()));
            while (this.nextRow()) {
                Meeting meeting = new Meeting();
                ArrayList<Attendance> speakerAttendanceList = new ArrayList<Attendance>();
                HashSet<Person> speakerSet = new HashSet<Person>();
                MeetingAssignment meetingAssignment = new MeetingAssignment();
                meeting.setId(meetingId++);
                meetingAssignment.setId(meetingAssignmentId++);
                meeting.setTopic(this.nextStringCell().getStringCellValue());
                meeting.setEntireGroupMeeting(this.nextStringCell().getStringCellValue().toLowerCase().equals("y"));
                this.readMeetingDuration(meeting);
                this.readSpeakerList(personMap, meeting, speakerAttendanceList, speakerSet);
                meeting.setContent(this.nextStringCell().getStringCellValue());
                if (meeting.isEntireGroupMeeting()) {
                    ArrayList requiredAttendanceList = new ArrayList(((MeetingSchedule)this.solution).getPersonList().size());
                    for (Person person2 : ((MeetingSchedule)this.solution).getPersonList()) {
                        RequiredAttendance requiredAttendance = new RequiredAttendance();
                        requiredAttendance.setPerson(person2);
                        requiredAttendance.setMeeting(meeting);
                        requiredAttendance.setId(attendanceId++);
                        requiredAttendanceList.add(requiredAttendance);
                        attendanceList.add(requiredAttendance);
                    }
                    meeting.setRequiredAttendanceList(requiredAttendanceList);
                    meeting.setPreferredAttendanceList(new ArrayList<PreferredAttendance>());
                } else {
                    for (Attendance speakerAttendance : speakerAttendanceList) {
                        speakerAttendance.setId(attendanceId++);
                    }
                    attendanceList.addAll(speakerAttendanceList);
                    List<Attendance> meetingAttendanceList = this.getAttendanceLists(meeting, personMap, attendanceId, speakerSet);
                    attendanceId += (long)meetingAttendanceList.size();
                    attendanceList.addAll(meetingAttendanceList);
                }
                meetingAssignment.setStartingTimeGrain(this.extractTimeGrain(meeting, timeGrainMap));
                meetingAssignment.setRoom(this.extractRoom(meeting, roomMap));
                meetingList.add(meeting);
                meetingAssignment.setMeeting(meeting);
                meetingAssignmentList.add(meetingAssignment);
            }
            ((MeetingSchedule)this.solution).setMeetingList(meetingList);
            ((MeetingSchedule)this.solution).setMeetingAssignmentList(meetingAssignmentList);
            ((MeetingSchedule)this.solution).setAttendanceList(attendanceList);
        }

        private void readSpeakerList(Map<String, Person> personMap, Meeting meeting, List<Attendance> speakerAttendanceList, Set<Person> speakerSet) {
            meeting.setSpeakerList(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(speaker -> !speaker.isEmpty()).map(speakerName -> {
                Person speaker = (Person)personMap.get(speakerName);
                if (speaker == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a speaker (" + speakerName + ") that doesn't exist in the Persons list.");
                }
                if (speakerSet.contains(speaker)) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a duplicate speaker (" + speakerName + ").");
                }
                speakerSet.add(speaker);
                RequiredAttendance speakerAttendance = new RequiredAttendance();
                speakerAttendance.setMeeting(meeting);
                speakerAttendance.setPerson(speaker);
                speakerAttendanceList.add(speakerAttendance);
                return speaker;
            }).collect(Collectors.toList()));
        }

        private void readMeetingDuration(Meeting meeting) {
            double durationDouble = this.nextNumericCell().getNumericCellValue();
            if (durationDouble <= 0.0 || durationDouble != Math.floor(durationDouble)) {
                throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ")'s has a duration (" + durationDouble + ") that isn't a strictly positive integer number.");
            }
            if (durationDouble % 15.0 != 0.0) {
                throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a duration (" + durationDouble + ") that isn't a multiple of " + 15 + ".");
            }
            meeting.setDurationInGrains((int)durationDouble / 15);
        }

        private List<Attendance> getAttendanceLists(Meeting meeting, Map<String, Person> personMap, long attendanceId, Set<Person> speakerSet) {
            ArrayList<Attendance> attendanceList = new ArrayList<Attendance>(this.currentSheet.getLastRowNum() - 1);
            HashSet<Person> requiredPersonSet = new HashSet<Person>();
            List<RequiredAttendance> requiredAttendanceList = this.getRequiredAttendanceList(meeting, personMap, speakerSet, requiredPersonSet);
            for (RequiredAttendance requiredAttendance : requiredAttendanceList) {
                requiredAttendance.setId(attendanceId++);
            }
            meeting.setRequiredAttendanceList(requiredAttendanceList);
            attendanceList.addAll(requiredAttendanceList);
            List<PreferredAttendance> preferredAttendanceList = this.getPreferredAttendanceList(meeting, personMap, speakerSet, requiredPersonSet);
            for (PreferredAttendance preferredAttendance : preferredAttendanceList) {
                preferredAttendance.setId(attendanceId++);
            }
            meeting.setPreferredAttendanceList(preferredAttendanceList);
            attendanceList.addAll(preferredAttendanceList);
            return attendanceList;
        }

        private List<RequiredAttendance> getRequiredAttendanceList(Meeting meeting, Map<String, Person> personMap, Set<Person> speakerSet, Set<Person> requiredPersonSet) {
            return Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(requiredAttendee -> !requiredAttendee.isEmpty()).map(personName -> {
                RequiredAttendance requiredAttendance = new RequiredAttendance();
                Person person = (Person)personMap.get(personName);
                if (person == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a required attendee (" + personName + ") that doesn't exist in the Persons list.");
                }
                if (requiredPersonSet.contains(person)) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a duplicate required attendee (" + personName + ").");
                }
                if (speakerSet.contains(person)) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a required attendee  (" + personName + ") who is also the speaker.");
                }
                requiredPersonSet.add(person);
                requiredAttendance.setMeeting(meeting);
                requiredAttendance.setPerson(person);
                return requiredAttendance;
            }).collect(Collectors.toList());
        }

        private List<PreferredAttendance> getPreferredAttendanceList(Meeting meeting, Map<String, Person> personMap, Set<Person> speakerSet, Set<Person> requiredPersonSet) {
            HashSet preferredPersonSet = new HashSet();
            return Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(preferredAttendee -> !preferredAttendee.isEmpty()).map(personName -> {
                PreferredAttendance preferredAttendance = new PreferredAttendance();
                Person person = (Person)personMap.get(personName);
                if (person == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a preferred attendee (" + personName + ") that doesn't exist in the Persons list.");
                }
                if (preferredPersonSet.contains(person)) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a duplicate preferred attendee (" + personName + ").");
                }
                if (requiredPersonSet.contains(person)) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a preferred attendee (" + personName + ") that is also a required attendee.");
                }
                if (speakerSet.contains(person)) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a preferred attendee  (" + personName + ") who is also the speaker.");
                }
                preferredPersonSet.add(person);
                preferredAttendance.setMeeting(meeting);
                preferredAttendance.setPerson(person);
                return preferredAttendance;
            }).collect(Collectors.toList());
        }

        private TimeGrain extractTimeGrain(Meeting meeting, Map<LocalDateTime, TimeGrain> timeGrainMap) {
            String dateString = this.nextStringCell().getStringCellValue();
            String startTimeString = this.nextStringCell().getStringCellValue();
            if (!dateString.isEmpty() || !startTimeString.isEmpty()) {
                LocalDateTime dateTime;
                try {
                    dateTime = LocalDateTime.of(LocalDate.parse(dateString, AbstractXlsxSolutionFileIO.DAY_FORMATTER), LocalTime.parse(startTimeString, AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                }
                catch (DateTimeParseException e) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a timeGrain date (" + dateString + ") and startTime (" + startTimeString + ") that doesn't parse as a date or time.", e);
                }
                TimeGrain timeGrain = timeGrainMap.get(dateTime);
                if (timeGrain == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a timeGrain date (" + dateString + ") and startTime (" + startTimeString + ") that doesn't exist in the other sheet (Day).");
                }
                return timeGrain;
            }
            return null;
        }

        private Room extractRoom(Meeting meeting, Map<String, Room> roomMap) {
            String roomName = this.nextStringCell().getStringCellValue();
            if (!roomName.isEmpty()) {
                Room room = roomMap.get(roomName);
                if (room == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The meeting with id (" + meeting.getId() + ") has a roomName (" + roomName + ") that doesn't exist in the other sheet (Rooms).");
                }
                return room;
            }
            return null;
        }

        private void readDayList() {
            this.nextSheet("Days");
            this.nextRow(false);
            this.readHeaderCell("Day");
            this.readHeaderCell("Start");
            this.readHeaderCell("End");
            ArrayList<Day> dayList = new ArrayList<Day>(this.currentSheet.getLastRowNum() - 1);
            ArrayList<TimeGrain> timeGrainList = new ArrayList<TimeGrain>();
            long dayId = 0L;
            long timeGrainId = 0L;
            while (this.nextRow()) {
                Day day = new Day();
                day.setId(dayId++);
                day.setDayOfYear(LocalDate.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.DAY_FORMATTER).getDayOfYear());
                dayList.add(day);
                LocalTime startTime = LocalTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.TIME_FORMATTER);
                LocalTime endTime = LocalTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.TIME_FORMATTER);
                LocalTime lunchHourStartTime = LocalTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.TIME_FORMATTER);
                int startMinuteOfDay = startTime.getHour() * 60 + startTime.getMinute();
                int endMinuteOfDay = endTime.getHour() * 60 + endTime.getMinute();
                int lunchHourStartMinuteOfDay = lunchHourStartTime.getHour() * 60 + lunchHourStartTime.getMinute();
                int i = 0;
                while (endMinuteOfDay - startMinuteOfDay > i * 15) {
                    int timeGrainStartingMinuteOfDay = i * 15 + startMinuteOfDay;
                    if (timeGrainStartingMinuteOfDay < lunchHourStartMinuteOfDay || timeGrainStartingMinuteOfDay >= lunchHourStartMinuteOfDay + 60) {
                        TimeGrain timeGrain = new TimeGrain();
                        timeGrain.setId(timeGrainId);
                        timeGrain.setGrainIndex((int)timeGrainId++);
                        timeGrain.setDay(day);
                        timeGrain.setStartingMinuteOfDay(timeGrainStartingMinuteOfDay);
                        timeGrainList.add(timeGrain);
                    }
                    ++i;
                }
            }
            ((MeetingSchedule)this.solution).setDayList(dayList);
            ((MeetingSchedule)this.solution).setTimeGrainList(timeGrainList);
        }

        private void readRoomList() {
            this.nextSheet("Rooms");
            this.nextRow();
            this.readHeaderCell("Name");
            this.readHeaderCell("Capacity");
            ArrayList<Room> roomList = new ArrayList<Room>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Room room = new Room();
                room.setId(id++);
                room.setName(this.nextStringCell().getStringCellValue());
                if (!VALID_NAME_PATTERN.matcher(room.getName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The room name (" + room.getName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                double capacityDouble = this.nextNumericCell().getNumericCellValue();
                if (capacityDouble <= 0.0 || capacityDouble != Math.floor(capacityDouble)) {
                    throw new IllegalStateException(this.currentPosition() + ": The room with name (" + room.getName() + ") has a capacity (" + capacityDouble + ") that isn't a strictly positive integer number.");
                }
                room.setCapacity((int)capacityDouble);
                roomList.add(room);
            }
            ((MeetingSchedule)this.solution).setRoomList(roomList);
        }
    }
}

