/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain.solver;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.examination.domain.Topic;

public class TopicConflict
implements Serializable,
Comparable<TopicConflict> {
    private static final Comparator<Topic> TOPIC_COMPARATOR = Comparator.comparingLong(AbstractPersistable::getId);
    private static final Comparator<TopicConflict> COMPARATOR = Comparator.comparing(TopicConflict::getLeftTopic, TOPIC_COMPARATOR).thenComparing(TopicConflict::getRightTopic, TOPIC_COMPARATOR);
    private Topic leftTopic;
    private Topic rightTopic;
    private int studentSize;

    public TopicConflict(Topic leftTopic, Topic rightTopic, int studentSize) {
        this.leftTopic = leftTopic;
        this.rightTopic = rightTopic;
        this.studentSize = studentSize;
    }

    public Topic getLeftTopic() {
        return this.leftTopic;
    }

    public void setLeftTopic(Topic leftTopic) {
        this.leftTopic = leftTopic;
    }

    public Topic getRightTopic() {
        return this.rightTopic;
    }

    public void setRightTopic(Topic rightTopic) {
        this.rightTopic = rightTopic;
    }

    public int getStudentSize() {
        return this.studentSize;
    }

    public void setStudentSize(int studentSize) {
        this.studentSize = studentSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TopicConflict) {
            TopicConflict other = (TopicConflict)o;
            return new EqualsBuilder().append((Object)this.leftTopic, (Object)other.leftTopic).append((Object)this.rightTopic, (Object)other.rightTopic).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftTopic).append((Object)this.rightTopic).toHashCode();
    }

    @Override
    public int compareTo(TopicConflict other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.leftTopic + " & " + this.rightTopic + " = " + this.studentSize;
    }
}

