/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.solver.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.machinereassignment.domain.MrBalancePenalty;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.solver.MrServiceDependency;

public class MachineReassignmentConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.maximumCapacity(factory), this.serviceConflict(factory), this.serviceLocationSpread(factory), this.serviceDependency(factory), this.transientUsage(factory), this.loadCost(factory), this.balanceCost(factory), this.processMoveCost(factory), this.serviceMoveCost(factory), this.machineMoveCost(factory)};
    }

    private Constraint maximumCapacity(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).join(MrProcessAssignment.class, Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getMaximumCapacity() < usage).penalizeLong("maximumCapacity", (Score)HardSoftLongScore.ONE_HARD, (machineCapacity, usage) -> usage - machineCapacity.getMaximumCapacity());
    }

    private Constraint serviceConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(MrProcessAssignment.class, Joiners.equal(MrProcessAssignment::getMachine), Joiners.equal(MrProcessAssignment::getService)).penalize("serviceConflict", (Score)HardSoftLongScore.ONE_HARD);
    }

    private Constraint serviceLocationSpread(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).groupBy(MrProcessAssignment::getService, ConstraintCollectors.countDistinct(MrProcessAssignment::getLocation)).filter((service, distinctLocationCount) -> service.getLocationSpread() > distinctLocationCount).penalize("serviceLocationSpread", (Score)HardSoftLongScore.ONE_HARD);
    }

    private Constraint serviceDependency(ConstraintFactory factory) {
        return factory.from(MrServiceDependency.class).join(MrProcessAssignment.class, Joiners.equal(MrServiceDependency::getFromService, MrProcessAssignment::getService)).ifExists(MrProcessAssignment.class, Joiners.equal((serviceDependency, processFrom) -> serviceDependency.getToService(), MrProcessAssignment::getService), Joiners.filtering((serviceDependency, processFrom, processTo) -> !processFrom.getNeighborhood().equals(processTo.getNeighborhood()))).penalize("serviceDependency", (Score)HardSoftLongScore.ONE_HARD);
    }

    private Constraint transientUsage(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).filter(MrMachineCapacity::isTransientlyConsumed).join(factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved), Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getOriginalMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getMaximumCapacity() < usage).penalizeLong("transientUsage", (Score)HardSoftLongScore.ONE_HARD, (machineCapacity, usage) -> machineCapacity.getMaximumCapacity() - usage);
    }

    private Constraint loadCost(ConstraintFactory factory) {
        return factory.from(MrMachineCapacity.class).join(MrProcessAssignment.class, Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getSafetyCapacity() < usage).penalizeLong("loadCost", (Score)HardSoftLongScore.ONE_SOFT, (machineCapacity, usage) -> usage - machineCapacity.getSafetyCapacity());
    }

    private Constraint balanceCost(ConstraintFactory factory) {
        return factory.from(MrBalancePenalty.class).join(MrProcessAssignment.class).groupBy((penalty, processAssignment) -> penalty, (penalty, processAssignment) -> processAssignment.getMachine(), ConstraintCollectors.sumLong((penalty, processAssignment) -> processAssignment.getUsage(penalty.getOriginResource())), ConstraintCollectors.sumLong((penalty, processAssignment) -> processAssignment.getUsage(penalty.getTargetResource()))).penalizeLong("balanceCost", (Score)HardSoftLongScore.ONE_SOFT, this::balanceCost);
    }

    private long balanceCost(MrBalancePenalty penalty, MrMachine machine, long originalUsage, long targetUsage) {
        long originalAvailability = machine.getMachineCapacity(penalty.getOriginResource()).getMaximumCapacity() - originalUsage;
        long targetAvailability = machine.getMachineCapacity(penalty.getTargetResource()).getMaximumCapacity() - targetUsage;
        long balanceCost = (long)penalty.getMultiplicand() * originalAvailability - targetAvailability;
        return Math.max(0L, balanceCost);
    }

    private Constraint processMoveCost(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved).penalizeLong("processMoveCost", (Score)HardSoftLongScore.ONE_SOFT, MrProcessAssignment::getProcessMoveCost);
    }

    private Constraint serviceMoveCost(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved).groupBy(processAssignment -> processAssignment.getService(), ConstraintCollectors.count()).groupBy(ConstraintCollectors.max((service, count) -> count)).penalizeLong("serviceMoveCost", (Score)HardSoftLongScore.ONE_SOFT, count -> count.intValue());
    }

    private Constraint machineMoveCost(ConstraintFactory factory) {
        return factory.from(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved).penalizeLong("machineMoveCost", (Score)HardSoftLongScore.ONE_SOFT, MrProcessAssignment::getMachineMoveCost);
    }
}

