/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.rocktour.domain.RockTourSolution;
import org.optaplanner.examples.rocktour.persistence.RockTourXlsxFileIO;
import org.optaplanner.examples.rocktour.swingui.RockTourWorldPanel;

public class RockTourPanel
extends SolutionPanel<RockTourSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/rocktour/swingui/rockTourLogo.png";
    private RockTourWorldPanel rockTourWorldPanel;

    public RockTourPanel() {
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton button = new JButton("Show in LibreOffice or Excel");
        button.addActionListener(event -> {
            File tempFile;
            RockTourXlsxFileIO solutionFileIO = new RockTourXlsxFileIO();
            try {
                tempFile = File.createTempFile(this.solutionBusiness.getSolutionFileName(), "." + solutionFileIO.getOutputFileExtension());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create temp file.", e);
            }
            solutionFileIO.write(this.solutionBusiness.getSolution(), tempFile);
            try {
                Desktop.getDesktop().open(tempFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to show temp file (" + tempFile + ") in LibreOffice or Excel.", e);
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(new JLabel("Changes to that file are ignored unless you explicitly save it there and open it here."));
        this.add((Component)buttonPanel, "North");
        this.rockTourWorldPanel = new RockTourWorldPanel(this);
        this.add((Component)this.rockTourWorldPanel, "Center");
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public void resetPanel(RockTourSolution solution) {
        this.rockTourWorldPanel.resetPanel(solution);
    }

    @Override
    public void updatePanel(RockTourSolution solution) {
        this.rockTourWorldPanel.updatePanel(solution);
    }
}

