/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.taskassigning.domain.Affinity;
import org.optaplanner.examples.taskassigning.domain.Customer;
import org.optaplanner.examples.taskassigning.domain.Employee;
import org.optaplanner.examples.taskassigning.domain.Priority;
import org.optaplanner.examples.taskassigning.domain.Skill;
import org.optaplanner.examples.taskassigning.domain.TaskOrEmployee;
import org.optaplanner.examples.taskassigning.domain.TaskType;
import org.optaplanner.examples.taskassigning.domain.solver.StartTimeUpdatingVariableListener;
import org.optaplanner.examples.taskassigning.domain.solver.TaskDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=TaskDifficultyComparator.class)
@XStreamAlias(value="TaTask")
public class Task
extends TaskOrEmployee
implements Labeled {
    private TaskType taskType;
    private int indexInTaskType;
    private Customer customer;
    private int readyTime;
    private Priority priority;
    @PlanningPin
    private boolean pinned;
    @PlanningVariable(valueRangeProviderRefs={"employeeRange", "taskRange"}, graphType=PlanningVariableGraphType.CHAINED)
    private TaskOrEmployee previousTaskOrEmployee;
    @AnchorShadowVariable(sourceVariableName="previousTaskOrEmployee")
    private Employee employee;
    @CustomShadowVariable(variableListenerClass=StartTimeUpdatingVariableListener.class, sources={@PlanningVariableReference(variableName="previousTaskOrEmployee")})
    private Integer startTime;

    public Task() {
    }

    public Task(long id, TaskType taskType, int indexInTaskType, Customer customer, int readyTime, Priority priority) {
        super(id);
        this.taskType = taskType;
        this.indexInTaskType = indexInTaskType;
        this.customer = customer;
        this.readyTime = readyTime;
        this.priority = priority;
        this.pinned = false;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    public int getIndexInTaskType() {
        return this.indexInTaskType;
    }

    public void setIndexInTaskType(int indexInTaskType) {
        this.indexInTaskType = indexInTaskType;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public int getReadyTime() {
        return this.readyTime;
    }

    public void setReadyTime(int readyTime) {
        this.readyTime = readyTime;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public TaskOrEmployee getPreviousTaskOrEmployee() {
        return this.previousTaskOrEmployee;
    }

    public void setPreviousTaskOrEmployee(TaskOrEmployee previousTaskOrEmployee) {
        this.previousTaskOrEmployee = previousTaskOrEmployee;
    }

    @Override
    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Integer getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Integer startTime) {
        this.startTime = startTime;
    }

    public int getMissingSkillCount() {
        if (this.employee == null) {
            return 0;
        }
        int count = 0;
        for (Skill skill : this.taskType.getRequiredSkillList()) {
            if (this.employee.getSkillSet().contains(skill)) continue;
            ++count;
        }
        return count;
    }

    public int getDuration() {
        Affinity affinity = this.getAffinity();
        return this.taskType.getBaseDuration() * affinity.getDurationMultiplier();
    }

    public Affinity getAffinity() {
        return this.employee == null ? Affinity.NONE : this.employee.getAffinity(this.customer);
    }

    @Override
    public Integer getEndTime() {
        if (this.startTime == null) {
            return null;
        }
        return this.startTime + this.getDuration();
    }

    public String getCode() {
        return this.taskType + "-" + this.indexInTaskType;
    }

    public String getTitle() {
        return this.taskType.getTitle();
    }

    @Override
    public String getLabel() {
        return this.getCode() + ": " + this.taskType.getTitle();
    }

    public String getToolText() {
        StringBuilder toolText = new StringBuilder();
        toolText.append("<html><center><b>").append(this.getLabel()).append("</b><br/>").append(this.priority.getLabel()).append("<br/><br/>");
        toolText.append("Required skills:<br/>");
        for (Skill skill : this.taskType.getRequiredSkillList()) {
            toolText.append(skill.getLabel()).append("<br/>");
        }
        toolText.append("<br/>Customer:<br/>").append(this.customer.getName()).append("<br/>(").append(this.getAffinity().getLabel()).append(")<br/>");
        toolText.append("</center></html>");
        return toolText.toString();
    }

    @Override
    public String toString() {
        return this.getCode();
    }
}

