/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.AbstractPhaseTest;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.curriculumcourse.app.CurriculumCourseApp;

public abstract class AbstractConstructionHeuristicTest<Solution_>
extends AbstractPhaseTest<Solution_> {
    protected ConstructionHeuristicType constructionHeuristicType;

    protected static <Solution_> Collection<Object[]> buildParameters(CommonApp<Solution_> commonApp, String ... unsolvedFileNames) {
        if (commonApp instanceof CurriculumCourseApp) {
            ArrayList<ConstructionHeuristicType> typeList = new ArrayList<ConstructionHeuristicType>();
            for (ConstructionHeuristicType type : ConstructionHeuristicType.values()) {
                if (type == ConstructionHeuristicType.ALLOCATE_TO_VALUE_FROM_QUEUE) continue;
                typeList.add(type);
            }
            return AbstractConstructionHeuristicTest.buildParameters(commonApp, (Enum[])((Enum[])typeList.toArray(new ConstructionHeuristicType[0])), (String[])unsolvedFileNames);
        }
        return AbstractConstructionHeuristicTest.buildParameters(commonApp, (Enum[])ConstructionHeuristicType.values(), (String[])unsolvedFileNames);
    }

    protected AbstractConstructionHeuristicTest(CommonApp<Solution_> commonApp, File dataFile, ConstructionHeuristicType constructionHeuristicType) {
        super(commonApp, dataFile);
        this.constructionHeuristicType = constructionHeuristicType;
    }

    @Override
    protected SolverFactory<Solution_> buildSolverFactory() {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.commonApp.getSolverConfigResource());
        solverConfig.setTerminationConfig(new TerminationConfig());
        ConstructionHeuristicPhaseConfig constructionHeuristicPhaseConfig = new ConstructionHeuristicPhaseConfig();
        constructionHeuristicPhaseConfig.setConstructionHeuristicType(this.constructionHeuristicType);
        solverConfig.setPhaseConfigList(Arrays.asList(constructionHeuristicPhaseConfig));
        return SolverFactory.create((SolverConfig)solverConfig);
    }
}

